/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.client.event.RegisterModels;
import com.momosoftworks.coldsweat.client.renderer.model.armor.GoatChestplateModel;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class GoatArmorItem
extends ArmorItem {
    public GoatArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> playerModel) {
                RegisterModels.checkForInitModels();
                return switch (armorSlot) {
                    case EquipmentSlot.HEAD -> RegisterModels.GOAT_HELMET_MODEL;
                    case EquipmentSlot.CHEST -> {
                        GoatChestplateModel<?> model = RegisterModels.GOAT_CHESTPLATE_MODEL;
                        ModelPart fluff = model.f_102810_.m_171324_("fluff");
                        float headPitch = entityLiving.m_5686_(Minecraft.m_91087_().m_91296_());
                        fluff.f_104203_ = CSMath.toRadians(CSMath.clamp(headPitch, 0.0f, 60.0f)) / 2.0f;
                        fluff.f_104200_ = fluff.f_104205_ * 2.0f;
                        yield model;
                    }
                    case EquipmentSlot.LEGS -> RegisterModels.GOAT_LEGGINGS_MODEL;
                    case EquipmentSlot.FEET -> RegisterModels.GOAT_BOOTS_MODEL;
                    default -> null;
                };
            }
        });
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.m_150930_(ModItems.GOAT_FUR_BOOTS);
    }
}

