/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.registry.AddRegistriesEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.LoadRegistriesEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ProbeEventBusEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.ConfiguredBlockTemp;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.TempModifierInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncConfigSettingsMessage;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RegistryModifierData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModDimensionTags;
import com.momosoftworks.coldsweat.data.tag.ModEffectTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ConfigLoadingHandler {
    public static final Multimap<RegistryHolder<?>, Holder<RegistryModifierData<?>>> REGISTRY_MODIFIERS = new RegistryMultiMap();
    private static final List<OptionalHolder<?>> OPTIONAL_HOLDERS = new ArrayList();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loadConfigsEvent(ServerConfigsLoadedEvent event) {
        ConfigLoadingHandler.loadConfigs((RegistryAccess)event.getServer().m_206579_());
    }

    public static void loadConfigs(RegistryAccess registryAccess) {
        ConfigSettings.clear();
        BlockTempRegistry.flush();
        RegistryMultiMap registries = new RegistryMultiMap();
        ColdSweat.LOGGER.info("Loading registries from configs...");
        registries.putAll(ConfigLoadingHandler.collectUserRegistries(registryAccess));
        ColdSweat.LOGGER.info("Loading registries from data resources...");
        registries.putAll(ConfigLoadingHandler.collectDataRegistries(registryAccess));
        ConfigLoadingHandler.fillOptionalHolders(registryAccess);
        ConfigLoadingHandler.logAndAddRegistries(registryAccess, registries);
        ColdSweat.LOGGER.info("Loading TOML configs...");
        ConfigSettings.load(registryAccess, false);
        TempModifierInit.buildBlockConfigs();
        ColdSweat.LOGGER.info("Loading BlockTemps...");
        TempModifierInit.buildBlockRegistries();
        TaskScheduler.scheduleServer(() -> ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncConfigSettingsMessage(registryAccess)), 1);
    }

    public static Multimap<RegistryHolder<?>, Holder<? extends ConfigData>> collectDataRegistries(RegistryAccess registryAccess) {
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Failed to load registries from null RegistryAccess");
            return new RegistryMultiMap();
        }
        ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().addAll(((HolderSet.Named)registryAccess.m_175515_(Registry.f_122901_).m_203431_(ModBlockTags.HEARTH_SPREAD_WHITELIST).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding block {} to hearth spread whitelist", holder.get());
            return (Block)holder.get();
        }).toList());
        ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().addAll(((HolderSet.Named)registryAccess.m_175515_(Registry.f_122901_).m_203431_(ModBlockTags.HEARTH_SPREAD_BLACKLIST).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding block {} to hearth spread blacklist", holder.get());
            return (Block)holder.get();
        }).toList());
        ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().addAll(((HolderSet.Named)registryAccess.m_175515_(Registry.f_122901_).m_203431_(ModBlockTags.IGNORE_SLEEP_CHECK).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Disabling sleeping conditions check for block {}", holder.get());
            return (Block)holder.get();
        }).toList());
        ConfigSettings.LAMP_DIMENSIONS.get(registryAccess).addAll(((HolderSet.Named)registryAccess.m_175515_(Registry.f_122818_).m_203431_(ModDimensionTags.SOUL_LAMP_VALID).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Enabling dimension {} for soulspring lamp", holder.m_203334_());
            return (DimensionType)holder.m_203334_();
        }).toList());
        ConfigSettings.INSULATION_BLACKLIST.get().addAll(((HolderSet.Named)registryAccess.m_175515_(Registry.f_122904_).m_203431_(ModItemTags.NOT_INSULATABLE).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding item {} to insulation blacklist", holder.get());
            return (Item)holder.get();
        }).toList());
        ConfigSettings.HEARTH_POTION_BLACKLIST.get().addAll(((HolderSet.Named)registryAccess.m_175515_(Registry.f_122900_).m_203431_(ModEffectTags.HEARTH_BLACKLISTED).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding effect {} to hearth potion blacklist", holder.get());
            return (MobEffect)holder.get();
        }).toList());
        RegistryMultiMap registries = new RegistryMultiMap();
        for (Map.Entry<ResourceLocation, RegistryHolder<?>> entry : ModRegistries.getRegistries().entrySet()) {
            RegistryHolder<?> registry = entry.getValue();
            registryAccess.m_175515_(registry.key()).m_203611_().forEach(holder -> {
                holder.m_203543_().ifPresent(holderKey -> ((ConfigData)holder.m_203334_()).setRegistryKey((ResourceKey<? extends ConfigData>)holderKey));
                registries.put(registry, holder);
            });
        }
        return registries;
    }

    public static Multimap<RegistryHolder<?>, Holder<? extends ConfigData>> collectUserRegistries(RegistryAccess registryAccess) {
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Failed to load registries from null RegistryAccess");
            return new RegistryMultiMap();
        }
        RegistryMultiMap registries = new RegistryMultiMap();
        for (Map.Entry<ResourceLocation, RegistryHolder<?>> entry : ModRegistries.getRegistries().entrySet()) {
            RegistryHolder<?> registry = entry.getValue();
            registries.putAll(registry, ConfigLoadingHandler.parseConfigData(registry, registry.codec(), registryAccess));
        }
        return registries;
    }

    private static void logAndAddRegistries(RegistryAccess registryAccess, Multimap<RegistryHolder<?>, Holder<? extends ConfigData>> registries) {
        ConfigLoadingHandler.setDefaultRegistryPriority(registries);
        ConfigLoadingHandler.loadRegistryModifiers(registryAccess);
        for (Holder holder2 : registries.values()) {
            ((ConfigData)holder2.m_203334_()).setConfigType(ConfigData.Type.JSON);
        }
        LoadRegistriesEvent.Pre event = new LoadRegistriesEvent.Pre(registryAccess, registries, REGISTRY_MODIFIERS);
        MinecraftForge.EVENT_BUS.post((Event)event);
        registries.values().removeIf(holder -> !((ConfigData)holder.get()).areRequiredModsLoaded());
        ConfigLoadingHandler.modifyRegistries(event.getRegistries());
        Collection<Holder<InsulatorData>> insulators = event.getRegistry(ModRegistries.INSULATOR_DATA);
        ConfigLoadingHandler.addInsulatorConfigs(insulators);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulators", insulators.size()), insulators);
        Collection<Holder<FuelData>> fuels = event.getRegistry(ModRegistries.FUEL_DATA);
        ConfigLoadingHandler.addFuelConfigs(fuels);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s fuels", fuels.size()), fuels);
        Collection<Holder<FoodData>> foods = event.getRegistry(ModRegistries.FOOD_DATA);
        ConfigLoadingHandler.addFoodConfigs(foods);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s foods", foods.size()), foods);
        Collection<Holder<ItemTempData>> itemTemps = event.getRegistry(ModRegistries.ITEM_TEMP_DATA);
        ConfigLoadingHandler.addItemTempConfigs(itemTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s item temperatures", itemTemps.size()), itemTemps);
        Collection<Holder<DryingItemData>> dryingItems = event.getRegistry(ModRegistries.DRYING_ITEM_DATA);
        ConfigLoadingHandler.addDryingItemConfigs(dryingItems);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s drying items", dryingItems.size()), dryingItems);
        Collection<Holder<ItemInsulationSlotsData>> insulationSlots = event.getRegistry(ModRegistries.INSULATION_SLOTS_DATA);
        ConfigLoadingHandler.addInsulationSlotConfigs(insulationSlots);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulation slots configs", insulationSlots.size()), insulationSlots);
        Collection<Holder<BlockTempData>> blockTemps = event.getRegistry(ModRegistries.BLOCK_TEMP_DATA);
        ConfigLoadingHandler.addBlockTempConfigs(blockTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s block temperatures", blockTemps.size()), blockTemps);
        Collection<Holder<BiomeTempData>> biomeTemps = event.getRegistry(ModRegistries.BIOME_TEMP_DATA);
        ConfigLoadingHandler.addBiomeTempConfigs(biomeTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s biome temperatures", biomeTemps.size()), biomeTemps);
        Collection<Holder<DimensionTempData>> dimensionTemps = event.getRegistry(ModRegistries.DIMENSION_TEMP_DATA);
        ConfigLoadingHandler.addDimensionTempConfigs(dimensionTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s dimension temperatures", dimensionTemps.size()), dimensionTemps);
        Collection<Holder<StructureTempData>> structureTemps = event.getRegistry(ModRegistries.STRUCTURE_TEMP_DATA);
        ConfigLoadingHandler.addStructureTempConfigs(structureTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s structure temperatures", structureTemps.size()), structureTemps);
        Collection<Holder<DepthTempData>> depthTemps = event.getRegistry(ModRegistries.DEPTH_TEMP_DATA);
        ConfigLoadingHandler.addDepthTempConfigs(depthTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s depth temperatures", depthTemps.size()), depthTemps);
        Collection<Holder<MountData>> mounts = event.getRegistry(ModRegistries.MOUNT_DATA);
        ConfigLoadingHandler.addMountConfigs(mounts);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulated mounts", mounts.size()), mounts);
        Collection<Holder<SpawnBiomeData>> spawnBiomes = event.getRegistry(ModRegistries.ENTITY_SPAWN_BIOME_DATA);
        ConfigLoadingHandler.addSpawnBiomeConfigs(spawnBiomes, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity spawn biomes", spawnBiomes.size()), spawnBiomes);
        Collection<Holder<EntityTempData>> entityTemps = event.getRegistry(ModRegistries.ENTITY_TEMP_DATA);
        ConfigLoadingHandler.addEntityTempConfigs(entityTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity temperatures", entityTemps.size()), entityTemps);
        Collection<Holder<EntityClimateData>> entityClimates = event.getRegistry(ModRegistries.ENTITY_CLIMATE_DATA);
        ConfigLoadingHandler.addEntityClimateConfigs(entityClimates);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity climates", entityClimates.size()), entityClimates);
        Collection<Holder<TempEffectsData>> tempEffects = event.getRegistry(ModRegistries.TEMP_EFFECTS_DATA);
        ConfigLoadingHandler.addTempEffectsConfigs(tempEffects);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s temp effects", tempEffects.size()), tempEffects);
        LoadRegistriesEvent.Post postEvent = new LoadRegistriesEvent.Post(registryAccess, event.getRegistries());
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    private static void logRegistryLoaded(String message, Collection<? extends Holder<? extends ConfigData>> registry) {
        message = registry.isEmpty() ? (String)message + "." : (String)message + ": [";
        StringBuilder messageBuilder = new StringBuilder((String)message);
        Iterator<? extends Holder<? extends ConfigData>> iterator = registry.iterator();
        while (iterator.hasNext()) {
            Holder<? extends ConfigData> entry = iterator.next();
            if (entry.m_203543_().isPresent()) {
                messageBuilder.append(((ResourceKey)entry.m_203543_().get()).m_135782_());
            }
            if (iterator.hasNext()) {
                messageBuilder.append(", ");
                continue;
            }
            messageBuilder.append("]");
        }
        ColdSweat.LOGGER.info(messageBuilder.toString(), (Object)registry.size());
        messageBuilder = new StringBuilder("Loaded external entries: ");
        boolean hasNameless = false;
        for (Holder<? extends ConfigData> holder : registry) {
            if (!holder.m_203543_().isEmpty()) continue;
            messageBuilder.append("\n- ").append(holder.m_203334_());
            hasNameless = true;
        }
        if (hasNameless) {
            ColdSweat.LOGGER.debug(messageBuilder.toString());
        }
    }

    private static void setDefaultRegistryPriority(Multimap<RegistryHolder<?>, ? extends Holder<? extends ConfigData>> registries) {
        for (RegistryHolder key : registries.keySet()) {
            ArrayList<Holder> sortedHolders = new ArrayList<Holder>(registries.get((Object)key));
            sortedHolders.sort(Comparator.comparing(holder -> holder.m_203543_().map(k -> k.m_135782_().m_135815_().startsWith("default") ? 1 : 0).orElse(0)));
            registries.replaceValues((Object)key, sortedHolders);
        }
    }

    private static void loadRegistryModifiers(RegistryAccess registryAccess) {
        REGISTRY_MODIFIERS.clear();
        Set<Holder> removals = registryAccess.m_175515_(ModRegistries.REGISTRY_MODIFIER_DATA.key()).m_203611_().collect(Collectors.toSet());
        removals.addAll(ConfigLoadingHandler.parseConfigData(ModRegistries.REGISTRY_MODIFIER_DATA, RegistryModifierData.CODEC, registryAccess));
        removals.forEach(holder -> {
            RegistryHolder key = ModRegistries.getRegistry(((RegistryModifierData)holder.get()).registry());
            REGISTRY_MODIFIERS.put(key, holder);
        });
        ConfigLoadingHandler.setDefaultRegistryPriority(REGISTRY_MODIFIERS);
    }

    private static void modifyRegistries(Multimap<RegistryHolder<?>, Holder<? extends ConfigData>> registries) {
        ColdSweat.LOGGER.info("Handling registry modifiers...");
        for (Map.Entry entry : REGISTRY_MODIFIERS.asMap().entrySet()) {
            ConfigLoadingHandler.modifyEntries((Collection)entry.getValue(), registries.get((Object)((RegistryHolder)entry.getKey())));
        }
    }

    private static <T extends ConfigData> void modifyEntries(Collection<Holder<RegistryModifierData<T>>> modifiers, Collection<Holder<T>> registries) {
        ArrayList<Holder<T>> newRegistries = new ArrayList<Holder<T>>(registries);
        for (Holder<RegistryModifierData<T>> holder : modifiers) {
            RegistryModifierData modifier = (RegistryModifierData)holder.m_203334_();
            for (int i = 0; i < newRegistries.size(); ++i) {
                Holder elementHolder = (Holder)newRegistries.get(i);
                if (!modifier.matches(elementHolder)) continue;
                ConfigData modified = modifier.applyModifications((ConfigData)elementHolder.m_203334_());
                if (modified == null) {
                    newRegistries.remove(i);
                    --i;
                    continue;
                }
                if (elementHolder instanceof Holder.Reference) {
                    Holder.Reference reference = (Holder.Reference)elementHolder;
                    newRegistries.set(i, (Holder<T>)RegistryHelper.modifyHolder(reference, modified));
                    continue;
                }
                newRegistries.set(i, Holder.m_205709_((Object)modified));
            }
        }
        registries.clear();
        registries.addAll(newRegistries);
    }

    public static <C, K, V extends ConfigData> void modifyEntries(C registries, RegistryHolder<V> registry, Function<C, Collection<Map.Entry<K, V>>> entryGetter, Consumer<Map.Entry<K, V>> entrySetter, Consumer<Map.Entry<K, V>> entryRemover) {
        ConfigLoadingHandler.getRegistryModifiers(registry).forEach(holder -> {
            RegistryModifierData modifier = (RegistryModifierData)holder.m_203334_();
            if (modifier.registry() == registry.key()) {
                for (Map.Entry entry : (Collection)entryGetter.apply(registries)) {
                    ConfigData value = (ConfigData)entry.getValue();
                    if (!modifier.matches(value)) continue;
                    ConfigData modified = modifier.applyModifications(value);
                    if (modified == null) {
                        entryRemover.accept(entry);
                        continue;
                    }
                    entrySetter.accept(Map.entry(entry.getKey(), modified));
                }
            }
        });
    }

    public static <T extends ConfigData> void modifyEntries(List<T> registries, RegistryHolder<T> registry) {
        ConfigLoadingHandler.modifyEntries(registries, registry, list -> {
            ArrayList<Map.Entry<Integer, ConfigData>> entries = new ArrayList<Map.Entry<Integer, ConfigData>>();
            for (int i = 0; i < list.size(); ++i) {
                entries.add(Map.entry(i, (ConfigData)list.get(i)));
            }
            return entries;
        }, entry -> registries.set((Integer)entry.getKey(), (ConfigData)entry.getValue()), entry -> registries.remove((Integer)entry.getKey()));
    }

    public static <K, T extends ConfigData> void modifyEntries(Map<K, T> registries, RegistryHolder<T> registry) {
        ConfigLoadingHandler.modifyEntries(registries, registry, Map::entrySet, entry -> registries.put(entry.getKey(), (ConfigData)entry.getValue()), entry -> registries.remove(entry.getKey()));
    }

    public static <K, T extends ConfigData> void modifyEntries(Multimap<K, T> registries, RegistryHolder<T> registry) {
        HashMap tempMap = new HashMap();
        for (Object e : registries.keySet()) {
            ArrayList modifiedList = new ArrayList(registries.get(e));
            ConfigLoadingHandler.modifyEntries(modifiedList, registry);
            tempMap.put(e, modifiedList);
        }
        registries.clear();
        for (Map.Entry entry : tempMap.entrySet()) {
            registries.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
    }

    public static <T extends ConfigData> boolean isRemoved(T entry, RegistryHolder<T> registry) {
        return ConfigLoadingHandler.getRegistryModifiers(registry).stream().anyMatch(data -> ((RegistryModifierData)data.m_203334_()).matches(entry));
    }

    public static <T extends ConfigData> Collection<Holder<RegistryModifierData<T>>> getRegistryModifiers(RegistryHolder<T> registry) {
        return REGISTRY_MODIFIERS.get(registry);
    }

    public static void addOptionalHolder(OptionalHolder<?> holder) {
        OPTIONAL_HOLDERS.add(holder);
    }

    public static void fillOptionalHolders(RegistryAccess registryAccess) {
        HashMap<ResourceKey, Registry> registries = new HashMap<ResourceKey, Registry>();
        for (int i = 0; i < OPTIONAL_HOLDERS.size(); ++i) {
            OptionalHolder<?> holder = OPTIONAL_HOLDERS.get(i);
            Registry registry = registries.computeIfAbsent(holder.key(), key -> registryAccess.m_6632_(ResourceKey.m_135788_((ResourceLocation)holder.key().m_211136_())).orElse(null));
            if (registry == null) continue;
            registry.m_203636_(holder.key()).ifPresent(h -> holder.setValue((Holder)h));
        }
    }

    public static void destroyOptionalHolders() {
        OPTIONAL_HOLDERS.clear();
    }

    private static void addInsulatorConfigs(Collection<Holder<InsulatorData>> insulators) {
        insulators.forEach(holder -> {
            InsulatorData insulator = (InsulatorData)holder.get();
            ArrayList items = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, insulator.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                switch (insulator.slot()) {
                    case ITEM: {
                        ConfigSettings.INSULATION_ITEMS.get().put((Object)item, (Object)insulator);
                        break;
                    }
                    case ARMOR: {
                        ConfigSettings.INSULATING_ARMORS.get().put((Object)item, (Object)insulator);
                        break;
                    }
                    case CURIO: {
                        if (!CompatManager.isCuriosLoaded()) break;
                        ConfigSettings.INSULATING_CURIOS.get().put((Object)item, (Object)insulator);
                    }
                }
            }
        });
    }

    private static void addFuelConfigs(Collection<Holder<FuelData>> fuels) {
        fuels.forEach(holder -> {
            FuelData fuelData = (FuelData)holder.get();
            ArrayList items = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, fuelData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                switch (fuelData.fuelType()) {
                    case BOILER: {
                        ConfigSettings.BOILER_FUEL.get().put((Object)item, (Object)fuelData);
                        break;
                    }
                    case ICEBOX: {
                        ConfigSettings.ICEBOX_FUEL.get().put((Object)item, (Object)fuelData);
                        break;
                    }
                    case HEARTH: {
                        ConfigSettings.HEARTH_FUEL.get().put((Object)item, (Object)fuelData);
                        break;
                    }
                    case SOUL_LAMP: {
                        ConfigSettings.SOULSPRING_LAMP_FUEL.get().put((Object)item, (Object)fuelData);
                    }
                }
            }
        });
    }

    private static void addFoodConfigs(Collection<Holder<FoodData>> foods) {
        foods.forEach(holder -> {
            FoodData foodData = (FoodData)holder.get();
            ArrayList items = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, foodData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.FOOD_TEMPERATURES.get().put((Object)item, (Object)foodData);
            }
        });
    }

    private static void addItemTempConfigs(Collection<Holder<ItemTempData>> itemTemps) {
        itemTemps.forEach(holder -> {
            ItemTempData itemTempData = (ItemTempData)holder.get();
            ArrayList items = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, itemTempData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.ITEM_TEMPERATURES.get().put((Object)item, (Object)itemTempData);
            }
        });
    }

    private static void addDryingItemConfigs(Collection<Holder<DryingItemData>> dryingItems) {
        dryingItems.forEach(holder -> {
            DryingItemData dryingItemData = (DryingItemData)holder.get();
            ArrayList items = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, dryingItemData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.DRYING_ITEMS.get().put((Object)item, (Object)dryingItemData);
            }
        });
    }

    private static void addInsulationSlotConfigs(Collection<Holder<ItemInsulationSlotsData>> insulationSlots) {
        insulationSlots.forEach(holder -> {
            ItemInsulationSlotsData insulationSlotData = (ItemInsulationSlotsData)holder.get();
            ArrayList items = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, insulationSlotData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.INSULATION_SLOT_OVERRIDES.get().put((Object)item, (Object)insulationSlotData);
            }
        });
    }

    private static void addBlockTempConfigs(Collection<Holder<BlockTempData>> blockTemps) {
        blockTemps.forEach(holder -> {
            BlockTempData blockTempData = (BlockTempData)holder.get();
            ConfiguredBlockTemp blockTemp = new ConfiguredBlockTemp(blockTempData);
            BlockTempRegistry.register(blockTemp);
        });
    }

    private static void addBiomeTempConfigs(Collection<Holder<BiomeTempData>> biomeTemps, RegistryAccess registryAccess) {
        biomeTemps.forEach(holder -> {
            BiomeTempData biomeTempData = (BiomeTempData)holder.get();
            for (OptionalHolder biome : RegistryHelper.mapVanillaRegistryTagList(Registry.f_122885_, biomeTempData.biomes(), registryAccess)) {
                if (biomeTempData.isOffset()) {
                    ConfigSettings.BIOME_OFFSETS.get(registryAccess).put(biome.get(), biomeTempData);
                    continue;
                }
                ConfigSettings.BIOME_TEMPS.get(registryAccess).put(biome.get(), biomeTempData);
            }
        });
    }

    private static void addDimensionTempConfigs(Collection<Holder<DimensionTempData>> dimensionTemps, RegistryAccess registryAccess) {
        dimensionTemps.forEach(holder -> {
            DimensionTempData dimensionTempData = (DimensionTempData)holder.get();
            for (OptionalHolder dimension : RegistryHelper.mapVanillaRegistryTagList(Registry.f_122818_, dimensionTempData.dimensions(), registryAccess)) {
                if (dimensionTempData.isOffset()) {
                    ConfigSettings.DIMENSION_OFFSETS.get(registryAccess).put(dimension.get(), dimensionTempData);
                    continue;
                }
                ConfigSettings.DIMENSION_TEMPS.get(registryAccess).put(dimension.get(), dimensionTempData);
            }
        });
    }

    private static void addStructureTempConfigs(Collection<Holder<StructureTempData>> structureTemps, RegistryAccess registryAccess) {
        structureTemps.forEach(holder -> {
            StructureTempData structureTempData = (StructureTempData)holder.get();
            for (OptionalHolder structure : RegistryHelper.mapVanillaRegistryTagList(Registry.f_235725_, structureTempData.structures(), registryAccess)) {
                if (structureTempData.isOffset()) {
                    ConfigSettings.STRUCTURE_OFFSETS.get(registryAccess).put(structure.get(), structureTempData);
                    continue;
                }
                ConfigSettings.STRUCTURE_TEMPS.get(registryAccess).put(structure.get(), structureTempData);
            }
        });
    }

    private static void addDepthTempConfigs(Collection<Holder<DepthTempData>> depthTemps, RegistryAccess registryAccess) {
        for (Holder<DepthTempData> holder : depthTemps) {
            DepthTempData depthTempData = (DepthTempData)holder.get();
            for (OptionalHolder dimension : RegistryHelper.mapVanillaRegistryTagList(Registry.f_122818_, depthTempData.dimensions(), registryAccess)) {
                ConfigSettings.DEPTH_REGIONS.get().put((Object)((DimensionType)dimension.get().m_203334_()), (Object)depthTempData);
            }
        }
    }

    private static void addMountConfigs(Collection<Holder<MountData>> mounts) {
        mounts.forEach(holder -> {
            MountData mountData = (MountData)holder.get();
            ArrayList entities = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITY_TYPES, mountData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.INSULATED_MOUNTS.get().put((Object)entity, (Object)mountData);
            }
        });
    }

    private static void addSpawnBiomeConfigs(Collection<Holder<SpawnBiomeData>> spawnBiomes, RegistryAccess registryAccess) {
        spawnBiomes.forEach(holder -> {
            SpawnBiomeData spawnBiomeData = (SpawnBiomeData)holder.get();
            for (OptionalHolder biome : RegistryHelper.mapVanillaRegistryTagList(Registry.f_122885_, spawnBiomeData.biomes(), registryAccess)) {
                ConfigSettings.ENTITY_SPAWN_BIOMES.get(registryAccess).put(biome.get(), (Object)spawnBiomeData);
            }
        });
    }

    private static void addEntityTempConfigs(Collection<Holder<EntityTempData>> entityTemps) {
        entityTemps.forEach(holder -> {
            EntityTempData entityTempData = (EntityTempData)holder.get();
            ArrayList entities = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITY_TYPES, entityTempData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_TEMPERATURES.get().put((Object)entity, (Object)entityTempData);
            }
        });
    }

    private static void addEntityClimateConfigs(Collection<Holder<EntityClimateData>> entityTemps) {
        entityTemps.forEach(holder -> {
            EntityClimateData entityTempData = (EntityClimateData)holder.get();
            ArrayList entities = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITY_TYPES, entityTempData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_CLIMATES.get().put((Object)entity, (Object)entityTempData);
            }
        });
    }

    private static void addTempEffectsConfigs(Collection<Holder<TempEffectsData>> tempEffects) {
        tempEffects.forEach(holder -> {
            TempEffectsData tempEffectsData = (TempEffectsData)holder.get();
            ArrayList entities = new ArrayList(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITY_TYPES, tempEffectsData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_TEMP_EFFECTS.get().put((Object)entity, (Object)tempEffectsData);
            }
        });
    }

    private static <T extends ConfigData> List<Holder<T>> parseConfigData(RegistryHolder<T> registry, Codec<T> codec, RegistryAccess registryAccess) {
        ResourceKey<Registry<T>> registryKey = registry.key();
        ArrayList output = new ArrayList();
        RegistryOps registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        String configFolder = registryKey.m_135782_().m_135827_().replace("_", "");
        Path coldSweatDataPath = FMLPaths.CONFIGDIR.get().resolve(configFolder + "/data").resolve(registryKey.m_135782_().m_135815_());
        File jsonDirectory = coldSweatDataPath.toFile();
        if (!jsonDirectory.exists()) {
            return output;
        }
        for (File file : ConfigLoadingHandler.findFilesRecursive(jsonDirectory)) {
            if (!file.getName().endsWith(".json")) continue;
            try (FileReader reader = new FileReader(file);){
                codec.decode((DynamicOps)registryOps, (Object)GsonHelper.m_13859_((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)ColdSweat.LOGGER).error(arg_0)).map(Pair::getFirst).ifPresent(configData -> output.add(Holder.m_205709_((Object)configData)));
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to parse JSON config setting in {}: {}", (Object)registryKey.m_135782_(), (Object)file.getName(), (Object)e);
            }
        }
        return output;
    }

    public static List<File> findFilesRecursive(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] filesInDirectory = directory.listFiles();
        if (filesInDirectory == null) {
            return files;
        }
        for (File file : filesInDirectory) {
            if (file.isDirectory()) {
                files.addAll(ConfigLoadingHandler.findFilesRecursive(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class CreateRegistries {
        private static boolean REGISTRIES_INITIALIZED = false;

        @SubscribeEvent
        public static void initRegistries(FMLConstructModEvent event) {
            event.enqueueWork(() -> {
                if (REGISTRIES_INITIALIZED) {
                    return;
                }
                ColdSweat.LOGGER.info("Gathering Cold Sweat registries");
                AddRegistriesEvent addRegistriesEvent = new AddRegistriesEvent();
                boolean busWasClosed = !MinecraftForge.EVENT_BUS.post((Event)new ProbeEventBusEvent());
                MinecraftForge.EVENT_BUS.start();
                MinecraftForge.EVENT_BUS.post((Event)addRegistriesEvent);
                if (busWasClosed) {
                    ColdSweat.LOGGER.info("The event bus was started early to gather Cold Sweat registries; it will now be stopped again until the correct loading phase.");
                    try {
                        Field shutdown = EventBus.class.getDeclaredField("shutdown");
                        shutdown.setAccessible(true);
                        shutdown.set(MinecraftForge.EVENT_BUS, true);
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Failed to re-shutdown the event bus after gathering Cold Sweat registries", (Throwable)e);
                    }
                }
                NewRegistryEvent dummyEvent = new NewRegistryEvent();
                for (RegistryHolder<?> holder : ModRegistries.getRegistries().values()) {
                    dummyEvent.create(new RegistryBuilder().setName(holder.key().m_135782_()).dataPackRegistry(holder.codec(), holder.codec()));
                }
                try {
                    Method process = NewRegistryEvent.class.getDeclaredMethod("fill", new Class[0]);
                    process.setAccessible(true);
                    process.invoke((Object)dummyEvent, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                REGISTRIES_INITIALIZED = true;
            });
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ClientConfigs {
        @SubscribeEvent
        public static void loadClientConfigs(FMLLoadCompleteEvent event) {
            ConfigSettings.CLIENT_SETTINGS.forEach((id, holder) -> holder.load(true));
        }
    }
}

