/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleBatchMessage {
    private static final BinaryOperator<Vec3> MIN_POS_COMPARATOR = (a, b) -> new Vec3(Math.min(a.f_82479_, b.f_82479_), Math.min(a.f_82480_, b.f_82480_), Math.min(a.f_82481_, b.f_82481_));
    private static final BinaryOperator<Vec3> MAX_POS_COMPARATOR = (a, b) -> new Vec3(Math.max(a.f_82479_, b.f_82479_), Math.max(a.f_82480_, b.f_82480_), Math.max(a.f_82481_, b.f_82481_));
    Set<Pair<ParticleOptions, ParticlePlacement>> particles = new HashSet<Pair<ParticleOptions, ParticlePlacement>>();
    int minSetting;

    public ParticleBatchMessage(int minSetting) {
        this.minSetting = minSetting;
    }

    public ParticleBatchMessage() {
        this(-1);
    }

    public ParticleBatchMessage addParticle(ParticleOptions particle, ParticlePlacement placement) {
        this.particles.add((Pair<ParticleOptions, ParticlePlacement>)Pair.of((Object)particle, (Object)placement));
        return this;
    }

    public ParticleBatchMessage addParticle(ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particle, new ParticlePlacement(x, y, z, xSpeed, ySpeed, zSpeed));
        return this;
    }

    public void sendEntity(Entity entity) {
        if (this.particles.isEmpty() || entity.f_19853_.m_5776_()) {
            return;
        }
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)this);
    }

    public void sendWorld(Level level) {
        if (this.particles.isEmpty() || level.m_5776_()) {
            return;
        }
        Vec3 minPos = this.particles.stream().map(Pair::getSecond).map(p -> new Vec3(p.x, p.y, p.z)).reduce(MIN_POS_COMPARATOR).get();
        Vec3 maxPos = this.particles.stream().map(Pair::getSecond).map(p -> new Vec3(p.x, p.y, p.z)).reduce(MAX_POS_COMPARATOR).get();
        Vec3 midPos = minPos.m_82549_(maxPos).m_82490_(0.5);
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint(midPos.f_82479_, midPos.f_82480_, midPos.f_82481_, minPos.m_82554_(maxPos) + 32.0, level.m_46472_());
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> target), (Object)this);
    }

    public static void encode(ParticleBatchMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.minSetting);
        buffer.writeInt(message.particles.size());
        for (Pair<ParticleOptions, ParticlePlacement> entry : message.particles) {
            String particleID = ForgeRegistries.PARTICLE_TYPES.getKey((Object)((ParticleOptions)entry.getFirst()).m_6012_()).toString();
            buffer.writeInt(particleID.length());
            buffer.writeCharSequence((CharSequence)particleID, StandardCharsets.UTF_8);
            ((ParticleOptions)entry.getFirst()).m_7711_(buffer);
            buffer.m_130079_(((ParticlePlacement)entry.getSecond()).toNBT());
        }
    }

    public static ParticleBatchMessage decode(FriendlyByteBuf buffer) {
        ParticleBatchMessage message = new ParticleBatchMessage(buffer.readInt());
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int particleIDLength = buffer.readInt();
            ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(buffer.readCharSequence(particleIDLength, StandardCharsets.UTF_8).toString()));
            ParticleOptions particle = type.m_123743_().m_6507_(type, buffer);
            ParticlePlacement placement = ParticlePlacement.fromNBT(buffer.m_130260_());
            message.addParticle(particle, placement);
        }
        return message;
    }

    public static void handle(ParticleBatchMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                for (Pair<ParticleOptions, ParticlePlacement> entry : message.particles) {
                    ParticleOptions particle = (ParticleOptions)entry.getFirst();
                    ParticlePlacement placement = (ParticlePlacement)entry.getSecond();
                    if (message.minSetting != -1 && ((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()).m_35965_() > message.minSetting) continue;
                    Minecraft.m_91087_().f_91073_.m_7106_(particle, placement.x, placement.y, placement.z, placement.vx, placement.vy, placement.vz);
                }
            });
        }
        context.setPacketHandled(true);
    }

    public static class ParticlePlacement {
        double x;
        double y;
        double z;
        double vx;
        double vy;
        double vz;

        public ParticlePlacement(double x, double y, double z, double vx, double vy, double vz) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("x", this.x);
            tag.m_128347_("y", this.y);
            tag.m_128347_("z", this.z);
            tag.m_128347_("vx", this.vx);
            tag.m_128347_("vy", this.vy);
            tag.m_128347_("vz", this.vz);
            return tag;
        }

        public static ParticlePlacement fromNBT(CompoundTag tag) {
            return new ParticlePlacement(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"), tag.m_128459_("vx"), tag.m_128459_("vy"), tag.m_128459_("vz"));
        }
    }
}

