/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.event.vanilla.RenderHeartEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;

public class FreezeHeartsEffect
extends TempEffect {
    private static final ResourceLocation HEART_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/hearts_frozen.png");
    private int heartIndex = 0;

    public FreezeHeartsEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderHeart(RenderHeartEvent event) {
        int v;
        int u;
        if (!this.test((Entity)Minecraft.getInstance().player)) {
            return;
        }
        if (!ConfigSettings.SHOW_FROZEN_HEALTH.get().booleanValue()) {
            return;
        }
        Gui.HeartType heartType = event.getHeartType();
        boolean halfHeart = event.isHalfHeart();
        int x = event.getX();
        int y = event.getY();
        if (heartType == Gui.HeartType.CONTAINER) {
            ++this.heartIndex;
        }
        double effect = this.getEffectFactor();
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        if (heartsFreezePercentage == 0.0) {
            return;
        }
        float maxHealth = this.entity().getMaxHealth();
        boolean isHardcore = this.entity().level().getLevelData().isHardcore();
        float maxFrozenHealth = (float)((double)maxHealth * heartsFreezePercentage);
        if (maxFrozenHealth == 0.0f) {
            return;
        }
        int frozenHealth = (int)Math.round(CSMath.blend(0.0, (double)maxHealth * heartsFreezePercentage, effect, 0.0, 1.0));
        int frozenHearts = Math.round((float)frozenHealth / 2.0f);
        boolean partialFrozen = frozenHealth % 2 == 1 && this.heartIndex == frozenHearts;
        int n = u = isHardcore ? 7 : 0;
        int n2 = partialFrozen ? (halfHeart ? 21 : 14) : (v = halfHeart ? 7 : 0);
        if (this.heartIndex <= frozenHearts) {
            if (heartType == Gui.HeartType.CONTAINER) {
                event.getGuiGraphics().blit(HEART_TEXTURE, x + 1, y + 1, 14.0f, (float)v, 7, 7, 21, 28);
            } else {
                event.getGuiGraphics().blit(HEART_TEXTURE, x + 1, y + 1, (float)u, (float)v, 7, 7, 21, 28);
            }
        }
    }

    @SubscribeEvent
    public void resetHeartIndex(RenderFrameEvent.Pre event) {
        this.heartIndex = 0;
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

