/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class FreezeShiverEffect
extends TempEffect {
    public FreezeShiverEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void shiverCamera(ViewportEvent.ComputeCameraAngles event) {
        if (!this.test((Entity)Minecraft.getInstance().player)) {
            return;
        }
        LivingEntity entity = this.entity();
        if (!Minecraft.getInstance().isPaused() && ConfigSettings.DISTORTION_EFFECTS.get().booleanValue()) {
            double effect = this.getEffectFactor();
            double tickTime = (double)entity.tickCount + event.getPartialTick();
            float shiverIntensity = (float)CSMath.blend(0.0, (Math.sin(tickTime / 10.0) + 1.0) * (double)0.03f + (double)0.01f, effect, 0.0, 1.0);
            shiverIntensity = (float)((double)shiverIntensity * ConfigSettings.SHIVER_INTENSITY.get());
            float shiverRotation = (float)(Math.sin(tickTime * 2.5) * (double)(shiverIntensity *= Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() * 10.0f));
            entity.setYRot(entity.getYRot() + shiverRotation);
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

