/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WaterTempModifier
extends TempModifier {
    public WaterTempModifier() {
        this(0.0);
    }

    public WaterTempModifier(double temperature) {
        this.getNBT().putDouble("Temperature", temperature);
    }

    public double getTemperature() {
        return this.getNBT().getDouble("Temperature");
    }

    public double getTargetTemperature(LivingEntity entity) {
        Number[] waterTemps = (Double[])WorldHelper.getPositionGrid(entity.blockPosition(), 9, 4).stream().map(pos -> WorldHelper.getWaterTemperatureAt(entity.level(), pos)).toArray(Double[]::new);
        return CSMath.average(waterTemps);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double minWorldTemp = ConfigSettings.MIN_TEMP.get();
        double maxWorldTemp = ConfigSettings.MAX_TEMP.get();
        double configDrySpeed = ConfigSettings.DRYOFF_SPEED.get();
        double temperature = this.getTemperature();
        double target = this.getTargetTemperature(entity);
        double addAmount = WorldHelper.isInWater((Entity)entity) ? (temperature < target ? Math.min(ConfigSettings.WATER_SOAK_SPEED.get(), target - temperature) : Math.max(-ConfigSettings.WATER_SOAK_SPEED.get().doubleValue(), target - temperature)) : (WorldHelper.isRainingAt(entity.level(), entity.blockPosition()) ? Math.max(-ConfigSettings.RAIN_SOAK_SPEED.get().doubleValue(), -ConfigSettings.MAX_RAIN_SOAK.get().doubleValue() - temperature) : 0.0);
        double dryAmount = CSMath.blendExp(configDrySpeed / 1.5, configDrySpeed * 5.0, worldTemp, minWorldTemp, maxWorldTemp, 20.0);
        double tickRate = (double)this.getTickRate() / 5.0;
        double newTemperature = CSMath.shrink(temperature + addAmount * tickRate, dryAmount * tickRate);
        if (newTemperature == 0.0) {
            this.expires(0);
        }
        this.getNBT().putDouble("Temperature", newTemperature);
        if (temperature != newTemperature) {
            this.markDirty();
        }
        return temp -> temp + newTemperature;
    }

    @Override
    public void tick(LivingEntity entity) {
        if (entity.level().isClientSide() && ConfigSettings.WATER_EFFECT_SETTING.get().showParticles() && !entity.isInWater() && Math.random() < Math.abs(this.getNBT().getDouble("Temperature")) * 2.0) {
            double randX = (double)entity.getBbWidth() * (Math.random() - 0.5);
            double randY = (double)entity.getBbHeight() * Math.random();
            double randZ = (double)entity.getBbWidth() * (Math.random() - 0.5);
            entity.level().addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, entity.getX() + randX, entity.getY() + randY, entity.getZ() + randZ, 0.0, 0.0, 0.0);
        }
    }
}

