/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.api.event.client.InsulatorTabBuildEvent;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class FilterInsulationItemsTab {
    @SubscribeEvent
    public static void filterItems(InsulatorTabBuildEvent event) {
        event.addCheck((item, insulator) -> {
            TagKey tagKey;
            HashMap<TagKey<Item>, Set<Item>> tagItems = new HashMap<TagKey<Item>, Set<Item>>();
            for (ItemRequirement itemRequirement : insulator.item().requirements()) {
                for (Either<TagKey<Item>, Item> either : itemRequirement.items().requirements()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (TagKey)either.left().get();
                    FilterInsulationItemsTab.mapAdd(tagItems, (TagKey<Item>)tagKey);
                }
                for (Either<TagKey<Item>, Item> either : itemRequirement.items().exclusions()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (TagKey)either.left().get();
                    FilterInsulationItemsTab.mapRemove(tagItems, (TagKey<Item>)tagKey);
                }
            }
            for (ItemRequirement itemRequirement : insulator.item().exclusions()) {
                for (Either<TagKey<Item>, Item> either : itemRequirement.items().requirements()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (TagKey)either.left().get();
                    FilterInsulationItemsTab.mapRemove(tagItems, (TagKey<Item>)tagKey);
                }
                for (Either<TagKey<Item>, Item> either : itemRequirement.items().exclusions()) {
                    if (!either.left().isPresent()) continue;
                    tagKey = (TagKey)either.left().get();
                    FilterInsulationItemsTab.mapAdd(tagItems, (TagKey<Item>)tagKey);
                }
            }
            for (Map.Entry entry : tagItems.entrySet()) {
                TagKey tagKey2 = (TagKey)entry.getKey();
                if (!item.builtInRegistryHolder().is(tagKey2)) continue;
                HolderSet tag = BuiltInRegistries.ITEM.getTag(tagKey2).orElse(null);
                int tagSize = ((Set)entry.getValue()).size();
                if (tagSize <= 6 || ((Holder)tag.stream().findFirst().get()).value() == item) continue;
                return false;
            }
            return true;
        });
    }

    private static void mapAdd(Map<TagKey<Item>, Set<Item>> map, TagKey<Item> tag) {
        Set items = map.computeIfAbsent(tag, k -> new HashSet(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, new NegatableList(Either.left((Object)tag)))));
        Set currentItems = map.computeIfAbsent(tag, k -> new HashSet());
        currentItems.addAll(items);
        map.put(tag, currentItems);
    }

    private static void mapRemove(Map<TagKey<Item>, Set<Item>> map, TagKey<Item> tag) {
        Set items = map.computeIfAbsent(tag, k -> new HashSet(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, new NegatableList(Either.left((Object)tag)))));
        for (Set<Item> itemSet : map.values()) {
            itemSet.removeAll(items);
        }
    }
}

