/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class HearthScreen
extends AbstractHearthScreen<HearthContainer> {
    private static final ResourceLocation HEARTH_GUI = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/screen/hearth_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((HearthContainer)this.menu).te;
    }

    public HearthScreen(HearthContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)Component.translatable((String)"container.cold_sweat.hearth"));
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(HEARTH_GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int maxGaugeHeight = 14;
        int hotGaugeHeight = ((HearthContainer)this.menu).getHotFuel() <= 0 ? 0 : Math.round(CSMath.blend(2.0f, 14.0f, ((HearthContainer)this.menu).getHotFuel(), 0.0f, ((HearthContainer)this.menu).te.getMaxFuel()));
        int coldGaugeHeight = ((HearthContainer)this.menu).getColdFuel() <= 0 ? 0 : Math.round(CSMath.blend(2.0f, 14.0f, ((HearthContainer)this.menu).getColdFuel(), 0.0f, ((HearthContainer)this.menu).te.getMaxFuel()));
        graphics.blit(HOT_FUEL_GAUGE, this.leftPos + 62, this.topPos + 49 + (maxGaugeHeight - hotGaugeHeight), 0.0f, (float)(maxGaugeHeight - hotGaugeHeight), 14, hotGaugeHeight, 14, 14);
        graphics.blit(COLD_FUEL_GAUGE, this.leftPos + 100, this.topPos + 49 + (maxGaugeHeight - coldGaugeHeight), 0.0f, (float)(maxGaugeHeight - coldGaugeHeight), 14, coldGaugeHeight, 14, 14);
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue()) {
            boolean coolingOn = ((HearthContainer)this.menu).te.isCoolingOn();
            boolean heatingOn = ((HearthContainer)this.menu).te.isHeatingOn();
            graphics.blitSprite(HearthScreen.getPowerIndicatorSprite(heatingOn), this.leftPos + 63, this.topPos + 64, 13, 4);
            graphics.blitSprite(HearthScreen.getPowerIndicatorSprite(coolingOn), this.leftPos + 101, this.topPos + 64, 13, 4);
            if (CSMath.betweenInclusive(mouseX, this.leftPos + 60, this.leftPos + 76) && CSMath.betweenInclusive(mouseY, this.topPos + 61, this.topPos + 67)) {
                this.setTooltipForNextRenderPass((Component)Component.translatable((String)(heatingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
            if (CSMath.betweenInclusive(mouseX, this.leftPos + 98, this.leftPos + 114) && CSMath.betweenInclusive(mouseY, this.topPos + 61, this.topPos + 67)) {
                this.setTooltipForNextRenderPass((Component)Component.translatable((String)(coolingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
        }
    }
}

