/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HearthBlockEntityRenderer
implements BlockEntityRenderer<HearthBlockEntity> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/hearth.png");
    public static final ResourceLocation TEXTURE_SMART = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/hearth_smart.png");
    public static final ResourceLocation TEXTURE_HEAT_ON = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/hearth_heat_on.png");
    public static final ResourceLocation TEXTURE_COLD_ON = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/hearth_cold_on.png");
    public static final ResourceLocation TEXTURE_FROST = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/hearth_frost.png");
    public static final ResourceLocation TEXTURE_LIT = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/hearth_lit.png");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"hearth"), "main");
    private final ModelPart body;
    private final ModelPart grate;

    public HearthBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart base = context.bakeLayer(LAYER_LOCATION);
        this.body = base.getChild("body");
        this.grate = base.getChild("grate");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-16.0f, -16.0f, 0.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition grate = partdefinition.addOrReplaceChild("grate", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -9.0f, -9.0f, 10.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(HearthBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockstate = blockEntity.getBlockState();
        poseStack.pushPose();
        float f = ((Direction)blockstate.getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer baseVertexes = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)HearthBlockEntityRenderer.getTexture(blockstate)));
        this.body.render(poseStack, baseVertexes, light, overlay);
        this.grate.render(poseStack, baseVertexes, light, overlay);
        if (((Boolean)blockstate.getValue((Property)HearthBottomBlock.LIT)).booleanValue()) {
            VertexConsumer litVertexes = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE_LIT));
            this.grate.render(poseStack, litVertexes, light, overlay);
        }
        if (((Boolean)blockstate.getValue((Property)HearthBottomBlock.FROSTED)).booleanValue()) {
            VertexConsumer frostedVertexes = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE_FROST));
            this.body.render(poseStack, frostedVertexes, light, overlay);
        }
        if (!((Boolean)blockstate.getValue((Property)HearthBottomBlock.SMART)).booleanValue()) {
            if (((Boolean)blockstate.getValue((Property)HearthBottomBlock.HEATING)).booleanValue()) {
                VertexConsumer heatingVertexes = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE_HEAT_ON));
                this.body.render(poseStack, heatingVertexes, light, overlay);
            }
            if (((Boolean)blockstate.getValue((Property)HearthBottomBlock.COOLING)).booleanValue()) {
                VertexConsumer coolingVertexes = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE_COLD_ON));
                this.body.render(poseStack, coolingVertexes, light, overlay);
            }
        }
        poseStack.popPose();
    }

    public static ResourceLocation getTexture(BlockState state) {
        return (Boolean)state.getValue((Property)HearthBottomBlock.SMART) != false ? TEXTURE_SMART : TEXTURE;
    }
}

