/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.vanilla.BlockStateChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.ThermalSourceTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.HearthDebugRenderer;
import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.block.SmokestackBlock;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.core.init.ModFluids;
import com.momosoftworks.coldsweat.core.init.ModParticleTypes;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.core.network.message.HearthResetMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.tag.ModFluidTags;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.SpreadPath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class HearthBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    List<SpreadPath> paths = new ArrayList<SpreadPath>(this.getMaxPaths());
    Set<BlockPos> pathLookup = new HashSet<BlockPos>(this.getMaxPaths());
    Map<Pair<Integer, Integer>, Pair<Integer, Boolean>> seeSkyMap = new FastMap<Pair<Integer, Integer>, Pair<Integer, Boolean>>(this.getMaxPaths());
    List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    FuelFluidHandler hotFuelHandler = new FuelFluidHandler(FuelType.HOT);
    FuelFluidHandler coldFuelHandler = new FuelFluidHandler(FuelType.COLD);
    NonNullList<ItemStack> items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    Pair<BlockPos, ResourceLocation> levelPos = Pair.of(null, null);
    int x = 0;
    int y = 0;
    int z = 0;
    int lastHotFuel = 0;
    int lastColdFuel = 0;
    boolean isCoolingOn = false;
    boolean isHeatingOn = false;
    boolean usingHotFuel = false;
    boolean usingColdFuel = false;
    int insulationLevel = 0;
    boolean isEntityNearby = false;
    List<LivingEntity> entities = new ArrayList<LivingEntity>();
    int rebuildCooldown = 0;
    boolean forceRebuild = false;
    List<BlockPos> queuedUpdates = new ArrayList<BlockPos>();
    public int ticksExisted = 0;
    boolean registeredLocation = false;
    boolean showParticles = true;
    int frozenPaths = 0;
    boolean spreading = true;
    boolean hasSmokestack = false;
    Map<BlockPos, Direction> pipeEnds = new HashMap<BlockPos, Direction>();
    static final Direction[] DIRECTIONS = Direction.values();
    static Method TICK_DOWN_EFFECT;
    ChunkAccess workingChunk = null;

    public HearthBlockEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        NeoForge.EVENT_BUS.addListener(this::onBlockUpdate);
    }

    public HearthBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.HEARTH.get(), pos, state);
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockStateChangedEvent event) {
        BlockPos pos = event.getPosition();
        Level level = event.getLevel();
        BlockState oldState = event.getOldState();
        BlockState newState = event.getNewState();
        if (oldState == null || newState == null) {
            return;
        }
        if (level == this.level && this.pathLookup.contains(pos) && !oldState.getCollisionShape((BlockGetter)level, pos).equals(newState.getCollisionShape((BlockGetter)level, pos))) {
            if (!level.isClientSide()) {
                this.sendBlockUpdate(pos);
            }
            if (this.isTransferPipe(oldState) || this.isTransferPipe(newState)) {
                this.searchForPipeEnds(this.getBlockPos().above(), Direction.UP);
            }
        }
    }

    @SubscribeEvent
    public void onLevelUnloaded(LevelEvent.Unload event) {
        if (event.getLevel().equals((Object)this.level)) {
            this.cleanup();
        }
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        ChunkAccess chunk = event.getChunk();
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            for (BlockEntity te : levelChunk.getBlockEntities().values()) {
                if (!(te instanceof HearthBlockEntity)) continue;
                HearthBlockEntity hearth = (HearthBlockEntity)te;
                hearth.cleanup();
            }
        }
    }

    public int getSpreadRange() {
        return ConfigSettings.HEARTH_RANGE.get();
    }

    public int getMaxRange() {
        return ConfigSettings.HEARTH_MAX_RANGE.get();
    }

    public int getMaxPaths() {
        return ConfigSettings.HEARTH_MAX_VOLUME.get();
    }

    public int getMaxFuel() {
        return 1000;
    }

    public int getInsulationTime() {
        return ConfigSettings.HEARTH_WARM_UP_TIME.get();
    }

    public int getCoolingLevel() {
        return this.usingColdFuel ? this.insulationLevel : 0;
    }

    public int getHeatingLevel() {
        return this.usingHotFuel ? this.insulationLevel : 0;
    }

    public int getMaxInsulationLevel() {
        return ConfigSettings.HEARTH_MAX_INSULATION.get();
    }

    public boolean hasSmokestack() {
        return true;
    }

    protected boolean isSmartEnabled() {
        return ConfigSettings.SMART_HEARTH.get();
    }

    protected int getFuelDrainInterval() {
        return ConfigSettings.HEARTH_FUEL_INTERVAL.get();
    }

    public boolean supportsHeating() {
        return true;
    }

    public List<Direction> getHeatingSides() {
        return Arrays.asList(Direction.EAST, Direction.SOUTH);
    }

    public boolean isHeatingSide(Direction side) {
        if (side == null) {
            return false;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)HearthBottomBlock.FACING);
        Direction rotatedSide = CSMath.rotationToNorth(facing).rotate(side);
        return this.getHeatingSides().contains(rotatedSide);
    }

    public boolean supportsCooling() {
        return true;
    }

    public List<Direction> getCoolingSides() {
        return Arrays.asList(Direction.WEST, Direction.DOWN);
    }

    public boolean isCoolingSide(Direction side) {
        if (side == null) {
            return false;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)HearthBottomBlock.FACING);
        Direction rotatedSide = CSMath.rotationToNorth(facing).rotate(side);
        return this.getCoolingSides().contains(rotatedSide);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.cold_sweat.hearth");
    }

    public Component getDisplayName() {
        return this.getCustomName() != null ? this.getCustomName() : this.getDefaultName();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public static <T extends BlockEntity> void tickSelf(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof HearthBlockEntity) {
            HearthBlockEntity hearth = (HearthBlockEntity)te;
            hearth.tick(level, pos);
        }
    }

    public void tick(Level level, BlockPos pos) {
        if (this.ticksExisted == 0) {
            this.init();
        }
        boolean isClient = level.isClientSide;
        ++this.ticksExisted;
        if (this.rebuildCooldown > 0) {
            --this.rebuildCooldown;
        }
        if (this.level != null && this.ticksExisted % 20 == 0) {
            this.isEntityNearby = false;
            this.entities.clear();
            AABB searchArea = new AABB(pos).inflate((double)this.getMaxRange());
            for (Entity entity : this.level.getEntities((Entity)null, searchArea, EntityTempManager::isTemperatureEnabled)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.entities.add(living);
                this.isEntityNearby = true;
            }
        }
        this.tickPotionEffects();
        if (!(this.usingColdFuel || this.usingHotFuel || this.paths.isEmpty())) {
            this.forceUpdate();
        }
        if (this.forceRebuild || this.rebuildCooldown <= 0 && !this.queuedUpdates.isEmpty()) {
            this.resetPaths();
        }
        if (this.getColdFuel() > 0 || this.getHotFuel() > 0) {
            if (this.insulationLevel < this.getInsulationTime()) {
                ++this.insulationLevel;
            }
            if (this.usingColdFuel || this.usingHotFuel || this.isSmartEnabled() && this.isEntityNearby) {
                if (this.ticksExisted % 20 == 0) {
                    boolean bl = this.showParticles = isClient && Minecraft.getInstance().options.particles().get() == ParticleStatus.ALL && !HearthSaveDataHandler.DISABLED_HEARTHS.contains(this.levelPos);
                }
                if (this.paths.isEmpty()) {
                    this.addPath(new SpreadPath(pos.above(1)).setOrigin(pos.above(1)));
                    this.pathLookup.add(pos.above(1));
                    this.searchForPipeEnds(this.getBlockPos().above(), Direction.UP);
                }
                this.spreading = this.frozenPaths < this.paths.size();
                int pathCount = this.paths.size();
                int partSize = this.spreading ? CSMath.clamp(pathCount / 3, 100, 4000) : CSMath.clamp(pathCount / 20, 10, 100);
                int partCount = (int)Math.ceil((float)pathCount / (float)partSize);
                int lastIndex = partSize * (this.ticksExisted % partCount + 1);
                int firstIndex = Math.max(0, lastIndex - partSize);
                if (this.paths.size() > 1 || this.ticksExisted % 20 == 0) {
                    this.tickPaths(firstIndex, lastIndex);
                }
                if (isClient && this.spreading && this.paths.size() != pathCount) {
                    HearthDebugRenderer.updatePaths(this);
                }
                if (!isClient && this.ticksExisted % 20 == 0) {
                    boolean isProvidingInsulation = false;
                    for (int i = 0; i < this.entities.size(); ++i) {
                        LivingEntity entity = this.entities.get(i);
                        if (entity == null || entity instanceof DummyPlayer) continue;
                        AABB playerBB = entity.getBoundingBox().inflate(-0.1);
                        if (!this.isAffectingPos(WorldHelper.getOccupiedPositions(playerBB = playerBB.setMaxY(Math.max(playerBB.maxY, playerBB.minY + 2.0)))) || WorldHelper.canSeeSky((LevelAccessor)level, BlockPos.containing((Position)playerBB.getCenter()), 64)) continue;
                        isProvidingInsulation |= this.insulateEntity(entity);
                    }
                    if (this.isSmartEnabled() && !isProvidingInsulation) {
                        this.clearFuelUsage();
                    }
                }
                if (!isClient) {
                    this.tickDrainFuel();
                }
                if (level.isClientSide) {
                    this.spawnRandomAirParticles();
                }
            }
        }
        if (this.ticksExisted % 40 == 0) {
            this.checkForFuel();
        }
        if (!isClient) {
            this.checkForStateChange();
        }
        if (!isClient && this.isFuelChanged()) {
            this.updateFuelState();
        }
        if (isClient) {
            this.tickParticles();
        }
    }

    protected <T extends Comparable<T>> void ensureState(Property<T> property, T value) {
        BlockState state = this.getBlockState();
        if (state.hasProperty(property) && state.getValue(property) != value) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue(property, value), 2);
        }
    }

    public void checkForStateChange() {
        if (this.getBlockState().is(ModBlocks.HEARTH_BOTTOM)) {
            this.ensureState((Property)HearthBottomBlock.SMART, this.isSmartEnabled());
            this.ensureState((Property)HearthBottomBlock.LIT, this.isUsingHotFuel());
            this.ensureState((Property)HearthBottomBlock.FROSTED, this.getColdFuel() > 0);
            this.ensureState((Property)HearthBottomBlock.HEATING, this.isHeatingOn);
            this.ensureState((Property)HearthBottomBlock.COOLING, this.isCoolingOn);
        }
    }

    protected void tickPaths(int firstIndex, int lastIndex) {
        int pathCount = this.paths.size();
        for (int i = firstIndex; i < Math.min(this.paths.size(), lastIndex); ++i) {
            SpreadPath spreadPath = this.paths.get(i);
            BlockPos pathPos = spreadPath.pos;
            if (spreadPath.origin == null) {
                spreadPath.setOrigin(this.getBlockPos());
            }
            int spX = spreadPath.x;
            int spY = spreadPath.y;
            int spZ = spreadPath.z;
            if (spreadPath.frozen) {
                if (this.spreading || Math.abs(spY % 2) == 0 != (Math.abs(spX % 2) == Math.abs(spZ % 2))) continue;
                this.paths.remove(i);
                --i;
                continue;
            }
            if (pathCount < this.getMaxPaths() && spreadPath.withinDistance((Vec3i)spreadPath.origin, this.getSpreadRange()) && CSMath.withinCubeDistance(spreadPath.origin, this.getBlockPos(), this.getMaxRange())) {
                boolean canSeeSky;
                if (this.workingChunk == null || !this.workingChunk.getPos().equals((Object)new ChunkPos(pathPos))) {
                    this.workingChunk = WorldHelper.getChunk((LevelAccessor)this.level, pathPos);
                }
                BlockState state = this.workingChunk != null ? this.workingChunk.getBlockState(pathPos) : this.level.getBlockState(pathPos);
                Pair flatPos = Pair.of((Object)spX, (Object)spZ);
                Pair<Integer, Boolean> seeSkyState = this.seeSkyMap.get(flatPos);
                if (seeSkyState == null || (Integer)seeSkyState.getFirst() < spY != (Boolean)seeSkyState.getSecond()) {
                    canSeeSky = WorldHelper.canSeeSky((LevelAccessor)this.level, pathPos.above(), 64);
                    this.seeSkyMap.put((Pair<Integer, Integer>)flatPos, (Pair<Integer, Boolean>)Pair.of((Object)spY, (Object)canSeeSky));
                } else {
                    canSeeSky = (Boolean)seeSkyState.getSecond();
                }
                if (!canSeeSky || this.isTransferPipe(state)) {
                    for (int d = 0; d < DIRECTIONS.length; ++d) {
                        Direction direction = DIRECTIONS[d];
                        Direction pathDir = spreadPath.direction;
                        if (direction == pathDir.getOpposite()) continue;
                        BlockPos tryPos = pathPos.relative(direction);
                        SpreadPath newPath = new SpreadPath(tryPos, direction).setOrigin(spreadPath.origin);
                        if (!this.pathLookup.add(tryPos) || !this.canSpread(this.level, pathPos, tryPos, state, spreadPath.direction, direction, newPath)) continue;
                        this.addPath(newPath);
                    }
                } else {
                    this.pathLookup.remove(pathPos);
                    this.paths.remove(i);
                    --i;
                    continue;
                }
            }
            spreadPath.frozen = true;
            ++this.frozenPaths;
        }
    }

    protected void spawnRandomAirParticles() {
        if (this.level != null && this.level.isClientSide && this.showParticles && (!Minecraft.getInstance().getDebugOverlay().showDebugScreen() || !ConfigSettings.HEARTH_DEBUG.get().booleanValue())) {
            if (this.paths.isEmpty()) {
                return;
            }
            RandomSource random = this.level.random;
            int count = Math.max(1, this.paths.size() / 100);
            for (int i = 0; i < count; ++i) {
                SpreadPath path = this.paths.get(random.nextInt(this.paths.size()));
                this.spawnAirParticle(path.x, path.y, path.z, random);
            }
        }
    }

    public void checkInputSignal() {
        if (!this.level.isClientSide() && !this.isSmartEnabled()) {
            boolean wasHeatingOn = this.isHeatingOn;
            boolean wasCoolingOn = this.isCoolingOn;
            this.isHeatingOn = this.hasHeatingSignal();
            this.isCoolingOn = this.hasCoolingSignal();
            this.usingColdFuel = this.hasSmokestack && this.isCoolingOn && this.getColdFuel() > 0;
            this.usingHotFuel = this.hasSmokestack && this.isHeatingOn && this.getHotFuel() > 0;
            this.syncInputSignal(wasHeatingOn, wasCoolingOn);
        }
    }

    protected boolean hasCoolingSignal() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)HearthBottomBlock.FACING);
        for (Direction side : this.getCoolingSides()) {
            Direction rotatedSide = CSMath.rotationFromNorth(facing).rotate(side);
            if (!this.level.hasSignal(this.getBlockPos().relative(rotatedSide), rotatedSide)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasHeatingSignal() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)HearthBottomBlock.FACING);
        for (Direction side : this.getHeatingSides()) {
            Direction rotatedSide = CSMath.rotationFromNorth(facing).rotate(side);
            if (!this.level.hasSignal(this.getBlockPos().relative(rotatedSide), rotatedSide)) continue;
            return true;
        }
        return false;
    }

    protected void syncInputSignal(boolean wasHeatingOn, boolean wasCoolingOn) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (wasHeatingOn != this.isHeatingOn || wasCoolingOn != this.isCoolingOn) {
                serverLevel.getChunkSource().blockChanged(this.getBlockPos());
            }
        }
    }

    public void setChanged() {
        super.setChanged();
        this.checkForFuel();
    }

    public void checkForFuel() {
        BlockPos pos = this.getBlockPos();
        ItemStack fuelStack = (ItemStack)this.getItems().get(0);
        if (!fuelStack.isEmpty()) {
            List itemEffects = CSMath.getIfNotNull((PotionContents)fuelStack.get(DataComponents.POTION_CONTENTS), potions -> StreamSupport.stream(potions.getAllEffects().spliterator(), true).toList(), new ArrayList());
            if (ConfigSettings.HEARTH_POTIONS_ENABLED.get().booleanValue() && !itemEffects.isEmpty() && !itemEffects.equals(this.effects) && itemEffects.stream().noneMatch(eff -> ConfigSettings.HEARTH_POTION_BLACKLIST.get().contains(eff.getEffect()))) {
                if (fuelStack.getItem() instanceof PotionItem) {
                    this.getItems().set(0, (Object)Items.GLASS_BOTTLE.getDefaultInstance());
                } else if (!fuelStack.hasCraftingRemainingItem() || fuelStack.getCount() > 1) {
                    fuelStack.shrink(1);
                } else {
                    this.getItems().set(0, (Object)fuelStack.getCraftingRemainingItem());
                }
                this.level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                this.effects.addAll(itemEffects.stream().map(MobEffectInstance::save).map(nbt -> MobEffectInstance.load((CompoundTag)((CompoundTag)nbt))).toList());
                WorldHelper.syncBlockEntityData((BlockEntity)this);
            } else if (fuelStack.is(Items.MILK_BUCKET) && !this.effects.isEmpty()) {
                this.getItems().set(0, (Object)fuelStack.getCraftingRemainingItem());
                this.level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                WorldHelper.syncBlockEntityData((BlockEntity)this);
            } else {
                int itemFuel = this.getItemFuel(fuelStack);
                if (itemFuel != 0) {
                    this.storeFuel(fuelStack, itemFuel);
                }
            }
        }
    }

    protected boolean isFuelChanged() {
        return this.getColdFuel() != this.lastColdFuel || this.getHotFuel() != this.lastHotFuel;
    }

    protected void storeFuel(ItemStack stack, int amount) {
        int fuel;
        int n = fuel = amount > 0 ? this.getHotFuel() : this.getColdFuel();
        if ((double)fuel < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasCraftingRemainingItem() || stack.getCount() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - fuel) / (double)Math.abs(amount)), stack.getCount());
                stack.shrink(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.setItem(0, stack.getCraftingRemainingItem());
                this.addFuel(amount);
            }
        }
    }

    protected void drainFuel() {
        if (this.isUsingColdFuel()) {
            this.drainColdFuel(1, true);
        }
        if (this.isUsingHotFuel()) {
            this.drainHotFuel(1, true);
        }
    }

    protected void tickDrainFuel() {
        int fuelInterval = this.getFuelDrainInterval();
        if (fuelInterval > 0 && this.ticksExisted % fuelInterval == 0) {
            this.drainFuel();
        }
    }

    protected void clearFuelUsage() {
        if (this.level == null || !this.level.isClientSide) {
            this.usingColdFuel = false;
            this.usingHotFuel = false;
        }
    }

    boolean insulateEntity(LivingEntity entity) {
        for (int i = 0; i < this.effects.size(); ++i) {
            MobEffectInstance effect = this.effects.get(i);
            entity.addEffect(new MobEffectInstance(effect.getEffect(), effect.getEffect() == MobEffects.NIGHT_VISION ? 399 : 119, effect.getAmplifier(), effect.isAmbient(), effect.isVisible(), effect.showIcon()));
        }
        if (!this.isSmartEnabled() || this.shouldInsulateEntity(entity)) {
            int maxEffect = this.getMaxInsulationLevel() - 1;
            int effectLevel = (int)Math.min((double)maxEffect, (double)this.insulationLevel / (double)this.getInsulationTime() * (double)maxEffect);
            if (this.usingColdFuel) {
                entity.addEffect(new MobEffectInstance(ModEffects.FRIGIDNESS, 60, effectLevel, false, false, true));
            }
            if (this.usingHotFuel) {
                entity.addEffect(new MobEffectInstance(ModEffects.WARMTH, 60, effectLevel, false, false, true));
            }
            return this.usingColdFuel || this.usingHotFuel;
        }
        return false;
    }

    protected boolean shouldInsulateEntity(LivingEntity entity) {
        AtomicBoolean shouldInsulate = new AtomicBoolean(false);
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            double lastOutput;
            double lastInput;
            Optional<ThermalSourceTempModifier> existingMod;
            double min = cap.getTrait(Temperature.Trait.FREEZING_POINT);
            double max = cap.getTrait(Temperature.Trait.BURNING_POINT);
            double temp = cap.getTrait(Temperature.Trait.WORLD);
            if (CSMath.betweenInclusive(temp, min, max) && (existingMod = Temperature.getModifier(cap, Temperature.Trait.WORLD, ThermalSourceTempModifier.class)).isPresent() && ((lastInput = existingMod.get().getLastInput(Temperature.Trait.WORLD)) != (lastOutput = existingMod.get().getLastOutput(Temperature.Trait.WORLD)) || lastInput != 0.0)) {
                temp = lastInput;
            }
            this.usingHotFuel |= this.getHotFuel() > 0 && temp < min;
            this.usingColdFuel |= this.getColdFuel() > 0 && temp > max;
            shouldInsulate.set(!CSMath.betweenInclusive(temp, min, max));
        });
        return shouldInsulate.get();
    }

    protected boolean canSpread(Level level, BlockPos fromPos, BlockPos toPos, BlockState fromState, Direction fromDirection, Direction toDirection, SpreadPath newPath) {
        Block fromBlock = fromState.getBlock();
        if (fromBlock instanceof SmokestackBlock) {
            SmokestackBlock.Facing toFacing;
            SmokestackBlock.Facing facing = (SmokestackBlock.Facing)((Object)fromState.getValue(SmokestackBlock.FACING));
            boolean isJunction = facing == SmokestackBlock.Facing.BEND;
            BlockState toState = level.getBlockState(toPos);
            boolean isToSmokestack = toState.getBlock() instanceof SmokestackBlock;
            SmokestackBlock.Facing facing2 = toFacing = isToSmokestack ? (SmokestackBlock.Facing)((Object)toState.getValue(SmokestackBlock.FACING)) : null;
            if (isJunction) {
                return isToSmokestack && (toFacing == SmokestackBlock.Facing.BEND || toFacing.getAxis() == toDirection.getAxis());
            }
            if (facing.getAxis() == toDirection.getAxis()) {
                newPath.setOrigin(toPos);
                return true;
            }
            return false;
        }
        if (CompatManager.isCreateLoaded() && (fromBlock instanceof FluidPipeBlock && (Boolean)fromState.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(toDirection)) != false || fromBlock instanceof GlassFluidPipeBlock && fromState.getValue((Property)RotatedPillarBlock.AXIS) == toDirection.getAxis() || fromBlock instanceof EncasedPipeBlock && ((Boolean)fromState.getValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(toDirection))).booleanValue())) {
            newPath.setOrigin(toPos);
            return true;
        }
        return !WorldHelper.isSpreadBlocked((LevelAccessor)level, fromState, fromPos, fromDirection, toDirection);
    }

    protected boolean isTransferPipe(BlockState state) {
        return state.getBlock() instanceof SmokestackBlock || CompatManager.Create.isFluidPipe(state);
    }

    protected boolean connectsTo(BlockState state, BlockState otherState, Direction direction) {
        return this.pipePointingTo(state, otherState, direction) && this.isTransferPipe(state) && this.isTransferPipe(otherState);
    }

    protected boolean pipePointingTo(BlockState state, BlockState otherState, Direction direction) {
        if (state.getBlock() instanceof SmokestackBlock) {
            SmokestackBlock.Facing facing = (SmokestackBlock.Facing)((Object)state.getValue(SmokestackBlock.FACING));
            return facing == SmokestackBlock.Facing.BEND ? otherState.getBlock() instanceof SmokestackBlock : facing.getAxis() == direction.getAxis();
        }
        if (CompatManager.isCreateLoaded()) {
            if (state.getBlock() instanceof FluidPipeBlock) {
                return (Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction));
            }
            if (state.getBlock() instanceof GlassFluidPipeBlock) {
                return state.getValue((Property)RotatedPillarBlock.AXIS) == direction.getAxis();
            }
            if (state.getBlock() instanceof EncasedPipeBlock) {
                return (Boolean)state.getValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(direction));
            }
        }
        return false;
    }

    protected void searchForPipeEnds(BlockPos startPos, Direction fromDir) {
        if (this.hasSmokestack && this.level != null) {
            this.pipeEnds.clear();
            this.searchForPipeEndsRecursive(startPos, this.level.getBlockState(startPos), fromDir, new HashSet<BlockPos>());
        }
    }

    protected void searchForPipeEndsRecursive(BlockPos pos, BlockState state, Direction fromDir, Set<BlockPos> visited) {
        visited.add(pos);
        for (int d = 0; d < DIRECTIONS.length; ++d) {
            BlockPos tryPos;
            Direction direction = DIRECTIONS[d];
            if (direction == fromDir.getOpposite() || visited.contains(tryPos = pos.relative(direction)) || !CSMath.withinCubeDistance(this.getBlockPos(), tryPos, this.getMaxRange())) continue;
            BlockState otherState = this.level.getBlockState(tryPos);
            if (this.isTransferPipe(otherState) && this.connectsTo(state, otherState, direction)) {
                this.searchForPipeEndsRecursive(tryPos, otherState, direction, visited);
                continue;
            }
            if (WorldHelper.isSpreadBlocked((LevelAccessor)this.level, otherState, tryPos, fromDir.getOpposite(), direction) || !this.pipePointingTo(state, otherState, direction)) continue;
            this.pipeEnds.put(tryPos, direction.getOpposite());
        }
    }

    protected void init() {
        this.registerLocation();
        this.checkForSmokestack();
        this.checkInputSignal();
    }

    private void registerLocation() {
        if (!this.registeredLocation) {
            this.levelPos = Pair.of((Object)this.getBlockPos(), (Object)this.level.dimension().location());
            HearthSaveDataHandler.HEARTH_POSITIONS.add(this.levelPos);
            this.x = this.getBlockPos().getX();
            this.y = this.getBlockPos().getY();
            this.z = this.getBlockPos().getZ();
            this.registeredLocation = true;
        }
    }

    private void unregisterLocation() {
        if (this.registeredLocation) {
            HearthSaveDataHandler.HEARTH_POSITIONS.remove(this.levelPos);
            this.registeredLocation = false;
        }
    }

    protected void tickPotionEffects() {
        if (!this.effects.isEmpty()) {
            this.effects.removeIf(effect -> {
                try {
                    TICK_DOWN_EFFECT.invoke(effect, new Object[0]);
                    if (effect.getDuration() <= 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            });
        }
    }

    public boolean isAffectingPos(List<BlockPos> positions) {
        boolean isSmall = positions.size() <= 1;
        BlockPos.MutableBlockPos checkerboardPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.paths.size(); ++i) {
            SpreadPath path = this.paths.get(i);
            for (int j = 0; j < positions.size(); ++j) {
                BlockPos pos = positions.get(j);
                if (pos.equals((Object)path.pos)) {
                    return true;
                }
                if (!isSmall || !pos.equals((Object)checkerboardPos.set((Vec3i)path.pos).offset(1, 1, 1))) continue;
                return true;
            }
        }
        return false;
    }

    void resetPaths() {
        this.rebuildCooldown = 100;
        this.paths.clear();
        this.pathLookup.clear();
        if (this.forceRebuild) {
            this.seeSkyMap.clear();
        } else {
            for (int i = 0; i < this.queuedUpdates.size(); ++i) {
                BlockPos pos = this.queuedUpdates.get(i);
                this.seeSkyMap.remove(Pair.of((Object)pos.getX(), (Object)pos.getZ()));
            }
        }
        this.frozenPaths = 0;
        this.spreading = true;
        this.sendResetPacket();
        if (this.level.isClientSide) {
            HearthDebugRenderer.updatePaths(this);
        }
        this.forceRebuild = false;
        this.queuedUpdates.clear();
        this.searchForPipeEnds(this.getBlockPos().above(), Direction.UP);
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public int getItemFuel(ItemStack item) {
        return CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.HEARTH_FUEL, item.getItem(), data -> data.test(item)), FuelData::fuel, 0.0).intValue();
    }

    public int getHotFuel() {
        return this.hotFuelHandler.getFuelAmount();
    }

    public int getColdFuel() {
        return this.coldFuelHandler.getFuelAmount();
    }

    public boolean isUsingColdFuel() {
        return this.usingColdFuel;
    }

    public boolean isUsingHotFuel() {
        return this.usingHotFuel;
    }

    public FuelFluidHandler getFuelHandler(FuelType fuelType) {
        return fuelType == FuelType.COLD ? this.coldFuelHandler : this.hotFuelHandler;
    }

    protected void addFuel(FuelType fuelType, int amount, boolean update) {
        FluidStack fillStack;
        FuelFluidHandler handler = this.getFuelHandler(fuelType);
        int filledAmount = handler.fill(fillStack = new FluidStack(handler.getDefaultFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        if (filledAmount > 0 && update) {
            this.onFuelChanged(fuelType);
        }
    }

    protected void drainFuel(FuelType fuelType, int amount, boolean update) {
        FluidStack drainStack;
        FuelFluidHandler handler = this.getFuelHandler(fuelType);
        FluidStack drained = handler.drain(drainStack = new FluidStack(handler.getDefaultFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        if (drained.getAmount() > 0 && update) {
            this.onFuelChanged(fuelType);
        }
    }

    protected void setFuel(FuelType fuelType, int amount, boolean update) {
        FuelFluidHandler handler = this.getFuelHandler(fuelType);
        FluidStack currentFluid = handler.getFluid();
        FluidStack newFluid = new FluidStack(fuelType.getFluid(), amount);
        newFluid.applyComponents(currentFluid.getComponentsPatch());
        handler.setFluid(newFluid);
        if (currentFluid.getAmount() != amount && update) {
            this.onFuelChanged(fuelType);
        }
    }

    protected void onFuelChanged(FuelType fuelType) {
        boolean nowEmpty = this.getFuelHandler(fuelType).getFluid().isEmpty();
        if (nowEmpty && this.level != null) {
            this.level.playSound(null, this.getBlockPos(), this.getFuelDepleteSound(), SoundSource.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
        }
        this.updateFuelState();
        this.checkInputSignal();
    }

    public void addHotFuel(int amount, boolean update) {
        this.addFuel(FuelType.HOT, amount, update);
    }

    public void addColdFuel(int amount, boolean update) {
        this.addFuel(FuelType.COLD, amount, update);
    }

    public void drainHotFuel(int amount, boolean update) {
        this.drainFuel(FuelType.HOT, amount, update);
    }

    public void drainColdFuel(int amount, boolean update) {
        this.drainFuel(FuelType.COLD, amount, update);
    }

    public void setHotFuel(int amount, boolean update) {
        this.setFuel(FuelType.HOT, amount, update);
    }

    public void setColdFuel(int amount, boolean update) {
        this.setFuel(FuelType.COLD, amount, update);
    }

    public void addFuel(int amount) {
        if (amount > 0) {
            this.addHotFuel(amount, true);
        } else if (amount < 0) {
            this.addColdFuel(Math.abs(amount), true);
        }
    }

    public void updateFuelState() {
        if (this.level != null && !this.level.isClientSide) {
            WorldHelper.syncBlockEntityData((BlockEntity)this);
            this.lastColdFuel = this.getColdFuel();
            this.lastHotFuel = this.getHotFuel();
        }
    }

    protected SoundEvent getFuelDepleteSound() {
        return (SoundEvent)ModSounds.HEARTH_DEPLETE.value();
    }

    public boolean checkForSmokestack() {
        if (this.level == null) {
            return false;
        }
        BlockState aboveState = this.level.getBlockState(this.getBlockPos().above());
        boolean hadSmokestack = this.hasSmokestack;
        this.hasSmokestack = aboveState.getBlock() instanceof SmokestackBlock;
        if (this.hasSmokestack && !hadSmokestack) {
            this.registerLocation();
            if (this.level.isClientSide) {
                ClientOnlyHelper.addHearthPosition(this.getBlockPos());
            }
            this.getBlockState().updateNeighbourShapes((LevelAccessor)this.level, this.getBlockPos(), 3);
        } else if (!this.hasSmokestack && hadSmokestack) {
            this.forceUpdate();
            this.resetPaths();
            this.unregisterLocation();
            if (this.level.isClientSide) {
                ClientOnlyHelper.removeHearthPosition(this.getBlockPos());
            }
        }
        return this.hasSmokestack;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickParticles() {
        ParticleStatus status = (ParticleStatus)Minecraft.getInstance().options.particles().get();
        if (!this.hasSmokestack() || status == ParticleStatus.MINIMAL) {
            return;
        }
        RandomSource rand = this.level.random;
        for (Map.Entry<BlockPos, Direction> entry : this.pipeEnds.entrySet()) {
            double d5;
            double d4;
            double d3;
            double d2;
            double d1;
            double d0;
            BlockPos pos = entry.getKey();
            Direction face = entry.getValue();
            if (this.usingColdFuel && rand.nextDouble() < (double)this.getColdFuel() / 3000.0) {
                d0 = (double)pos.getX() + 0.5 + (double)face.getStepX() * 0.35;
                d1 = (double)pos.getY() + 0.5 + (double)face.getStepY() * 0.35;
                d2 = (double)pos.getZ() + 0.5 + (double)face.getStepZ() * 0.35;
                d3 = (rand.nextDouble() - 0.5) / 4.0;
                d4 = (rand.nextDouble() - 0.5) / 4.0;
                d5 = (rand.nextDouble() - 0.5) / 4.0;
                this.level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), d0 + d3, d1 + d4, d2 + d5, 0.0, 0.04, 0.0);
            }
            if (!this.usingHotFuel || !(rand.nextDouble() < (double)this.getHotFuel() / 3000.0)) continue;
            d0 = (double)pos.getX() + 0.5 + (double)face.getStepX() * 0.35;
            d1 = (double)pos.getY() + 0.5 + (double)face.getStepY() * 0.35;
            d2 = (double)pos.getZ() + 0.5 + (double)face.getStepZ() * 0.35;
            d3 = (rand.nextDouble() - 0.5) / 2.0;
            d4 = (rand.nextDouble() - 0.5) / 2.0;
            d5 = (rand.nextDouble() - 0.5) / 2.0;
            SimpleParticleType particle = rand.nextDouble() < 0.5 ? ParticleTypes.LARGE_SMOKE : ParticleTypes.SMOKE;
            this.level.addParticle((ParticleOptions)particle, d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions getAirParticle() {
        return (ParticleOptions)ModParticleTypes.HEARTH_AIR.get();
    }

    public void spawnAirParticle(int x, int y, int z, RandomSource rand) {
        ParticleStatus status = (ParticleStatus)Minecraft.getInstance().options.particles().get();
        if (status != ParticleStatus.ALL) {
            return;
        }
        float f = rand.nextFloat();
        float f2 = this.spreading ? 0.002f : 0.032f;
        if (f > f2) {
            return;
        }
        float xr = rand.nextFloat();
        float yr = rand.nextFloat();
        float zr = rand.nextFloat();
        float xm = rand.nextFloat() / 20.0f - 0.025f;
        float zm = rand.nextFloat() / 20.0f - 0.025f;
        this.level.addParticle(this.getAirParticle(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
    }

    public int getContainerSize() {
        return 1;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInv) {
        return new HearthContainer(id, playerInv, this);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.loadEffects(tag);
        this.getFuelHandler(FuelType.COLD).setFluid(FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("ColdFuel")));
        this.getFuelHandler(FuelType.HOT).setFluid(FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("HotFuel")));
        this.insulationLevel = tag.getInt("InsulationLevel");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        FluidStack hotFuel;
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.saveEffects(tag);
        FluidStack coldFuel = this.getFuelHandler(FuelType.COLD).getFluid();
        if (!coldFuel.isEmpty()) {
            tag.put("ColdFuel", coldFuel.save(registries));
        }
        if (!(hotFuel = this.getFuelHandler(FuelType.HOT).getFluid()).isEmpty()) {
            tag.put("HotFuel", hotFuel.save(registries));
        }
        tag.putInt("InsulationLevel", this.insulationLevel);
    }

    void saveEffects(CompoundTag tag) {
        if (!this.effects.isEmpty()) {
            ListTag list = new ListTag();
            for (MobEffectInstance effect : this.effects) {
                list.add((Object)effect.save());
            }
            tag.put("Effects", (Tag)list);
        }
    }

    void loadEffects(CompoundTag tag) {
        this.effects.clear();
        if (tag.contains("Effects")) {
            ListTag list = tag.getList("Effects", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.effects.add(MobEffectInstance.load((CompoundTag)list.getCompound(i)));
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("HotFuel", this.getHotFuel());
        tag.putInt("ColdFuel", this.getColdFuel());
        tag.putBoolean("ShouldUseColdFuel", this.usingColdFuel);
        tag.putBoolean("ShouldUseHotFuel", this.usingHotFuel);
        tag.putInt("InsulationLevel", this.insulationLevel);
        tag.putBoolean("IsCooling", this.isCoolingOn);
        tag.putBoolean("IsHeating", this.isHeatingOn);
        tag.putBoolean("HasSmokestack", this.hasSmokestack);
        this.saveEffects(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.setHotFuel(tag.getInt("HotFuel"), false);
        this.setColdFuel(tag.getInt("ColdFuel"), false);
        this.usingColdFuel = tag.getBoolean("ShouldUseColdFuel");
        this.usingHotFuel = tag.getBoolean("ShouldUseHotFuel");
        this.insulationLevel = tag.getInt("InsulationLevel");
        this.isCoolingOn = tag.getBoolean("IsCooling");
        this.isHeatingOn = tag.getBoolean("IsHeating");
        this.hasSmokestack = tag.getBoolean("HasSmokestack");
        this.loadEffects(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.handleUpdateTag(pkt.getTag(), registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void addPath(SpreadPath path) {
        this.paths.add(path);
    }

    public void addPaths(Collection<SpreadPath> newPaths) {
        this.paths.addAll(newPaths);
    }

    public void sendResetPacket() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.x >> 4, this.z >> 4), (CustomPacketPayload)new HearthResetMessage(this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendBlockUpdate(BlockPos pos) {
        this.queuedUpdates.add(pos);
    }

    public void forceUpdate() {
        this.forceRebuild = true;
        this.sendBlockUpdate(this.getBlockPos());
    }

    protected void cleanup() {
        HearthSaveDataHandler.HEARTH_POSITIONS.remove(Pair.of((Object)this.getBlockPos(), (Object)this.getLevel().dimension().location()));
        NeoForge.EVENT_BUS.unregister((Object)this);
        if (this.level.isClientSide) {
            ClientOnlyHelper.removeHearthPosition(this.getBlockPos());
        }
    }

    public Set<BlockPos> getPathLookup() {
        return this.pathLookup;
    }

    public List<SpreadPath> getPaths() {
        return this.paths;
    }

    public boolean isSpreading() {
        return this.spreading;
    }

    public boolean isCoolingOn() {
        return this.isCoolingOn;
    }

    public boolean isHeatingOn() {
        return this.isHeatingOn;
    }

    public void setCooling(boolean isPowered) {
        this.isCoolingOn = isPowered;
    }

    public void setHeating(boolean isPowered) {
        this.isHeatingOn = isPowered;
    }

    public Map<BlockPos, Direction> getPipeEnds() {
        return this.pipeEnds;
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction pDirection) {
        return this.getItemFuel(stack) != 0;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return true;
    }

    private static /* synthetic */ BlockPos lambda$tickPaths$0(SpreadPath p) {
        return p.pos;
    }

    static {
        try {
            TICK_DOWN_EFFECT = ObfuscationReflectionHelper.findMethod(MobEffectInstance.class, (String)"tickDownDuration", (Class[])new Class[0]);
            TICK_DOWN_EFFECT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class FuelFluidHandler
    implements IFluidHandler {
        private FluidStack fuel;
        private final FuelType fuelType;

        protected FuelFluidHandler(FuelType fuelType) {
            this.fuelType = fuelType;
            this.fuel = new FluidStack(this.fuelType.getFluid(), 0);
        }

        public int getTanks() {
            return 1;
        }

        public FuelType getFuelType() {
            return this.fuelType;
        }

        public int getFuelAmount() {
            return this.fuel.getAmount();
        }

        public FluidStack getFluid() {
            return this.fuel;
        }

        public void setFluid(FluidStack fluidStack) {
            this.fuel = fluidStack;
        }

        public Fluid getDefaultFluid() {
            return this.fuelType.getFluid();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.fuel;
        }

        public int getTankCapacity(int tank) {
            return HearthBlockEntity.this.getMaxFuel();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
            return fluidStack.getFluid().is(this.fuelType.getValidFluidTag());
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            if (fluidStack.getFluid().is(this.fuelType.getValidFluidTag())) {
                int amount = Math.min(fluidStack.getAmount(), this.getTankCapacity(0) - this.fuel.getAmount());
                if (fluidAction.execute()) {
                    if (this.fuel.isEmpty()) {
                        this.fuel = fluidStack.copy();
                    } else {
                        this.fuel.grow(amount);
                    }
                }
                return amount;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return this.isFluidValid(0, fluidStack) ? this.drain(fluidStack.getAmount(), fluidAction) : FluidStack.EMPTY;
        }

        public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
            int drained = Math.min(this.fuel.getAmount(), amount);
            if (drained == 0) {
                return new FluidStack(this.fuelType.getFluid(), 0);
            }
            FluidStack stack = new FluidStack(this.fuel.getFluidHolder(), drained);
            stack.applyComponents(this.fuel.getComponentsPatch());
            if (fluidAction.execute() && drained > 0) {
                this.fuel.shrink(drained);
            }
            HearthBlockEntity.this.setChanged();
            return stack;
        }
    }

    public static enum FuelType {
        COLD(0),
        HOT(1);

        private final int tankIndex;

        private FuelType(int tankIndex) {
            this.tankIndex = tankIndex;
        }

        public int getTankIndex() {
            return this.tankIndex;
        }

        public Fluid getFluid() {
            return this == COLD ? (Fluid)ModFluids.SLUSH.value() : Fluids.LAVA;
        }

        public TagKey<Fluid> getValidFluidTag() {
            return this == COLD ? ModFluidTags.COLD : ModFluidTags.HOT;
        }
    }
}

