/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.IceboxContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModParticleTypes;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class IceboxBlockEntity
extends HearthBlockEntity
implements LidBlockEntity {
    public static int[] WATERSKIN_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static int[] FUEL_SLOT = new int[]{0};
    private boolean hasItemStacks = false;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            if (!IceboxBlockEntity.this.hasSmokestack()) {
                IceboxBlockEntity.this.level.playSound(null, pos, (SoundEvent)ModSounds.ICEBOX_OPEN.value(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.9f);
            }
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            if (!IceboxBlockEntity.this.hasSmokestack()) {
                IceboxBlockEntity.this.level.playSound(null, pos, (SoundEvent)ModSounds.ICEBOX_CLOSE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
            IceboxBlockEntity.this.signalOpenCount(level, pos, state, eventId, eventParam);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (!(abstractContainerMenu instanceof IceboxContainer)) return false;
            IceboxContainer container = (IceboxContainer)abstractContainerMenu;
            if (!((Object)((Object)container.te)).equals((Object)IceboxBlockEntity.this)) return false;
            return true;
        }
    };
    ChestLidController lidController = new ChestLidController();

    public IceboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ICEBOX.value(), pos, state);
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.lidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        Block block = state.getBlock();
        level.blockEvent(pos, block, eventId, eventParam);
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"container.cold_sweat.icebox");
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof IceboxBlockEntity) {
            IceboxBlockEntity iceboxTE = (IceboxBlockEntity)te;
            iceboxTE.tick(level, state, pos);
            if (level.isClientSide()) {
                IceboxBlockEntity.tickAnimateLid(level, pos, state, iceboxTE);
            }
        }
    }

    public static <T extends BlockEntity> void tickAnimateLid(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            icebox.lidController.tickLid();
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        super.tick(level, pos);
        if (!this.remove && this.level != null && this.level.getServer() != null) {
            this.openersCounter.recheckOpeners(this.level, this.getBlockPos(), this.getBlockState());
        }
        if (!level.isClientSide() && this.getFuel() > 0 && this.ticksExisted % (int)(20.0 / Math.max(1.0, ConfigSettings.TEMP_RATE.get())) == 0) {
            this.hasItemStacks = false;
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = this.getItem(i);
                double itemTemp = (Double)stack.getOrDefault((DataComponentType)ModItemComponents.WATER_TEMPERATURE.value(), (Object)0.0);
                if (!stack.is(ModItems.FILLED_WATERSKIN) || !(itemTemp > -50.0)) continue;
                this.hasItemStacks = true;
                stack.set((DataComponentType)ModItemComponents.WATER_TEMPERATURE.value(), (Object)Math.max(-50.0, itemTemp - 1.0));
            }
        }
    }

    @Override
    public int getSpreadRange() {
        return ConfigSettings.ICEBOX_RANGE.get();
    }

    @Override
    public int getMaxRange() {
        return ConfigSettings.ICEBOX_MAX_RANGE.get();
    }

    @Override
    public int getMaxPaths() {
        return ConfigSettings.ICEBOX_MAX_VOLUME.get();
    }

    @Override
    public int getInsulationTime() {
        return ConfigSettings.ICEBOX_WARM_UP_TIME.get();
    }

    @Override
    public int getMaxInsulationLevel() {
        return ConfigSettings.ICEBOX_MAX_INSULATION.get();
    }

    @Override
    public SoundEvent getFuelDepleteSound() {
        return (SoundEvent)ModSounds.ICEBOX_DEPLETE.value();
    }

    @Override
    public boolean hasSmokestack() {
        return this.hasSmokestack;
    }

    @Override
    protected boolean isSmartEnabled() {
        return ConfigSettings.SMART_ICEBOX.get();
    }

    @Override
    protected void tickPaths(int firstIndex, int lastIndex) {
        if (this.hasSmokestack) {
            super.tickPaths(firstIndex, lastIndex);
        }
    }

    @Override
    protected int getFuelDrainInterval() {
        return ConfigSettings.ICEBOX_FUEL_INTERVAL.get();
    }

    @Override
    public boolean isUsingColdFuel() {
        return super.isUsingColdFuel() || this.hasItemStacks;
    }

    @Override
    public void checkForStateChange() {
        super.checkForStateChange();
        this.ensureState(IceboxBlock.FROSTED, this.getColdFuel() > 0);
    }

    @Override
    public List<Direction> getCoolingSides() {
        return Arrays.asList(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN);
    }

    @Override
    public List<Direction> getHeatingSides() {
        return List.of();
    }

    @Override
    public boolean supportsHeating() {
        return false;
    }

    @Override
    public int getItemFuel(ItemStack item) {
        return CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.ICEBOX_FUEL, item.getItem(), data -> data.test(item)), FuelData::fuel, 0.0).intValue();
    }

    @Override
    protected void storeFuel(ItemStack stack, int amount) {
        if ((double)this.getFuel() < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasCraftingRemainingItem() || stack.getCount() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - this.getFuel()) / (double)Math.abs(amount)), stack.getCount());
                stack.shrink(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.setItem(0, stack.getCraftingRemainingItem());
                this.addFuel(amount);
            }
        }
    }

    public int getFuel() {
        return this.getColdFuel();
    }

    public void setFuel(int amount) {
        this.setColdFuel(amount, true);
    }

    @Override
    public void addFuel(int amount) {
        this.addColdFuel(amount, true);
    }

    @Override
    protected boolean isFuelChanged() {
        return this.ticksExisted % 10 == 0;
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInv) {
        return new IceboxContainer(id, playerInv, this);
    }

    public void startOpen(Player player) {
        super.startOpen(player);
        this.openersCounter.incrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
    }

    public void stopOpen(Player player) {
        super.stopOpen(player);
        this.openersCounter.decrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
    }

    @Override
    protected void tickParticles() {
        if (this.hasSmokestack) {
            super.tickParticles();
        }
    }

    @Override
    public ParticleOptions getAirParticle() {
        return (ParticleOptions)ModParticleTypes.GROUND_MIST.get();
    }

    @Override
    public void spawnAirParticle(int x, int y, int z, RandomSource rand) {
        BlockPos pos = new BlockPos(x, y, z);
        boolean onGround = !this.level.getBlockState(pos.below()).isAir();
        float f = rand.nextFloat();
        float f2 = this.spreading ? 0.016f : 0.032f;
        if (f > f2) {
            return;
        }
        float xr = rand.nextFloat();
        float yr = onGround ? 0.1f : rand.nextFloat();
        float zr = rand.nextFloat();
        float xm = rand.nextFloat() / 20.0f - 0.025f;
        float zm = rand.nextFloat() / 20.0f - 0.025f;
        this.level.addParticle(onGround ? (ParticleOptions)ModParticleTypes.GROUND_MIST.get() : (ParticleOptions)ModParticleTypes.MIST.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
    }

    @Override
    public int getContainerSize() {
        return 10;
    }

    @Override
    public int[] getSlotsForFace(Direction side) {
        return side.getAxis() == Direction.Axis.Y ? WATERSKIN_SLOTS : FUEL_SLOT;
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction direction) {
        if (slot == 0) {
            return this.getItemFuel(stack) != 0;
        }
        return stack.is(ModItemTags.ICEBOX_VALID) || stack.getFoodProperties(null) != null;
    }

    @Override
    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return slot > 0;
    }

    public float getOpenNess(float partialTick) {
        return this.lidController.getOpenness(partialTick);
    }
}

