/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.common.blockentity.BoilerBlockEntity;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.core.init.ModMenus;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BoilerContainer
extends AbstractContainerMenu {
    public final BoilerBlockEntity te;

    public BoilerContainer(int windowId, Inventory playerInv, final BoilerBlockEntity te) {
        super((MenuType)ModMenus.BOILER_CONTAINER_TYPE.get(), windowId);
        this.te = te;
        this.addSlot(new Slot(this, (Container)te, 0, 80, 62){

            public boolean mayPlace(ItemStack stack) {
                return te.getItemFuel(stack) > 0;
            }
        });
        for (int in = 1; in < 10; ++in) {
            this.addSlot(new Slot(this, (Container)te, in, -10 + in * 18, 35){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(ModItemTags.BOILER_VALID) || CompatManager.isThirstLoaded() && CompatManager.Thirst.hasPurity(stack);
                }

                public void setChanged() {
                    super.setChanged();
                    te.checkForItems();
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + 9 * row + 9, 8 + col * 18, 163 - (4 - row) * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 149));
        }
    }

    public BoilerContainer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(windowId, playerInv, BoilerContainer.getTileEntity(playerInv, data));
    }

    public int getFuel() {
        return this.te.getFuel();
    }

    private static BoilerBlockEntity getTileEntity(Inventory playerInv, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "PacketBuffer inventory cannot be null");
        BlockEntity te = playerInv.player.level().getBlockEntity(data.readBlockPos());
        if (te instanceof BoilerBlockEntity) {
            return (BoilerBlockEntity)te;
        }
        throw new IllegalStateException("Tile Entity is not correct");
    }

    public boolean stillValid(Player playerIn) {
        return playerIn.distanceToSqr((double)this.te.getBlockPos().getX(), (double)this.te.getBlockPos().getY(), (double)this.te.getBlockPos().getZ()) <= 64.0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (CSMath.betweenInclusive(index, 0.0, 9.0)) {
                if (!this.moveItemStackTo(itemstack1, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (this.getSlot(1).mayPlace(itemstack)) {
                    if (!this.moveItemStackTo(itemstack1, 1, 10, false)) {
                        slot.onQuickCraft(itemstack1, itemstack);
                        return ItemStack.EMPTY;
                    }
                } else if (this.getSlot(0).mayPlace(itemstack)) {
                    if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                        slot.onQuickCraft(itemstack1, itemstack);
                        return ItemStack.EMPTY;
                    }
                } else if (CSMath.betweenInclusive(index, this.slots.size() - 9, this.slots.size())) {
                    if (!this.moveItemStackTo(itemstack1, 10, 36, false)) {
                        slot.onQuickCraft(itemstack1, itemstack);
                        return ItemStack.EMPTY;
                    }
                } else if (CSMath.betweenInclusive(index, 10.0, this.slots.size() - 9) && !this.moveItemStackTo(itemstack1, this.slots.size() - 9, this.slots.size(), false)) {
                    slot.onQuickCraft(itemstack1, itemstack);
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(itemstack1, itemstack);
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

