/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.init;

import com.momosoftworks.coldsweat.api.event.client.InsulatorTabBuildEvent;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.item.FilledWaterskinItem;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.item.ItemStackHelper;
import com.momosoftworks.coldsweat.util.serialization.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> ITEM_GROUPS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"cold_sweat");
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> COLD_SWEAT_TAB = ITEM_GROUPS.register("cold_sweat", () -> CreativeModeTab.builder().icon(() -> FilledWaterskinItem.getDisplayStack()).displayItems((params, list) -> list.acceptAll(List.of(((Item)ModItems.WATERSKIN.value()).getDefaultInstance(), ObjectBuilder.build(() -> {
        ItemStack stack = ((Item)ModItems.FILLED_WATERSKIN.value()).getDefaultInstance();
        stack = CompatManager.Thirst.setPurity(stack, 3);
        return stack;
    }), ((Item)ModItems.GOAT_FUR.value()).getDefaultInstance(), ((Item)ModItems.HOGLIN_HIDE.value()).getDefaultInstance(), ((Item)ModItems.CHAMELEON_MOLT.value()).getDefaultInstance(), ((Item)ModItems.MINECART_INSULATION.value()).getDefaultInstance(), ((Item)ModItems.INSULATED_MINECART.value()).getDefaultInstance(), ObjectBuilder.build(() -> {
        ItemStack stack = ((Item)ModItems.SOULSPRING_LAMP.value()).getDefaultInstance();
        stack.set(ModItemComponents.SOULSPRING_LAMP_LIT, (Object)true);
        stack.set(ModItemComponents.SOULSPRING_LAMP_FUEL, (Object)64.0);
        return stack;
    }), ((BlockItem)ModItems.SOUL_SPROUT.value()).getDefaultInstance(), ((Item)ModItems.THERMOMETER.value()).getDefaultInstance(), ((BlockItem)ModItems.THERMOLITH.value()).getDefaultInstance(), ((BlockItem)ModItems.HEARTH.value()).getDefaultInstance(), ((BlockItem)ModItems.BOILER.value()).getDefaultInstance(), ((BlockItem)ModItems.ICEBOX.value()).getDefaultInstance(), ((BlockItem)ModItems.SMOKESTACK.value()).getDefaultInstance(), ((BlockItem)ModItems.SEWING_TABLE.value()).getDefaultInstance(), ((Item)ModItems.HOGLIN_HELMET.value()).getDefaultInstance(), ((Item)ModItems.HOGLIN_CHESTPLATE.value()).getDefaultInstance(), ((Item)ModItems.HOGLIN_LEGGINGS.value()).getDefaultInstance(), ((Item)ModItems.HOGLIN_BOOTS.value()).getDefaultInstance(), ((Item)ModItems.GOAT_FUR_HELMET.value()).getDefaultInstance(), ((Item)ModItems.GOAT_FUR_CHESTPLATE.value()).getDefaultInstance(), ((Item)ModItems.GOAT_FUR_LEGGINGS.value()).getDefaultInstance(), ((Item)ModItems.GOAT_FUR_BOOTS.value()).getDefaultInstance(), ((Item)ModItems.CHAMELEON_HELMET.value()).getDefaultInstance(), ((Item)ModItems.CHAMELEON_CHESTPLATE.value()).getDefaultInstance(), ((Item)ModItems.CHAMELEON_LEGGINGS.value()).getDefaultInstance(), ((Item)ModItems.CHAMELEON_BOOTS.value()).getDefaultInstance(), ((DeferredSpawnEggItem)ModItems.CHAMELEON_SPAWN_EGG.value()).getDefaultInstance()))).title((Component)Component.translatable((String)"itemGroup.cold_sweat")).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> INSULATION_ITEMS_TAB = ITEM_GROUPS.register("cs_insulation_items", () -> CreativeModeTab.builder().icon(() -> ((Item)ModItems.CHAMELEON_MOLT.value()).getDefaultInstance()).displayItems((params, list) -> {
        ArrayList allInsulators = new ArrayList();
        Stream.of(ModCreativeTabs.sort(ConfigSettings.INSULATION_ITEMS.get().entries()), ModCreativeTabs.sort(ConfigSettings.INSULATING_ARMORS.get().entries()), ModCreativeTabs.sort(ConfigSettings.INSULATING_CURIOS.get().entries())).flatMap(Collection::stream).forEach(stack -> {
            if (allInsulators.stream().noneMatch(s -> s.getItem() == stack.getItem())) {
                allInsulators.add(stack);
            }
        });
        list.acceptAll(allInsulators);
    }).title((Component)Component.translatable((String)"itemGroup.cs_insulation_items")).build());

    private static List<ItemStack> sort(Collection<Map.Entry<Item, InsulatorData>> items) {
        ArrayList<Map.Entry<Item, InsulatorData>> list = new ArrayList<Map.Entry<Item, InsulatorData>>(items);
        list.removeIf(entry -> entry.getKey() == null || entry.getKey() == Items.AIR);
        list.sort(Comparator.comparing(entry -> ((Stream)((Item)entry.getKey()).builtInRegistryHolder().tags().sequential()).map(tag -> tag.location().toString()).reduce("", (a, b) -> a + b)));
        list.sort(Comparator.comparingInt(entry -> ((InsulatorData)entry.getValue()).insulation().stream().mapToInt(Insulation::getCompareValue).min().orElse(0)));
        list.sort(Comparator.comparing(entry -> {
            Object object;
            Object patt0$temp = entry.getKey();
            if (patt0$temp instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)patt0$temp;
                object = armor.getMaterial().getKey().location().toString() + (3 - ItemStackHelper.getEquipmentSlot(((Item)entry.getKey()).getDefaultInstance()).getIndex());
            } else {
                object = "";
            }
            return object;
        }));
        InsulatorTabBuildEvent event = new InsulatorTabBuildEvent(list);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getItems().stream().map(entry -> new ItemStack((ItemLike)entry.getKey())).toList();
    }
}

