/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.entity;

import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.core.init.ModItems;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;

public class EntityHelper {
    private EntityHelper() {
    }

    public static ItemStack getItemInHand(LivingEntity player, HumanoidArm hand) {
        return player.getItemInHand(hand == player.getMainArm() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public static HumanoidArm getArmFromHand(InteractionHand hand, Player player) {
        return hand == InteractionHand.MAIN_HAND ? player.getMainArm() : (player.getMainArm() == HumanoidArm.RIGHT ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
    }

    public static boolean holdingLamp(LivingEntity player, HumanoidArm arm) {
        return EntityHelper.getItemInHand(player, arm).getItem() == ModItems.SOULSPRING_LAMP.value();
    }

    public static boolean holdingLitLamp(LivingEntity player) {
        return Stream.of(HumanoidArm.LEFT, HumanoidArm.RIGHT).anyMatch(arm -> EntityHelper.holdingLamp(player, arm) && SoulspringLampItem.isLit(EntityHelper.getItemInHand(player, arm)));
    }

    public static Vec3 getCenterOf(Entity entity) {
        return entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
    }

    public static ServerPlayer getServerPlayer(Player player) {
        return ((MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER)).getPlayerList().getPlayer(player.getUUID());
    }

    @Nullable
    public static EquipmentSlot getEquipmentSlot(int index) {
        if (index == 100 + EquipmentSlot.HEAD.getIndex()) {
            return EquipmentSlot.HEAD;
        }
        if (index == 100 + EquipmentSlot.CHEST.getIndex()) {
            return EquipmentSlot.CHEST;
        }
        if (index == 100 + EquipmentSlot.LEGS.getIndex()) {
            return EquipmentSlot.LEGS;
        }
        if (index == 100 + EquipmentSlot.FEET.getIndex()) {
            return EquipmentSlot.FEET;
        }
        if (index == 98) {
            return EquipmentSlot.MAINHAND;
        }
        return index == 99 ? EquipmentSlot.OFFHAND : null;
    }
}

