/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat;

import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.client.renderer.entity.GoatEntityRenderer;
import com.momosoftworks.coldsweat.common.capability.DummyCapStorage;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.common.capability.shearing.IShearableCap;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.command.argument.NicerEnumArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempAttributeTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TemperatureTraitArgument;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ModUpdater;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ActivityInit;
import com.momosoftworks.coldsweat.core.init.AttributeInit;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.core.init.ContainerInit;
import com.momosoftworks.coldsweat.core.init.EffectInit;
import com.momosoftworks.coldsweat.core.init.EntityInit;
import com.momosoftworks.coldsweat.core.init.FeatureInit;
import com.momosoftworks.coldsweat.core.init.FluidInit;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.init.MemoryInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.init.PotionInit;
import com.momosoftworks.coldsweat.core.init.SensorTypeInit;
import com.momosoftworks.coldsweat.core.init.SoundInit;
import com.momosoftworks.coldsweat.core.init.TempEffectInit;
import com.momosoftworks.coldsweat.core.itemgroup.InsulationItemsGroup;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import com.momosoftworks.coldsweat.util.registries.ModFluids;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="cold_sweat")
@Mod.EventBusSubscriber
public class ColdSweat {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cold Sweat");
    public static final String MOD_ID = "cold_sweat";
    public static IEventBus MOD_BUS;

    public ColdSweat() {
        MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MOD_BUS.addListener(this::commonSetup);
        MOD_BUS.addListener(this::clientSetup);
        MOD_BUS.addListener(this::registerCaps);
        MOD_BUS.addListener(this::updateConfigs);
        if (CompatManager.isCuriosLoaded()) {
            MOD_BUS.addListener(this::registerCurioSlots);
        }
        BlockInit.BLOCKS.register(MOD_BUS);
        FluidInit.FLUIDS.register(MOD_BUS);
        ItemInit.ITEMS.register(MOD_BUS);
        EntityInit.ENTITY_TYPES.register(MOD_BUS);
        BlockEntityInit.BLOCK_ENTITY_TYPES.register(MOD_BUS);
        ContainerInit.MENU_TYPES.register(MOD_BUS);
        EffectInit.EFFECTS.register(MOD_BUS);
        ParticleTypesInit.PARTICLES.register(MOD_BUS);
        PotionInit.POTIONS.register(MOD_BUS);
        SoundInit.SOUNDS.register(MOD_BUS);
        FeatureInit.FEATURES.register(MOD_BUS);
        AttributeInit.ATTRIBUTES.register(MOD_BUS);
        ActivityInit.ACTIVITIES.register(MOD_BUS);
        SensorTypeInit.SENSORS.register(MOD_BUS);
        MemoryInit.MEMORIES.register(MOD_BUS);
        TempEffectInit.TEMP_EFFECTS.register(MOD_BUS);
        ModUpdater.updateFileNames();
        MainSettingsConfig.setup();
        ClientSettingsConfig.setup();
        WorldSettingsConfig.setup();
        ItemSettingsConfig.setup();
        EntitySettingsConfig.setup();
        CompatManager.registerEventHandlers();
    }

    public static ResourceLocation createKey(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static String getVersion() {
        return ModUpdater.getVersionString(((ModContainer)ModList.get().getModContainerById(MOD_ID).get()).getModInfo().getVersion());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ColdSweatPacketHandler.init();
        event.enqueueWork(() -> {
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.TEMPERATURE_CHANGED);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.SOUL_LAMP_FUELLED);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.BLOCK_AFFECTS_TEMP);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.ARMOR_INSULATED);
            InsulationItemsGroup.INSULATION_ITEMS.register();
            ArgumentTypes.func_218136_a((String)"temperature_trait", TemperatureTraitArgument.class, (IArgumentSerializer)new TemperatureTraitArgument.Serializer());
            ArgumentTypes.func_218136_a((String)"temp_attribute_trait", TempAttributeTraitArgument.class, (IArgumentSerializer)new TempAttributeTraitArgument.Serializer());
            ArgumentTypes.func_218136_a((String)"temp_modifier_trait", TempModifierTraitArgument.class, (IArgumentSerializer)new TempModifierTraitArgument.Serializer());
            ArgumentTypes.func_218136_a((String)"temp_modifier", TempModifierArgument.class, (IArgumentSerializer)new TempModifierArgument.Serializer());
            ArgumentTypes.func_218136_a((String)"enum", NicerEnumArgument.class, new NicerEnumArgument.Serializer());
        });
    }

    public void registerCaps(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITemperatureCap.class, new DummyCapStorage(), EntityTempCap::new);
        CapabilityManager.INSTANCE.register(IShearableCap.class, new DummyCapStorage(), ShearableFurCap::new);
        CapabilityManager.INSTANCE.register(IInsulatableCap.class, new DummyCapStorage(), ItemInsulationCap::new);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.SOUL_STALK, (RenderType)RenderType.func_228641_d_());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CHAMELEON, ChameleonEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.GOAT, GoatEntityRenderer::new);
        RenderTypeLookup.setRenderLayer((Fluid)ModFluids.SLUSH, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)ModFluids.FLOWING_SLUSH, (RenderType)RenderType.func_228645_f_());
    }

    public void updateConfigs(FMLLoadCompleteEvent event) {
        ModUpdater.updateConfigs();
    }

    public void registerCurioSlots(InterModEnqueueEvent event) {
        event.enqueueWork(() -> InterModComms.sendTo((String)MOD_ID, (String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build()));
    }
}

