/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.block_temp;

import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ConfiguredBlockTemp
extends BlockTemp {
    private final BlockTempData data;

    public ConfiguredBlockTemp(BlockTempData data) {
        super(-data.getMaxEffect(), data.getMaxEffect(), data.getMinTemp(), data.getMaxTemp(), data.range(), data.fade(), data.logarithmic(), RegistryHelper.mapTaggableList(data.block().flatten(BlockRequirement::blocks)).toArray(new Block[0]));
        this.data = data;
    }

    @Override
    public boolean isValid(World level, BlockPos pos, BlockState state) {
        return this.data.block().test(req -> req.test(level, pos, state));
    }

    @Override
    public double getTemperature(World level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
        if (this.data.location().test(req -> req.test(level, pos)) && this.data.entity().test(req -> req.test((Entity)entity))) {
            double temp = this.data.getTemperature();
            if (ConfigSettings.COLD_SOUL_FIRE.get().booleanValue() && state.func_235714_a_(ModBlockTags.SOUL_FIRE)) {
                temp *= -1.0;
            }
            return temp;
        }
        return 0.0;
    }

    public BlockTempData getData() {
        return this.data;
    }

    public boolean isInGroup(List<RegistryKey<BlockTempData>> group) {
        return this.data.effectGroup().map(list -> list.stream().anyMatch(group::contains)).orElse(false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfiguredBlockTemp)) {
            return false;
        }
        ConfiguredBlockTemp that = (ConfiguredBlockTemp)obj;
        return this.data.equals(that.data);
    }
}

