/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;

public class AcclimationTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (entity instanceof DummyPlayer || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
            return temp -> temp;
        }
        double minTemp = Temperature.get(entity, Temperature.Trait.FREEZING_POINT);
        double maxTemp = Temperature.get(entity, Temperature.Trait.BURNING_POINT);
        double tempFactor = CSMath.blend(-1.0, 1.0, Temperature.get(entity, Temperature.Trait.WORLD), minTemp, maxTemp);
        double acclimateSpeed = ConfigSettings.ACCLIMATION_SPEED.get() * (double)this.getTickRate() / 20.0;
        switch (trait) {
            case FREEZING_POINT: {
                Pair<Double, Double> minAcclimationRange = ConfigSettings.MIN_ACCLIMATION_RANGE.get();
                double minAcclimation = this.getNBT().func_74769_h("MinAcclimation");
                double acclimationDelta = tempFactor < -0.5 ? -acclimateSpeed : (tempFactor < 0.5 ? acclimateSpeed / 2.0 : acclimateSpeed);
                double lowerBound = (Double)minAcclimationRange.getFirst();
                double upperBound = Math.max(minAcclimation, tempFactor > 0.5 ? (Double)minAcclimationRange.getSecond() : 0.0);
                double newMinAcclimation = CSMath.clamp(minAcclimation + acclimationDelta, lowerBound, upperBound);
                this.getNBT().func_74780_a("MinAcclimation", newMinAcclimation);
                return temp -> temp + this.getNBT().func_74769_h("MinAcclimation");
            }
            case BURNING_POINT: {
                Pair<Double, Double> maxAcclimationRange = ConfigSettings.MAX_ACCLIMATION_RANGE.get();
                double maxAcclimation = this.getNBT().func_74769_h("MaxAcclimation");
                double acclimationDelta = tempFactor > 0.5 ? acclimateSpeed : (tempFactor > -0.5 ? -acclimateSpeed / 2.0 : -acclimateSpeed);
                double lowerBound = Math.min(maxAcclimation, tempFactor < -0.5 ? (Double)maxAcclimationRange.getFirst() : 0.0);
                double upperBound = (Double)maxAcclimationRange.getSecond();
                double newMaxAcclimation = CSMath.clamp(maxAcclimation + acclimationDelta, lowerBound, upperBound);
                this.getNBT().func_74780_a("MaxAcclimation", newMaxAcclimation);
                return temp -> temp + this.getNBT().func_74769_h("MaxAcclimation");
            }
        }
        return temp -> temp;
    }
}

