/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.ConfiguredBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.Triplet;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;

public class BlockTempModifier
extends TempModifier {
    protected static final double LOG_FACTOR = 0.52;
    Map<ChunkPos, IChunk> chunks = new HashMap<ChunkPos, IChunk>(9);
    Map<BlockTemp, Double> blockTempTotals = new HashMap<BlockTemp, Double>(16);
    Map<BlockPos, BlockState> stateCache = new HashMap<BlockPos, BlockState>(3000);
    List<Triplet<BlockPos, BlockTemp, Double>> triggers = new ArrayList<Triplet<BlockPos, BlockTemp, Double>>(16);

    public BlockTempModifier() {
    }

    public BlockTempModifier(int range) {
        if (range > 0) {
            this.getNBT().func_74768_a("RangeOverride", range);
        }
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        this.blockTempTotals.clear();
        this.stateCache.clear();
        this.triggers.clear();
        World world = entity.field_70170_p;
        int range = this.getNBT().func_150297_b("RangeOverride", 3) ? this.getNBT().func_74762_e("RangeOverride") : ConfigSettings.BLOCK_RANGE.get().intValue();
        BlockPos blockPos = entity.func_233580_cy_();
        int entX = blockPos.func_177958_n();
        int entY = blockPos.func_177956_o();
        int entZ = blockPos.func_177952_p();
        BlockPos.Mutable blockpos = new BlockPos.Mutable();
        boolean shouldTickAdvancements = this.getTicksExisted() % 20 == 0;
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                ChunkPos chunkPos = new ChunkPos(entX + x >> 4, entZ + z >> 4);
                IChunk chunk = this.chunks.get(chunkPos);
                if (chunk == null) {
                    chunk = WorldHelper.getChunk((IWorld)world, chunkPos);
                    this.chunks.put(chunkPos, chunk);
                }
                if (chunk == null) continue;
                block2: for (int y = -range; y < range; ++y) {
                    Collection<BlockTemp> blockTemps;
                    blockpos.func_181079_c(entX + x, entY + y, entZ + z);
                    BlockState state = this.stateCache.get(blockpos);
                    if (state == null) {
                        ChunkSection section = WorldHelper.getChunkSection(chunk, blockpos.func_177956_o());
                        state = section == null ? chunk.func_180495_p((BlockPos)blockpos) : section.func_177485_a(blockpos.func_177958_n() & 0xF, blockpos.func_177956_o() & 0xF, blockpos.func_177952_p() & 0xF);
                        this.stateCache.put(blockpos.func_185334_h(), state);
                    }
                    if (state.func_185904_a() == Material.field_151579_a || (blockTemps = BlockTempRegistry.getBlockTempsFor(state)).isEmpty() || blockTemps.size() == 1 && blockTemps.contains(BlockTempRegistry.DEFAULT_BLOCK_TEMP) || !this.areAnyBlockTempsInRange(blockTemps)) continue;
                    Vector3d pos = Vector3d.func_237489_a_((Vector3i)blockpos);
                    Vector3d playerClosest = WorldHelper.getClosestPointOnEntity(entity, pos);
                    int[] blocks = new int[1];
                    Vector3d ray = pos.func_178788_d(playerClosest);
                    Direction direction = Direction.func_210769_a((double)ray.field_72450_a, (double)ray.field_72448_b, (double)ray.field_72449_c);
                    WorldHelper.forBlocksInRay(playerClosest, pos, world, chunk, this.stateCache, (rayState, bpos) -> {
                        if (!bpos.equals((Object)blockpos) && WorldHelper.isSpreadBlocked((IWorld)world, rayState, bpos, direction, direction)) {
                            blocks[0] = blocks[0] + 1;
                        }
                    }, 3);
                    double distance = CSMath.getDistance(playerClosest, pos);
                    for (BlockTemp blockTemp : blockTemps) {
                        double newTotal;
                        if (!blockTemp.isValid(world, (BlockPos)blockpos, state)) continue;
                        double temperature = blockTemp.getTemperature(world, entity, state, (BlockPos)blockpos, distance);
                        double tempToAdd = blockTemp.fade() ? CSMath.blend(temperature, 0.0, distance, 0.5, blockTemp.range()) : temperature;
                        double blockTempTotal = this.blockTempTotals.getOrDefault(blockTemp, 0.0);
                        double blockGroupTotal = this.getGroupTotal(blockTemp);
                        double blockGroupDelta = blockGroupTotal - blockTempTotal;
                        if (blockTemp.logarithmic()) {
                            newTotal = Math.pow(Math.pow(blockTempTotal, 1.923076923076923) + tempToAdd, 0.52);
                            double delta = newTotal - blockTempTotal;
                            this.blockTempTotals.put(blockTemp, CSMath.clamp(blockTempTotal + (delta /= (double)(blocks[0] + 1)), blockTemp.minEffect() + blockGroupDelta, blockTemp.maxEffect() - blockGroupDelta));
                        } else {
                            newTotal = blockTempTotal + (tempToAdd /= (double)(blocks[0] + 1));
                            this.blockTempTotals.put(blockTemp, CSMath.clamp(newTotal, blockTemp.minEffect() + blockGroupDelta, blockTemp.maxEffect() - blockGroupDelta));
                        }
                        if (!shouldTickAdvancements) continue block2;
                        this.triggers.add(new Triplet<BlockPos.Mutable, BlockTemp, Double>(blockpos, blockTemp, distance));
                        continue block2;
                    }
                }
            }
        }
        if (entity instanceof ServerPlayerEntity && shouldTickAdvancements) {
            for (Triplet<BlockPos, BlockTemp, Double> trigger : this.triggers) {
                ModAdvancementTriggers.BLOCK_AFFECTS_TEMP.trigger((ServerPlayerEntity)entity, trigger.getA(), trigger.getC(), this.blockTempTotals.get(trigger.getB()));
            }
        }
        while (this.chunks.size() >= 16) {
            this.chunks.remove(this.chunks.keySet().iterator().next());
        }
        return temp -> {
            for (Map.Entry<BlockTemp, Double> entry : this.blockTempTotals.entrySet()) {
                BlockTemp blockTemp = entry.getKey();
                double min = blockTemp.minTemperature();
                double max = blockTemp.maxTemperature();
                if (!CSMath.betweenInclusive(temp, min, max)) continue;
                double effectValue = entry.getValue();
                temp = CSMath.clamp(temp + effectValue, min, max);
            }
            return temp;
        };
    }

    private boolean areAnyBlockTempsInRange(Collection<BlockTemp> blockTemps) {
        for (BlockTemp blockTemp : blockTemps) {
            if (!this.blockTempTotals.containsKey(blockTemp)) {
                return true;
            }
            double effectTotal = this.getGroupTotal(blockTemp);
            if (!CSMath.betweenInclusive(effectTotal, blockTemp.minEffect(), blockTemp.maxEffect())) continue;
            return true;
        }
        return false;
    }

    private double getGroupTotal(BlockTemp blockTemp) {
        if (!(blockTemp instanceof ConfiguredBlockTemp)) {
            return this.blockTempTotals.getOrDefault(blockTemp, 0.0);
        }
        ConfiguredBlockTemp config = (ConfiguredBlockTemp)blockTemp;
        double total = 0.0;
        List group = config.getData().effectGroup().orElse(null);
        if (group == null) {
            return this.blockTempTotals.getOrDefault(blockTemp, 0.0);
        }
        if (config.getData().registryKey().map(key -> !group.contains(key)).orElse(false).booleanValue()) {
            total += this.blockTempTotals.getOrDefault(blockTemp, 0.0).doubleValue();
        }
        return total += this.blockTempTotals.keySet().stream().filter(bt -> bt instanceof ConfiguredBlockTemp && ((ConfiguredBlockTemp)bt).isInGroup(group)).map(bt -> (ConfiguredBlockTemp)bt).mapToDouble(b -> this.blockTempTotals.getOrDefault(b, 0.0)).sum();
    }
}

