/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntitiesTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity affectedEnt, Temperature.Trait trait) {
        World level = affectedEnt.field_70170_p;
        AxisAlignedBB aabb = new AxisAlignedBB(affectedEnt.func_233580_cy_()).func_72317_d(0.0, (double)(affectedEnt.func_213302_cg() / 2.0f) - 0.5, 0.0).func_186662_g(16.0);
        List entities = affectedEnt.field_70170_p.func_175674_a((Entity)null, aabb, e -> true);
        if (entities.size() > 10) {
            entities = entities.subList(0, 10);
        }
        FastMap<EntityTempData, Double> effects = new FastMap<EntityTempData, Double>();
        double totalTemp = 0.0;
        for (Entity nearbyEnt : entities) {
            Collection entityTemps = ConfigSettings.ENTITY_TEMPERATURES.get().get((Object)nearbyEnt.func_200600_R());
            for (EntityTempData tempData : entityTemps) {
                if (!tempData.test(nearbyEnt, (Entity)affectedEnt)) continue;
                double entityTemp = tempData.getTemperatureEffect(nearbyEnt, (Entity)affectedEnt);
                AtomicInteger blocksBetween = new AtomicInteger();
                WorldHelper.forBlocksInRay(EntityHelper.getCenterOf((Entity)affectedEnt), EntityHelper.getCenterOf(nearbyEnt), level, (state, pos) -> {
                    if (state.func_200015_d((IBlockReader)level, pos)) {
                        blocksBetween.getAndIncrement();
                    }
                }, 3);
                entityTemp /= (double)(blocksBetween.get() + 1);
                double maxEffect = tempData.getMaxEffect();
                double currentTemp = effects.getOrDefault(tempData, 0.0);
                entityTemp = CSMath.clamp(entityTemp, -maxEffect - currentTemp, maxEffect - currentTemp);
                double maxTemp = tempData.getMaxTemp();
                double minTemp = tempData.getMinTemp();
                double newEffect = currentTemp + entityTemp;
                newEffect = CSMath.clamp(newEffect, minTemp, maxTemp);
                double effectDelta = newEffect - currentTemp;
                totalTemp += effectDelta;
                effects.put(tempData, newEffect);
            }
        }
        double finalTemp = totalTemp;
        return temp -> temp + finalTemp;
    }
}

