/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class FoodTempModifier
extends TempModifier {
    public FoodTempModifier() {
        this(0.0);
    }

    public FoodTempModifier(double temperature) {
        this.getNBT().func_74780_a("temperature", temperature);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (this.isOverridden(trait)) {
            return temp -> temp;
        }
        return temp -> temp + this.getNBT().func_74769_h("temperature");
    }

    public boolean isOverridden(Temperature.Trait trait) {
        return this.getNBT().func_74775_l("Overridden").func_74762_e(trait.func_176610_l()) > 0;
    }

    private void incrementOverridden(Temperature.Trait trait, boolean add) {
        if (!this.getNBT().func_74764_b("Overridden")) {
            this.getNBT().func_218657_a("Overridden", (INBT)new CompoundNBT());
        }
        NBTHelper.incrementTag(this.getNBT().func_74775_l("Overridden"), trait.func_176610_l(), add ? 1 : -1, o -> true);
    }

    private void updateOverridden(LivingEntity entity, Temperature.Trait trait, TempModifier sibling, boolean add) {
        double temperature = this.getNBT().func_74769_h("temperature");
        if (sibling instanceof FoodTempModifier) {
            double siblingTemp = sibling.getNBT().func_74769_h("temperature");
            if (CSMath.sign(temperature) == CSMath.sign(siblingTemp) && Math.abs(siblingTemp) > Math.abs(temperature)) {
                this.incrementOverridden(trait, add);
                this.markDirty();
            }
            this.update(this.getLastInput(trait), entity, trait);
        }
    }

    @Override
    public void onSiblingAdded(LivingEntity entity, Temperature.Trait trait, TempModifier sibling) {
        this.updateOverridden(entity, trait, sibling, true);
    }

    @Override
    public void onAdded(LivingEntity entity, Temperature.Trait trait) {
        Temperature.getModifiers(entity, trait).forEach(mod -> this.updateOverridden(entity, trait, (TempModifier)mod, true));
    }

    @Override
    public void onSiblingRemoved(LivingEntity entity, Temperature.Trait trait, TempModifier sibling) {
        this.updateOverridden(entity, trait, sibling, false);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TempModifier && this.getClass().equals(((TempModifier)obj).getClass())) {
            CompoundNBT thisNBT = this.getNBT().func_74737_b();
            thisNBT.func_82580_o("Overridden");
            CompoundNBT otherNBT = ((TempModifier)obj).getNBT().func_74737_b();
            otherNBT.func_82580_o("Overridden");
            return otherNBT.equals((Object)thisNBT);
        }
        return false;
    }
}

