/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryItemsTempModifier
extends TempModifier {
    private final Map<Temperature.Trait, Double> effectsPerTrait = new EnumMap<Temperature.Trait, Double>(Temperature.Trait.class);

    public InventoryItemsTempModifier(double temp) {
        this.getNBT().func_74780_a("Effect", temp);
    }

    public InventoryItemsTempModifier() {
        this(0.0);
    }

    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        return temp -> temp + this.effectsPerTrait.getOrDefault(trait, 0.0);
    }

    @Override
    public void tick(LivingEntity entity) {
        this.effectsPerTrait.clear();
        HashMap effectsPerItemTemp = new HashMap();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = entity.func_184582_a(slot);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)item).forEach(itemData -> InventoryItemsTempModifier.checkAndAddItemTemp(entity, stack, -1, slot, itemData, effectsPerItemTemp));
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            for (Slot slot : player.field_71069_bz.field_75151_b) {
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                Item item = stack.func_77973_b();
                ConfigSettings.ITEM_TEMPERATURES.get().get((Object)item).forEach(itemData -> InventoryItemsTempModifier.checkAndAddItemTemp(entity, stack, slot.getSlotIndex(), null, itemData, effectsPerItemTemp));
            }
        }
        for (Map.Entry entry : effectsPerItemTemp.entrySet()) {
            Temperature.Trait dataTrait = ((ItemTempData)entry.getKey()).trait();
            double temp = (Double)entry.getValue();
            this.effectsPerTrait.put(dataTrait, this.effectsPerTrait.getOrDefault(dataTrait, 0.0) + temp);
        }
    }

    private static void checkAndAddItemTemp(LivingEntity entity, ItemStack stack, int slot, EquipmentSlotType equipmentSlot, ItemTempData itemData, Map<ItemTempData, Double> effectsPerItemTemp) {
        if (itemData.test((Entity)entity, stack, slot, equipmentSlot)) {
            double temp = itemData.temperature() * (double)stack.func_190916_E();
            double currentEffect = effectsPerItemTemp.getOrDefault(itemData, 0.0);
            double newEffect = currentEffect + temp;
            newEffect = temp > 0.0 ? Math.min(itemData.maxEffect(), newEffect) : Math.max(-itemData.maxEffect(), newEffect);
            newEffect = Math.max(itemData.minTemp(), Math.min(itemData.maxTemp(), newEffect));
            effectsPerItemTemp.put(itemData, newEffect);
        }
    }
}

