/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;

public class WaterTempModifier
extends TempModifier {
    public WaterTempModifier() {
        this(-0.01);
    }

    public WaterTempModifier(double temperature) {
        this.getNBT().func_74780_a("Temperature", temperature);
    }

    public double getTemperature() {
        return this.getNBT().func_74769_h("Temperature");
    }

    public void setTemperature(double temperature) {
        this.getNBT().func_74780_a("Temperature", temperature);
        if (temperature != this.getTemperature()) {
            this.markDirty();
        }
    }

    public double getTargetTemperature(LivingEntity entity) {
        Number[] waterTemps = (Double[])WorldHelper.getPositionGrid(entity.func_233580_cy_(), 9, 4).stream().map(pos -> WorldHelper.getWaterTemperatureAt(entity.field_70170_p, pos)).toArray(Double[]::new);
        return CSMath.average(waterTemps);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double minWorldTemp = ConfigSettings.MIN_TEMP.get();
        double maxWorldTemp = ConfigSettings.MAX_TEMP.get();
        double configDrySpeed = ConfigSettings.DRYOFF_SPEED.get();
        double temperature = this.getTemperature();
        double target = this.getTargetTemperature(entity);
        double addAmount = WorldHelper.isInWater((Entity)entity) ? (temperature < target ? Math.min(ConfigSettings.WATER_SOAK_SPEED.get(), target - temperature) : Math.max(-ConfigSettings.WATER_SOAK_SPEED.get().doubleValue(), target - temperature)) : (WorldHelper.isRainingAt(entity.field_70170_p, entity.func_233580_cy_()) ? Math.max(-ConfigSettings.RAIN_SOAK_SPEED.get().doubleValue(), -ConfigSettings.MAX_RAIN_SOAK.get().doubleValue() - temperature) : 0.0);
        double dryAmount = WorldHelper.isInWater((Entity)entity) ? 0.0 : CSMath.blendExp(configDrySpeed / 1.5, configDrySpeed * 5.0, worldTemp, minWorldTemp, maxWorldTemp, 20.0);
        double tickRate = (double)this.getTickRate() / 5.0;
        double newTemperature = CSMath.shrink(temperature + addAmount * tickRate, dryAmount * tickRate);
        if (newTemperature == 0.0) {
            this.expires(0);
        }
        this.setTemperature(newTemperature);
        return temp -> temp + newTemperature;
    }

    @Override
    public void tick(LivingEntity entity) {
        if (entity.field_70170_p.func_201670_d() && ConfigSettings.WATER_EFFECT_SETTING.get().showParticles() && !entity.func_70090_H() && Math.random() < Math.abs(this.getTemperature()) * 2.0) {
            double randX = (double)entity.func_213311_cf() * (Math.random() - 0.5);
            double randY = (double)entity.func_213302_cg() * Math.random();
            double randZ = (double)entity.func_213311_cf() * (Math.random() - 0.5);
            entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218425_n, entity.func_226277_ct_() + randX, entity.func_226278_cu_() + randY, entity.func_226281_cx_() + randZ, 0.0, 0.0, 0.0);
        }
        if (!entity.field_70170_p.field_72995_K && entity.func_70027_ad()) {
            this.setTemperature(CSMath.shrink(this.getTemperature(), 0.1));
            entity.func_70066_B();
        }
    }
}

