/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.ClientConfigAskMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.widget.Slider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DrawConfigButton {
    public static boolean EDIT_MODE = false;

    @SubscribeEvent
    public static void eventHandler(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof OptionsScreen && ConfigSettings.SHOW_CONFIG_BUTTON.get().booleanValue()) {
            Supplier<Vec2i> buttonPos = () -> ConfigSettings.CONFIG_BUTTON_POS.get();
            AtomicInteger xOffset = new AtomicInteger(buttonPos.get().x());
            AtomicInteger yOffset = new AtomicInteger(buttonPos.get().y());
            int buttonX = event.getGui().field_230708_k_ / 2 - 183;
            int buttonY = event.getGui().field_230709_l_ / 6 + 110;
            int screenWidth = event.getGui().field_230708_k_;
            int screenHeight = event.getGui().field_230709_l_;
            if (xOffset.get() + buttonX < -1 || yOffset.get() + buttonY < -1) {
                xOffset.set(0);
                yOffset.set(0);
                ConfigSettings.CONFIG_BUTTON_POS.set(new Vec2i(0, 0));
            }
            ImageButton mainButton = new ImageButton(buttonX + xOffset.get(), buttonY + yOffset.get(), 24, 24, 40, 40, 24, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                ConfigScreen.CURRENT_PAGE = 0;
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new ClientConfigAskMessage(Minecraft.func_71410_x().field_71439_g.func_110124_au()));
                }
            });
            if (Minecraft.func_71410_x().field_71441_e == null) {
                Field onTooltip = ObfuscationReflectionHelper.findField(Button.class, (String)"field_238487_u_");
                onTooltip.setAccessible(true);
                mainButton.field_230693_o_ = false;
                try {
                    onTooltip.set(mainButton, (button, poseStack, mouseX, mouseY) -> event.getGui().func_238652_a_(poseStack, (ITextComponent)new TranslationTextComponent("tooltip.cold_sweat.config.must_be_in_game").func_240699_a_(TextFormatting.RED), mouseX, mouseY));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            event.addWidget((Widget)mainButton);
            if (EDIT_MODE) {
                int buttonStartX = event.getGui().field_230708_k_ / 2 - 183;
                int buttonStartY = event.getGui().field_230709_l_ / 6 + 110;
                Runnable saveAndClamp = () -> {
                    xOffset.set(CSMath.clamp(xOffset.get(), -buttonStartX, screenWidth - mainButton.func_230998_h_() - buttonStartX));
                    yOffset.set(CSMath.clamp(yOffset.get(), -buttonStartY, screenHeight - mainButton.func_238483_d_() - buttonStartY));
                    mainButton.func_191746_c(buttonStartX + xOffset.get(), buttonStartY + yOffset.get());
                    ConfigSettings.CONFIG_BUTTON_POS.set(new Vec2i(xOffset.get(), yOffset.get()));
                };
                AtomicReference<Object> doneButtonAtomic = new AtomicReference<Object>(null);
                event.getGui().func_231039_at__().forEach(child -> {
                    if (child instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)child;
                        boolean isDoneButton = button.func_230458_i_().getString().equals(DialogTexts.field_240632_c_.getString());
                        if (!isDoneButton) {
                            button.field_230693_o_ = false;
                        } else {
                            doneButtonAtomic.set(button);
                            button.func_230991_b_(button.func_230998_h_() - 72);
                        }
                    }
                    if (child instanceof Slider) {
                        ((Slider)child).field_230693_o_ = false;
                    }
                });
                if (doneButtonAtomic.get() == null) {
                    return;
                }
                AbstractButton doneButton = doneButtonAtomic.get();
                ImageButton leftButton = new ImageButton(doneButton.field_230690_l_ + doneButton.func_230998_h_() + 2, doneButton.field_230691_m_, 14, 20, 0, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    xOffset.set(xOffset.get() - ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addWidget((Widget)leftButton);
                ImageButton upButton = new ImageButton(leftButton.field_230690_l_ + leftButton.func_230998_h_(), leftButton.field_230691_m_, 20, 10, 14, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    yOffset.set(yOffset.get() - ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addWidget((Widget)upButton);
                ImageButton downButton = new ImageButton(upButton.field_230690_l_, upButton.field_230691_m_ + upButton.func_238483_d_(), 20, 10, 14, 10, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    yOffset.set(yOffset.get() + ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addWidget((Widget)downButton);
                ImageButton rightButton = new ImageButton(upButton.field_230690_l_ + upButton.func_230998_h_(), upButton.field_230691_m_, 14, 20, 34, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    xOffset.set(xOffset.get() + ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addWidget((Widget)rightButton);
                ImageButton resetButton = new ImageButton(rightButton.field_230690_l_ + rightButton.func_230998_h_() + 2, rightButton.field_230691_m_, 20, 20, 48, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    xOffset.set(0);
                    yOffset.set(0);
                    saveAndClamp.run();
                });
                event.addWidget((Widget)resetButton);
                TaskScheduler.scheduleClient(() -> {
                    EDIT_MODE = false;
                }, 1);
            }
        }
    }
}

