/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.client.RenderWorldEvent;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HearthDebugRenderer {
    public static Map<BlockPos, Map<BlockPos, Collection<Direction>>> HEARTH_LOCATIONS = new HashMap<BlockPos, Map<BlockPos, Collection<Direction>>>();

    @SubscribeEvent
    public static void onLevelRendered(RenderWorldEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && ConfigSettings.HEARTH_DEBUG.get().booleanValue()) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            MatrixStack ms = event.getMatrixStack();
            Vector3d camPos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            World world = player.field_70170_p;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            IVertexBuilder vertexes = buffer.getBuffer((RenderType)RenderType.field_228614_Q_);
            ms.func_227860_a_();
            ms.func_227861_a_(-camPos.field_72450_a, -camPos.field_72448_b, -camPos.field_72449_c);
            Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
            Matrix3f matrix3f = ms.func_227866_c_().func_227872_b_();
            BiConsumer<Vector3f, Vector4f> nw = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b() + 1.0f, pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> ne = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b(), pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b() + 1.0f, pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> sw = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b() + 1.0f, pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> se = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b(), pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b() + 1.0f, pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> nu = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b() + 1.0f, pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, -1.0f, 0.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b() + 1.0f, pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, -1.0f, 0.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> nd = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 1.0f, 0.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b(), pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 1.0f, 0.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> su = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b() + 1.0f, pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 1.0f, 0.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b() + 1.0f, pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 1.0f, 0.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> sd = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 1.0f, 0.0f, 0.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b(), pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 1.0f, 0.0f, 0.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> eu = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b() + 1.0f, pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b() + 1.0f, pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> ed = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b(), pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, -1.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a() + 1.0f, pos.func_195900_b(), pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, -1.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> wu = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b() + 1.0f, pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b() + 1.0f, pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            };
            BiConsumer<Vector3f, Vector4f> wd = (pos, color) -> {
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
                vertexes.func_227888_a_(matrix4f, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c() + 1.0f).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            };
            IChunk workingChunk = null;
            float viewDistance = (float)Minecraft.func_71410_x().field_71474_y.field_151451_c * 2.0f;
            ArrayList<BlockPos> invalidHearths = new ArrayList<BlockPos>();
            for (Map.Entry<BlockPos, Map<BlockPos, Collection<Direction>>> entry : HEARTH_LOCATIONS.entrySet()) {
                if (!(world.func_175625_s(entry.getKey()) instanceof HearthBlockEntity)) {
                    invalidHearths.add(entry.getKey());
                    continue;
                }
                if (HearthSaveDataHandler.DISABLED_HEARTHS.contains(Pair.of((Object)entry.getKey(), (Object)world.func_234923_W_().func_240901_a_().toString()))) continue;
                Map<BlockPos, Collection<Direction>> points = entry.getValue();
                for (Map.Entry<BlockPos, Collection<Direction>> pair : points.entrySet()) {
                    BlockPos pos2 = pair.getKey();
                    Collection<Direction> directions = pair.getValue();
                    float x = pos2.func_177958_n();
                    float y = pos2.func_177956_o();
                    float z = pos2.func_177952_p();
                    float r = 1.0f;
                    float g = 0.7f;
                    float b = 0.6f;
                    float renderAlpha = CSMath.blend(1.0f, 0.0f, (float)CSMath.getDistance(player.func_213303_ch(), Vector3d.func_237489_a_((Vector3i)pos2)), 5.0f, viewDistance);
                    if (!(renderAlpha > 0.01f) || !new ClippingHelper(matrix4f, event.getProjectionMatrix()).func_228957_a_(new AxisAlignedBB(pos2))) continue;
                    ChunkPos chunkPos = new ChunkPos(pos2);
                    if (workingChunk == null || !workingChunk.func_76632_l().equals((Object)chunkPos)) {
                        workingChunk = WorldHelper.getChunk((IWorld)world, pos2);
                    }
                    if (workingChunk == null) continue;
                    BlockState state = workingChunk.func_180495_p(pos2);
                    VoxelShape blockShape = state.func_196954_c((IBlockReader)world, pos2);
                    if (!blockShape.func_197766_b() && !state.func_196952_d((IBlockReader)world, pos2).func_197766_b()) {
                        blockShape.func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> WorldRenderer.func_228427_a_((MatrixStack)ms, (IVertexBuilder)vertexes, (double)(minX + (double)x - 0.001), (double)(minY + (double)y - 0.001), (double)(minZ + (double)z - 0.001), (double)(maxX + (double)x + 0.001), (double)(maxY + (double)y + 0.001), (double)(maxZ + (double)z + 0.001), (float)r, (float)g, (float)b, (float)renderAlpha));
                        continue;
                    }
                    if (directions.size() == 6) continue;
                    HashSet lines = Sets.newHashSet((Object[])new BiConsumer[]{nw, ne, sw, se, nu, nd, su, sd, eu, ed, wu, wd});
                    if (directions.contains(Direction.DOWN)) {
                        Stream.of(nd, sd, ed, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.UP)) {
                        Stream.of(nu, su, eu, wu).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.NORTH)) {
                        Stream.of(nw, ne, nu, nd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.SOUTH)) {
                        Stream.of(sw, se, su, sd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.WEST)) {
                        Stream.of(nw, sw, wu, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.EAST)) {
                        Stream.of(ne, se, eu, ed).forEach(lines::remove);
                    }
                    lines.forEach(line -> line.accept(new Vector3f(x, y, z), new Vector4f(r, g, b, renderAlpha)));
                }
            }
            invalidHearths.forEach(HEARTH_LOCATIONS::remove);
            RenderSystem.disableBlend();
            ms.func_227865_b_();
            buffer.func_228462_a_((RenderType)RenderType.field_228614_Q_);
        }
    }

    public static void updatePaths(HearthBlockEntity hearth) {
        if (!hearth.isSpreading()) {
            return;
        }
        BlockPos pos = hearth.func_174877_v();
        Set paths = hearth.getPaths().stream().map(path -> path.pos).collect(Collectors.toSet());
        Map pathMap = HEARTH_LOCATIONS.computeIfAbsent(pos, k -> Maps.newHashMap());
        if (pathMap.size() != paths.size()) {
            HEARTH_LOCATIONS.put(pos, paths.stream().map(path -> {
                ArrayList<Direction> dirs = new ArrayList<Direction>();
                for (int i = 0; i < Direction.values().length; ++i) {
                    Direction dir = Direction.values()[i];
                    BlockPos dirPos = path.func_177972_a(dir);
                    if (!paths.contains(dirPos)) continue;
                    dirs.add(dir);
                }
                return new AbstractMap.SimpleEntry((BlockPos)path, dirs);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }
}

