/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterItemOverrides {
    public static final IItemPropertyGetter SOULSPRING_LAMP_PROPERTIES = (stack, level, entity) -> {
        if (SoulspringLampItem.isLit(stack)) {
            double fuel = SoulspringLampItem.getFuel(stack);
            return fuel > 43.0 ? 3.0f : (fuel > 22.0 ? 2.0f : 1.0f);
        }
        return 0.0f;
    };
    private static final Field ITEM_PROPERTIES = ObfuscationReflectionHelper.findField(ItemModelsProperties.class, (String)"field_239415_f_");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (!ConfigSettings.ANIMATED_SOULSPRING_LAMP_MODEL.get().booleanValue()) {
                ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.SOULSPRING_LAMP.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "soulspring_state"), (IItemPropertyGetter)SOULSPRING_LAMP_PROPERTIES);
            }
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.FILLED_WATERSKIN.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "water_temperature"), (stack, level, entity) -> stack.func_196082_o().func_74760_g("Temperature"));
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.THERMOMETER.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "temperature"), (stack, level, livingEntity) -> {
                if (livingEntity instanceof PlayerEntity) {
                    double worldTemp;
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
                    double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
                    if (!player.getPersistentData().func_74764_b("WorldTempTimestamp") || player.field_70173_aa % 2 == 0 && player.getPersistentData().func_74762_e("WorldTempTimestamp") != player.field_70173_aa) {
                        worldTemp = Temperature.convert(Overlays.WORLD_TEMP, Preference.getOrDefault(player, Preference.UNITS, Temperature.Units.F), Temperature.Units.MC, true);
                        player.getPersistentData().func_74780_a("WorldTemp", worldTemp);
                        player.getPersistentData().func_74768_a("WorldTempTimestamp", player.field_70173_aa);
                    } else {
                        worldTemp = player.getPersistentData().func_74769_h("WorldTemp");
                    }
                    double worldTempAdjusted = Overlays.getWorldSeverity(worldTemp, minTemp, maxTemp) * 1.01;
                    return (float)worldTempAdjusted;
                }
                return 0.0f;
            });
        });
    }

    public static void unregister(Item item) {
        try {
            Map properties = (Map)ITEM_PROPERTIES.get(null);
            properties.remove(item);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ITEM_PROPERTIES.setAccessible(true);
    }
}

