/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.momosoftworks.coldsweat.ColdSweat;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class PostProcessShaderManager
implements AutoCloseable {
    private static final PostProcessShaderManager INSTANCE = new PostProcessShaderManager(Minecraft.func_71410_x().func_147110_a(), Minecraft.func_71410_x().func_195551_G());
    private static final Map<String, ShaderGroup> ACTIVE_EFFECTS = new HashMap<String, ShaderGroup>();
    private final Framebuffer mainTarget;
    private final IResourceManager resourceManager;
    private boolean screenSizeUpdated = false;
    public static final ResourceLocation BLOBS = new ResourceLocation("minecraft", "shaders/post/blobs2.json");
    private static final Field POST_PASSES = ObfuscationReflectionHelper.findField(ShaderGroup.class, (String)"field_148031_d");
    private static final Field ORTHO_MATRIX = ObfuscationReflectionHelper.findField(Shader.class, (String)"field_148053_h");

    public PostProcessShaderManager(Framebuffer mainTarget, IResourceManager resourceManager) {
        this.mainTarget = mainTarget;
        this.resourceManager = resourceManager;
    }

    public static PostProcessShaderManager getInstance() {
        return INSTANCE;
    }

    public void loadEffect(String id, ResourceLocation shaderLocation) {
        try {
            ShaderGroup postChain = new ShaderGroup(Minecraft.func_71410_x().func_110434_K(), this.resourceManager, this.mainTarget, shaderLocation);
            if (ACTIVE_EFFECTS.put(id, postChain) != null) {
                this.closeEffect(id);
            }
        }
        catch (JsonSyntaxException | IOException e) {
            ColdSweat.LOGGER.error("Failed to load shader effect: " + id, e);
        }
    }

    public void closeEffect(String id) {
        ShaderGroup chain = ACTIVE_EFFECTS.remove(id);
        if (chain != null) {
            chain.close();
        }
    }

    public void process(float partialTicks) {
        for (ShaderGroup chain : ACTIVE_EFFECTS.values()) {
            if (PostProcessShaderManager.getPostPasses(chain).stream().anyMatch(pass -> PostProcessShaderManager.getOrthoMatrix(pass) == null)) {
                chain.func_148026_a(this.mainTarget.field_147622_a, this.mainTarget.field_147620_b);
            }
            chain.func_148018_a(partialTicks);
        }
    }

    public void resize(int width, int height) {
        for (ShaderGroup chain : ACTIVE_EFFECTS.values()) {
            chain.func_148026_a(width, height);
        }
    }

    public boolean hasEffect(String id) {
        return ACTIVE_EFFECTS.containsKey(id);
    }

    public ShaderGroup getEffect(String id) {
        return ACTIVE_EFFECTS.get(id);
    }

    public List<Shader> getPostPasses(String effectId) {
        ShaderGroup chain = ACTIVE_EFFECTS.get(effectId);
        if (chain == null) {
            return new ArrayList<Shader>();
        }
        try {
            return (List)POST_PASSES.get(chain);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to get post passes for effect: " + effectId, (Throwable)e);
            return new ArrayList<Shader>();
        }
    }

    public static List<Shader> getPostPasses(ShaderGroup chain) {
        try {
            return (List)POST_PASSES.get(chain);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to get post passes for effect: " + chain, (Throwable)e);
            return new ArrayList<Shader>();
        }
    }

    public static Matrix4f getOrthoMatrix(Shader pass) {
        try {
            return (Matrix4f)ORTHO_MATRIX.get(pass);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to get ortho matrix for pass: " + pass, (Throwable)e);
            return new Matrix4f();
        }
    }

    @Override
    public void close() {
        for (ShaderGroup chain : ACTIVE_EFFECTS.values()) {
            chain.close();
        }
        ACTIVE_EFFECTS.clear();
    }

    static {
        POST_PASSES.setAccessible(true);
        ORTHO_MATRIX.setAccessible(true);
    }
}

