/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SoulSpringLampRenderer
extends ItemStackTileEntityRenderer
implements Callable<ItemStackTileEntityRenderer> {
    public static final ResourceLocation TEXTURE_FRAME = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_frame.png");
    public static final ResourceLocation TEXTURE_0 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_0.png");
    public static final ResourceLocation TEXTURE_1 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_1.png");
    public static final ResourceLocation TEXTURE_2 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_2.png");
    public static final ResourceLocation TEXTURE_3 = new ResourceLocation("cold_sweat", "textures/item/soulspring_lamp/render/soulspring_lamp_3.png");
    private static final int FULL_BRIGHT = 0xF000F0;
    private static float TIME = 0.0f;
    private SoulspringLampModel model = new SoulspringLampModel();

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType displayContext, MatrixStack poseStack, IRenderTypeBuffer buffer, int light, int overlay) {
        if (stack.func_77973_b() == ModItems.SOULSPRING_LAMP) {
            Minecraft mc = Minecraft.func_71410_x();
            boolean isFirstPerson = mc.field_71474_y.func_243230_g().func_243192_a();
            double fuel = SoulspringLampItem.getFuel(stack);
            ResourceLocation texture = SoulSpringLampRenderer.getTexture(stack);
            if (fuel > 0.0) {
                ((SoulspringLampModel)this.model).heart.field_78797_d = -14.0f + (float)Math.sin(TIME / 8.0f) * 1.2f;
                ((SoulspringLampModel)this.model).heart.field_78795_f = CSMath.toRadians(TIME * 2.0f % 360.0f);
                ((SoulspringLampModel)this.model).heart.field_78796_g = CSMath.toRadians((TIME * 2.0f + 10.0f) % 360.0f);
                ((SoulspringLampModel)this.model).heart.field_78808_h = CSMath.toRadians(((double)TIME * 0.5 + 5.0) % 360.0);
            } else {
                ((SoulspringLampModel)this.model).heart.field_78797_d = -14.0f;
                ((SoulspringLampModel)this.model).heart.field_78796_g = 0.0f;
                ((SoulspringLampModel)this.model).heart.field_78795_f = 0.0f;
                ((SoulspringLampModel)this.model).heart.field_78808_h = 0.0f;
            }
            float emission = SoulspringLampItem.isLit(stack) ? (float)CSMath.blend(0.0, 1.0, fuel, 0.0, 64.0) : 0.0f;
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(0.5, 1.5, 0.5);
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            IVertexBuilder frameVertexes = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE_FRAME));
            this.model.base.func_228308_a_(poseStack, frameVertexes, light, overlay);
            poseStack.func_227860_a_();
            double heartYOffset = isFirstPerson ? 1.65 : 1.55;
            float heartScale = isFirstPerson ? 0.925f : 0.9f;
            poseStack.func_227861_a_(0.0, heartYOffset, 0.0);
            poseStack.func_227862_a_(heartScale, heartScale, heartScale);
            IVertexBuilder heartVtx = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture));
            this.model.heart.func_228309_a_(poseStack, heartVtx, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f - emission);
            this.model.heart.func_228309_a_(poseStack, heartVtx, 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, emission);
            poseStack.func_227865_b_();
            IVertexBuilder glassVtx = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture));
            this.model.base.func_228309_a_(poseStack, glassVtx, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f - emission);
            this.model.base.func_228309_a_(poseStack, glassVtx, 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, emission);
            poseStack.func_227865_b_();
        } else {
            super.func_239207_a_(stack, displayContext, poseStack, buffer, light, overlay);
        }
    }

    private static ResourceLocation getTexture(ItemStack lamp) {
        double fuel = SoulspringLampItem.getFuel(lamp);
        CompoundNBT tag = lamp.func_196082_o();
        int state = tag.func_74767_n("Lit") ? (fuel > 43.0 ? 3 : (fuel > 22.0 ? 2 : 1)) : 0;
        switch (state) {
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case 3: {
                return TEXTURE_3;
            }
        }
        return TEXTURE_0;
    }

    @Override
    public ItemStackTileEntityRenderer call() {
        return this;
    }

    @SubscribeEvent
    public static void tickTimer(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_147113_T() && event.phase == TickEvent.Phase.START) {
            TIME += mc.func_193989_ak();
        }
    }

    public static class SoulspringLampModel
    extends Model {
        private final ModelRenderer base;
        private final ModelRenderer heart;

        public SoulspringLampModel() {
            super(RenderType::func_228644_e_);
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this.base = new ModelRenderer((Model)this);
            this.base.func_78793_a(8.0f, 24.0f, -8.0f);
            this.base.func_78784_a(0, 11).func_228303_a_(-12.0f, -17.0f, 4.0f, 8.0f, 11.0f, 8.0f, 0.0f, false);
            this.base.func_78784_a(22, 21).func_228303_a_(-13.0f, -6.0f, 3.0f, 10.0f, 1.0f, 10.0f, 0.0f, false);
            this.base.func_78784_a(58, 21).func_228303_a_(-9.5f, -5.0f, 8.0f, 3.0f, 8.0f, 0.0f, 0.0f, false);
            this.base.func_78784_a(52, 18).func_228303_a_(-8.0f, -5.0f, 6.5f, 0.0f, 8.0f, 3.0f, 0.0f, false);
            this.base.func_78784_a(24, 0).func_228303_a_(-13.0f, -19.0f, 3.0f, 10.0f, 3.0f, 10.0f, 0.0f, false);
            this.base.func_78784_a(40, 13).func_228303_a_(-11.0f, -21.0f, 5.0f, 6.0f, 2.0f, 6.0f, 0.0f, false);
            this.base.func_78784_a(0, -7).func_228303_a_(-8.0f, -28.0f, 4.5f, 0.0f, 7.0f, 7.0f, 0.0f, false);
            this.heart = new ModelRenderer((Model)this);
            this.heart.func_78793_a(0.0f, 24.0f, 0.0f);
            this.heart.func_78784_a(14, 0).func_228303_a_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack pMatrixStack, IVertexBuilder pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        }
    }
}

