/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.client.renderer.model.entity.ChameleonModel;
import com.momosoftworks.coldsweat.common.entity.ChameleonEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class ChameleonColorLayer<T extends Entity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final RenderType CHAMELEON_SHED = RenderType.func_228644_e_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_SHED);
    private static final RenderType CHAMELEON_RED = RenderType.func_228644_e_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_RED);
    private static final RenderType CHAMELEON_BLUE = RenderType.func_228644_e_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_BLUE);

    public ChameleonColorLayer(IEntityRenderer<T, M> parentLayer) {
        super(parentLayer);
    }

    public void func_225628_a_(MatrixStack poseStack, IRenderTypeBuffer bufferSource, int light, T entity, float p_117353_, float p_117354_, float partialTick, float p_117356_, float p_117357_, float p_117358_) {
        if (entity instanceof ChameleonEntity) {
            float alpha;
            IVertexBuilder vertexConsumer;
            ChameleonEntity chameleon = (ChameleonEntity)((Object)entity);
            float midTemp = (float)CSMath.average(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (!CSMath.betweenInclusive(chameleon.getTemperature(), CSMath.average(ConfigSettings.MIN_TEMP.get(), Float.valueOf(midTemp)), CSMath.average(ConfigSettings.MAX_TEMP.get(), Float.valueOf(midTemp)))) {
                if (chameleon.getTemperature() > midTemp) {
                    vertexConsumer = bufferSource.getBuffer(CHAMELEON_RED);
                    float f = alpha = chameleon.field_70737_aN > 0 ? 0.0f : (float)CSMath.blend(0.0, 1.0, (double)chameleon.getTemperature(), CSMath.average(ConfigSettings.MAX_TEMP.get(), Float.valueOf(midTemp)), ConfigSettings.MAX_TEMP.get());
                    if (alpha > 0.0f) {
                        ((ChameleonModel)this.func_215332_c()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha * chameleon.opacity, true);
                    }
                } else {
                    vertexConsumer = bufferSource.getBuffer(CHAMELEON_BLUE);
                    float f = alpha = chameleon.field_70737_aN > 0 ? 0.0f : (float)CSMath.blend(1.0, 0.0, (double)chameleon.getTemperature(), ConfigSettings.MIN_TEMP.get(), CSMath.average(ConfigSettings.MIN_TEMP.get(), Float.valueOf(midTemp)));
                    if (alpha > 0.0f) {
                        ((ChameleonModel)this.func_215332_c()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha * chameleon.opacity, true);
                    }
                }
            }
            if (chameleon.isShedding()) {
                vertexConsumer = bufferSource.getBuffer(CHAMELEON_SHED);
                float f = alpha = chameleon.field_70737_aN > 0 ? 0.0f : CSMath.blend(0.0f, 0.7f, chameleon.getShedTime(), 0.0f, chameleon.getTimeToShed());
                if (alpha > 0.0f) {
                    ((ChameleonModel)this.func_215332_c()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha * chameleon.opacity, true);
                }
            }
            RenderSystem.disableBlend();
        }
    }
}

