/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.model.entity;

import com.google.common.collect.ImmutableList;
import com.momosoftworks.coldsweat.common.entity.GoatEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GoatModel<T extends GoatEntity>
extends AgeableModel<T> {
    private final ModelRenderer left_back_leg;
    private final ModelRenderer right_back_leg;
    private final ModelRenderer right_front_leg;
    private final ModelRenderer left_front_leg;
    private final ModelRenderer body;
    private final ModelRenderer head;
    private final ModelRenderer nose;
    private final ModelRenderer right_horn;
    private final ModelRenderer left_horn;

    public GoatModel() {
        super(true, 19.0f, 1.0f, 2.5f, 2.0f, 24.0f);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.left_back_leg = new ModelRenderer((Model)this);
        this.left_back_leg.func_78793_a(1.0f, 14.0f, 4.0f);
        this.left_back_leg.func_78784_a(36, 29).func_228303_a_(0.0f, 4.0f, 0.0f, 3.0f, 6.0f, 3.0f, 0.0f, false);
        this.right_back_leg = new ModelRenderer((Model)this);
        this.right_back_leg.func_78793_a(-3.0f, 14.0f, 4.0f);
        this.right_back_leg.func_78784_a(49, 29).func_228303_a_(0.0f, 4.0f, 0.0f, 3.0f, 6.0f, 3.0f, 0.0f, false);
        this.right_front_leg = new ModelRenderer((Model)this);
        this.right_front_leg.func_78793_a(-3.0f, 14.0f, -6.0f);
        this.right_front_leg.func_78784_a(49, 2).func_228303_a_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, 0.0f, false);
        this.left_front_leg = new ModelRenderer((Model)this);
        this.left_front_leg.func_78793_a(1.0f, 14.0f, -6.0f);
        this.left_front_leg.func_78784_a(35, 2).func_228303_a_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, 0.0f, false);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 24.0f, 0.0f);
        this.body.func_78784_a(1, 1).func_228303_a_(-4.0f, -17.0f, -7.0f, 9.0f, 11.0f, 16.0f, 0.0f, false);
        this.body.func_78784_a(0, 28).func_228303_a_(-5.0f, -18.0f, -8.0f, 11.0f, 14.0f, 11.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.5f, 7.0f, -8.0f);
        this.head.func_78784_a(2, 61).func_228303_a_(2.5f, -4.0f, -2.0f, 3.0f, 2.0f, 1.0f, 0.0f, true);
        this.head.func_78784_a(2, 61).func_228303_a_(-5.5f, -4.0f, -2.0f, 3.0f, 2.0f, 1.0f, 0.0f, false);
        this.head.func_78784_a(23, 52).func_228303_a_(0.0f, 4.0f, -6.0f, 0.0f, 7.0f, 5.0f, 0.0f, false);
        this.nose = new ModelRenderer((Model)this);
        this.nose.func_78793_a(0.5f, -1.0f, 0.0f);
        this.head.func_78792_a(this.nose);
        this.setRotationAngle(this.nose, 0.9599f, 0.0f, 0.0f);
        this.nose.func_78784_a(34, 46).func_228303_a_(-3.0f, -4.0f, -8.0f, 5.0f, 7.0f, 10.0f, 0.0f, false);
        this.right_horn = new ModelRenderer((Model)this);
        this.right_horn.func_78793_a(0.5f, -1.0f, 0.0f);
        this.head.func_78792_a(this.right_horn);
        this.right_horn.func_78784_a(12, 55).func_228303_a_(-2.99f, -8.0f, -2.0f, 2.0f, 7.0f, 2.0f, 0.0f, false);
        this.left_horn = new ModelRenderer((Model)this);
        this.left_horn.func_78793_a(0.5f, -1.0f, 0.0f);
        this.head.func_78792_a(this.left_horn);
        this.left_horn.func_78784_a(12, 55).func_228303_a_(-0.01f, -8.0f, -2.0f, 2.0f, 7.0f, 2.0f, 0.0f, false);
    }

    public void setupAnim(T goat, float limbSwing, float limbSwingAmount, float age, float netHeadYaw, float headPitch) {
        this.left_horn.field_78806_j = !goat.func_70631_g_();
        this.right_horn.field_78806_j = !goat.func_70631_g_();
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.right_back_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.left_back_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.right_front_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.left_front_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float rotation = ((GoatEntity)((Object)goat)).getHeadPitch();
        if (rotation != 0.0f) {
            this.head.field_78800_c = rotation;
        }
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.right_back_leg, (Object)this.left_back_leg, (Object)this.right_front_leg, (Object)this.left_front_leg);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.left_horn.field_78806_j = !entityIn.func_70631_g_();
        this.right_horn.field_78806_j = !entityIn.func_70631_g_();
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.right_back_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.left_back_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.right_front_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.left_front_leg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float rotation = ((GoatEntity)((Object)entityIn)).getHeadPitch();
        if (rotation != 0.0f) {
            this.head.field_78800_c = rotation;
        }
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

