/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.block.BoilerBlock;
import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.AbstractFurnaceContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class HearthBottomBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty COOLING = BooleanProperty.func_177716_a((String)"cooling");
    public static final BooleanProperty HEATING = BooleanProperty.func_177716_a((String)"heating");
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty FROSTED = BooleanProperty.func_177716_a((String)"frosted");
    public static final BooleanProperty SMART = BooleanProperty.func_177716_a((String)"smart");

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 10.0f).func_235861_h_().func_235828_a_((state, level, pos) -> false).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 13 : 0).func_226896_b_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT).func_200917_a(1);
    }

    public HearthBottomBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)COOLING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HEATING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FROSTED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SMART, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState pState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)BlockEntityInit.HEARTH_BLOCK_ENTITY_TYPE.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof HearthBlockEntity) {
            int hearthFuel;
            HearthBlockEntity hearth = (HearthBlockEntity)te;
            ItemStack stack = player.func_184586_b(hand);
            int itemFuel = hearth.getItemFuel(stack);
            int n = hearthFuel = itemFuel > 0 ? hearth.getHotFuel() : hearth.getColdFuel();
            if (itemFuel != 0 && (double)hearthFuel + (double)Math.abs(itemFuel) * 0.75 < (double)hearth.getMaxFuel()) {
                if (!player.func_184812_l_()) {
                    if (stack.hasContainerItem()) {
                        ItemStack container = stack.getContainerItem();
                        player.func_184611_a(hand, container);
                    } else {
                        stack.func_190918_g(1);
                    }
                }
                hearth.addFuel(itemFuel);
                world.func_184133_a(null, pos, itemFuel > 0 ? SoundEvents.field_187627_L : ModSounds.BUCKET_EMPTY_SLUSH, SoundCategory.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
            } else if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)hearth, (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World level, BlockPos pos, Random random) {
        HearthBlockEntity hearth = (HearthBlockEntity)level.func_175625_s(pos);
        if (hearth != null && hearth.isUsingColdFuel()) {
            IceboxBlock.createMistParticles(level, pos);
        }
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            BoilerBlock.createFlameParticles(level, pos, state, 0.6, 0.1);
        }
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack item) {
        level.func_180501_a(pos.func_177984_a(), WorldHelper.waterlog(ModBlocks.HEARTH_TOP.func_176223_P(), level, pos.func_177984_a()), 3);
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, level, pos, neighborBlock, fromPos, isMoving);
        if (level.func_180495_p(pos.func_177984_a()).func_177230_c() != ModBlocks.HEARTH_TOP) {
            level.func_175655_b(pos, false);
        } else {
            HearthBlockEntity hearth = (HearthBlockEntity)level.func_175625_s(pos);
            if (hearth != null) {
                hearth.checkInputSignal();
                hearth.checkForStateChange();
            }
        }
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity;
        if (state.func_177230_c() != newState.func_177230_c() && !isMoving && (tileentity = level.func_175625_s(pos)) instanceof HearthBlockEntity) {
            InventoryHelper.func_180175_a((World)level, (BlockPos)pos, (IInventory)((HearthBlockEntity)tileentity));
        }
        super.func_196243_a(state, level, pos, newState, isMoving);
    }

    public BlockState func_185499_a(BlockState state, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, COOLING, HEATING, LIT, FROSTED, SMART});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World level = context.func_195991_k();
        return level.func_180495_p(context.func_195995_a().func_177984_a()).func_196953_a(context) ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)SMART, (Comparable)ConfigSettings.SMART_HEARTH.get()) : null;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader level, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.func_176740_k() != Direction.Axis.Y && direction != ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
    }

    public boolean func_149740_M(BlockState pState) {
        return true;
    }

    public int func_180641_l(BlockState pState, World level, BlockPos pos) {
        return AbstractFurnaceContainer.func_178144_a((TileEntity)level.func_175625_s(pos));
    }
}

