/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class IceboxBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty FROSTED = HearthBottomBlock.FROSTED;
    public static final BooleanProperty SMOKESTACK = BooleanProperty.func_177716_a((String)"smokestack");
    public static final VoxelShape SHAPE = VoxelShapes.func_197868_b();
    private static final VoxelShape SHAPE_OPEN = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)1.0);

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(2.0f, 5.0f).func_235828_a_(IceboxBlock::conductsRedstone).func_226896_b_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT);
    }

    private static boolean conductsRedstone(BlockState state, IBlockReader level, BlockPos pos) {
        TileEntity be = level.func_175625_s(pos);
        if (be instanceof HearthBlockEntity) {
            return !((HearthBlockEntity)be).hasSmokestack();
        }
        return false;
    }

    public IceboxBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)FROSTED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SMOKESTACK, (Comparable)Boolean.valueOf(false)));
    }

    public BlockRenderType func_149645_b(BlockState pState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext selection) {
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof IceboxBlockEntity) {
            return ((IceboxBlockEntity)te).func_195480_a(0.0f) > 0.0f ? SHAPE_OPEN : SHAPE;
        }
        return SHAPE;
    }

    public boolean func_189539_a(BlockState state, World level, BlockPos pos, int id, int param) {
        super.func_189539_a(state, level, pos, id, param);
        TileEntity blockentity = level.func_175625_s(pos);
        return blockentity != null && blockentity.func_145842_c(id, param);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)level.func_175625_s(pos);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() == ModItems.SMOKESTACK && rayTraceResult.func_216354_b() == Direction.UP && level.func_180495_p(pos.func_177984_a()).func_196953_a(new BlockItemUseContext(player, hand, stack, rayTraceResult))) {
                return ActionResultType.FAIL;
            }
            int itemFuel = icebox.getItemFuel(stack);
            if (itemFuel != 0 && (double)icebox.getFuel() + (double)itemFuel * 0.75 < (double)icebox.getMaxFuel()) {
                if (!player.func_184812_l_()) {
                    if (stack.hasContainerItem()) {
                        ItemStack container = stack.getContainerItem();
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70441_a(container);
                    } else {
                        stack.func_190918_g(1);
                    }
                }
                icebox.addColdFuel(itemFuel, true);
                level.func_184133_a(null, pos, ModSounds.BUCKET_EMPTY_SLUSH, SoundCategory.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
            } else if (!level.field_72995_K && !ChestBlock.func_220108_a((IWorld)level, (BlockPos)pos)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)icebox, (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)BlockEntityInit.ICEBOX_BLOCK_ENTITY_TYPE.get()).func_200968_a();
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld level, BlockPos pos, BlockPos neighborPos) {
        boolean hasSmokeStack;
        IceboxBlockEntity icebox;
        boolean hadSmokestack;
        TileEntity te = level.func_175625_s(pos);
        if (neighborPos.equals((Object)pos.func_177984_a()) && te instanceof IceboxBlockEntity && (hadSmokestack = (icebox = (IceboxBlockEntity)te).hasSmokestack()) != (hasSmokeStack = icebox.checkForSmokestack())) {
            state = (BlockState)state.func_206870_a((Property)SMOKESTACK, (Comparable)Boolean.valueOf(hasSmokeStack));
            level.func_180501_a(pos, state, 3);
            level.func_230547_a_(pos, (Block)this);
        }
        return super.func_196271_a(state, direction, neighborState, level, pos, neighborPos);
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, level, pos, neighborBlock, fromPos, isMoving);
        HearthBlockEntity hearth = (HearthBlockEntity)level.func_175625_s(pos);
        if (hearth != null) {
            hearth.checkInputSignal();
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = world.func_175625_s(pos)) instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)te;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)icebox);
            world.func_195593_d(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public BlockState func_185499_a(BlockState state, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FROSTED, SMOKESTACK});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180655_c(BlockState state, World level, BlockPos pos, Random rand) {
        ParticleStatus status = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (status == ParticleStatus.MINIMAL) {
            return;
        }
        IceboxBlockEntity icebox = (IceboxBlockEntity)level.func_175625_s(pos);
        if (icebox != null && icebox.isUsingColdFuel()) {
            IceboxBlock.createMistParticles(level, pos);
        }
    }

    public static void createMistParticles(World level, BlockPos pos) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = pos.func_177956_o();
        double d2 = (double)pos.func_177952_p() + 0.5;
        boolean side = new Random().nextBoolean();
        double d5 = side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        double d6 = Math.random() * 0.3;
        double d7 = !side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        level.func_195594_a((IParticleData)ParticleTypesInit.GROUND_MIST.get(), d0 + d5, d1 + d6, d2 + d7, d5 / 40.0, 0.0, d7 / 40.0);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader level, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.func_176740_k() != Direction.Axis.Y && level.func_180495_p(pos.func_177984_a()).func_203425_a(ModBlocks.SMOKESTACK);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World level, BlockPos pos) {
        return Container.func_178144_a((TileEntity)level.func_175625_s(pos));
    }
}

