/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityCache<C, K extends ICapabilityProvider> {
    protected final Map<K, LazyOptional<C>> cache = new WeakHashMap<K, LazyOptional<C>>();
    protected final Predicate<K> invalidator;
    protected final Supplier<Capability<C>> capability;

    public CapabilityCache(Supplier<Capability<C>> capability, Predicate<K> invalidator) {
        this.capability = capability;
        this.invalidator = invalidator;
    }

    public CapabilityCache(Supplier<Capability<C>> capability) {
        this.capability = capability;
        this.invalidator = null;
    }

    public LazyOptional<C> get(K key) {
        return this.cache.computeIfAbsent((ICapabilityProvider)key, (Function<ICapabilityProvider, LazyOptional<C>>)((Function<ICapabilityProvider, LazyOptional>)e -> {
            this.cleanExpiredEntries();
            LazyOptional cap = e.getCapability(this.capability.get());
            cap.addListener(opt -> this.cache.remove(e));
            return cap;
        }));
    }

    public int size() {
        return this.cache.size();
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    protected void cleanExpiredEntries() {
        if (this.invalidator != null) {
            this.removeIf(this.invalidator);
        }
    }

    public void ifPresent(K key, Consumer<C> consumer) {
        LazyOptional<C> cap = this.cache.get(key);
        if (cap != null && cap.resolve().isPresent()) {
            consumer.accept(cap.resolve().get());
        }
    }

    public void ifLazyPresent(K key, Consumer<LazyOptional<C>> consumer) {
        LazyOptional<C> cap = this.cache.get(key);
        if (cap != null) {
            consumer.accept(cap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIf(Predicate<K> predicate) {
        Map<K, LazyOptional<C>> map = this.cache;
        synchronized (map) {
            ArrayList<ICapabilityProvider> removedKeys = new ArrayList<ICapabilityProvider>(this.cache.size());
            for (Map.Entry<K, LazyOptional<C>> entry : this.cache.entrySet()) {
                ICapabilityProvider key = (ICapabilityProvider)entry.getKey();
                LazyOptional<C> value = entry.getValue();
                if (!predicate.test(key) && value.isPresent()) continue;
                removedKeys.add(key);
            }
            for (int i = 0; i < removedKeys.size(); ++i) {
                this.cache.remove(removedKeys.get(i));
            }
        }
    }
}

