/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.init.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ContainerChangedEvent;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.AcclimationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntitiesTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntityClimateTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ShadeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ThermalSourceTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.temperature.AbstractTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.ModUpdater;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.tag.ModEntityTags;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TridentItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityTempManager {
    public static final Temperature.Trait[] VALID_TEMPERATURE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForTemperature).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_MODIFIER_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForModifiers).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_ATTRIBUTE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForAttributes).toArray(Temperature.Trait[]::new);
    public static final Set<EntityType<? extends LivingEntity>> TEMPERATURE_ENABLED_ENTITIES = new HashSet<EntityType>(Arrays.asList(EntityType.field_200729_aH));
    public static SidedCapabilityCache<ITemperatureCap, Entity> CAP_CACHE = new SidedCapabilityCache(() -> ModCapabilities.ENTITY_TEMPERATURE, ent -> ent.field_70128_L);
    public static Map<Entity, Map<ResourceLocation, Double>> TEMP_MODIFIER_IMMUNITIES = new WeakHashMap<Entity, Map<ResourceLocation, Double>>();
    private static final Field MENU_OWNER = ObfuscationReflectionHelper.findField(PlayerContainer.class, (String)"field_82862_h");

    public static LazyOptional<ITemperatureCap> getTemperatureCap(Entity entity) {
        return EntityTempManager.isTemperatureEnabled(entity) ? CAP_CACHE.get(entity) : LazyOptional.empty();
    }

    public static Map<Temperature.Trait, List<TempModifier>> gatherTempModifiers(LivingEntity entity) {
        DefaultTempModifiersEvent modifiersEvent = new DefaultTempModifiersEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)modifiersEvent);
        Map<Temperature.Trait, List<TempModifier>> modifiers = modifiersEvent.getModifiers();
        for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
            GatherDefaultTempModifiersEvent gatherEvent = new GatherDefaultTempModifiersEvent(entity, modifiers.get(trait), trait);
            MinecraftForge.EVENT_BUS.post((Event)gatherEvent);
            modifiers.put(trait, gatherEvent.getModifiers());
        }
        return modifiers;
    }

    private static void updateInventoryTempAttributes(ItemStack oldStack, ItemStack newStack, LivingEntity entity) {
        for (ItemTempData itemTempData : ConfigSettings.ITEM_TEMPERATURES.get().get((Object)oldStack.func_77973_b())) {
            entity.func_233645_dx_().func_233785_a_(itemTempData.attributeModifiers().getMap());
        }
        for (ItemTempData itemTempData : ConfigSettings.ITEM_TEMPERATURES.get().get((Object)newStack.func_77973_b())) {
            if (!itemTempData.test((Entity)entity, newStack)) continue;
            entity.func_233645_dx_().func_233793_b_(itemTempData.attributeModifiers().getMap());
        }
    }

    private static PlayerEntity getOwner(PlayerContainer menu) {
        try {
            return (PlayerEntity)MENU_OWNER.get(menu);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void updateInsulationAttributeModifiers(LivingEntity entity, ItemStack from, ItemStack to, Insulation.Slot slot) {
        for (InsulatorData insulatorData : ItemInsulationManager.getInsulatorsForStack(from, slot)) {
            entity.func_233645_dx_().func_233785_a_(insulatorData.attributes().getMap());
        }
        for (InsulatorData insulatorData : RequirementHolder.filterValid(ItemInsulationManager.getInsulatorsForStack(to, slot), (Entity)entity)) {
            entity.func_233645_dx_().func_233793_b_(insulatorData.attributes().getMap());
        }
    }

    public static Set<EntityType<? extends LivingEntity>> getEntitiesWithTemperature() {
        return ImmutableSet.copyOf(TEMPERATURE_ENABLED_ENTITIES);
    }

    public static boolean isTemperatureEnabled(EntityType<?> type) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(type);
    }

    public static boolean isTemperatureEnabled(Entity entity) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(entity.func_200600_R());
    }

    public static boolean hasClimateData(EntityType<?> entity) {
        return ConfigSettings.ENTITY_CLIMATES.get().containsKey(entity);
    }

    public static boolean hasClimateData(Entity entity) {
        return ConfigSettings.ENTITY_CLIMATES.get().containsKey((Object)entity.func_200600_R());
    }

    public static boolean isPeacefulMode(LivingEntity entity) {
        return entity.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && ConfigSettings.USE_PEACEFUL_MODE.get() != false;
    }

    public static boolean isImmuneToTemperature(LivingEntity player) {
        return player == null || !player.func_70089_S() || EntityTempManager.isPeacefulMode(player) || player.func_70644_a(ModEffects.GRACE);
    }

    public static double getColdResistance(LivingEntity entity) {
        return entity.func_70644_a(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get(entity, Temperature.Trait.COLD_RESISTANCE);
    }

    public static double getHeatResistance(LivingEntity player) {
        return player.func_70644_a(Effects.field_76426_n) && ConfigSettings.FIRE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get(player, Temperature.Trait.HEAT_RESISTANCE);
    }

    public static double getResistance(double temperature, LivingEntity player) {
        return temperature < 0.0 ? EntityTempManager.getColdResistance(player) : EntityTempManager.getHeatResistance(player);
    }

    public static Map<ItemStack, InsulatorData> getInsulatorsOnEntity(LivingEntity entity) {
        HashMap<ItemStack, InsulatorData> insulators = new HashMap<ItemStack, InsulatorData>();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b()) continue;
            ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.func_77973_b()).forEach(insul -> insulators.put(stack, (InsulatorData)insul));
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> ConfigSettings.INSULATION_ITEMS.get().get((Object)item.func_77973_b()).forEach(insul -> insulators.put((ItemStack)item, (InsulatorData)insul))));
        }
        for (ItemStack curio : CompatManager.Curios.getCurios(entity)) {
            ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.func_77973_b()).forEach(insul -> insulators.put(curio, (InsulatorData)insul));
        }
        return insulators;
    }

    public static Map<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>> getInventoryTemperaturesOnEntity(LivingEntity entity) {
        HashMap<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>> tempItems = new HashMap<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>>();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b()) continue;
                int slotIndex = i;
                ConfigSettings.ITEM_TEMPERATURES.get().get((Object)stack.func_77973_b()).forEach(temp -> tempItems.put(stack, Pair.of((Object)temp, (Object)Either.left((Object)slotIndex))));
            }
        }
        for (PlayerEntity slot : EquipmentSlotType.values()) {
            ItemStack stack = entity.func_184582_a((EquipmentSlotType)slot);
            if (stack.func_190926_b()) continue;
            ItemTempData.SlotType slotType = ItemTempData.SlotType.fromEquipment((EquipmentSlotType)slot);
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)stack.func_77973_b()).forEach(temp -> tempItems.put(stack, Pair.of((Object)temp, (Object)Either.right((Object)slotType))));
        }
        for (ItemStack curio : CompatManager.Curios.getCurios(entity)) {
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)curio.func_77973_b()).forEach(temp -> tempItems.put(curio, Pair.of((Object)temp, (Object)Either.right((Object)ItemTempData.SlotType.CURIO))));
        }
        ItemStack offhand = entity.func_184592_cb();
        if (!offhand.func_190926_b()) {
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)offhand.func_77973_b()).forEach(temp -> tempItems.put(offhand, Pair.of((Object)temp, (Object)Either.right((Object)ItemTempData.SlotType.HAND))));
        }
        return tempItems;
    }

    @Nullable
    public static ModifiableAttributeInstance getAttribute(Temperature.Trait trait, LivingEntity entity) {
        switch (trait) {
            case WORLD: {
                return entity.func_110148_a(ModAttributes.WORLD_TEMPERATURE);
            }
            case BASE: {
                return entity.func_110148_a(ModAttributes.BASE_BODY_TEMPERATURE);
            }
            case RATE: {
                return entity.func_110148_a(ModAttributes.TEMP_RATE);
            }
            case FREEZING_POINT: {
                return entity.func_110148_a(ModAttributes.FREEZING_POINT);
            }
            case BURNING_POINT: {
                return entity.func_110148_a(ModAttributes.BURNING_POINT);
            }
            case HEAT_RESISTANCE: {
                return entity.func_110148_a(ModAttributes.HEAT_RESISTANCE);
            }
            case COLD_RESISTANCE: {
                return entity.func_110148_a(ModAttributes.COLD_RESISTANCE);
            }
            case HEAT_DAMPENING: {
                return entity.func_110148_a(ModAttributes.HEAT_DAMPENING);
            }
            case COLD_DAMPENING: {
                return entity.func_110148_a(ModAttributes.COLD_DAMPENING);
            }
        }
        throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
    }

    public static Collection<AttributeModifier> getAllAttributeModifiers(LivingEntity entity, ModifiableAttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation == null ? attribute.func_225505_c_() : attribute.func_225504_a_(operation));
        modifiers.addAll(EntityTempManager.getAllEquipmentAttributeModifiers(entity, attribute, operation));
        return modifiers;
    }

    public static Collection<AttributeModifier> getAllEquipmentAttributeModifiers(LivingEntity entity, ModifiableAttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b()) continue;
            modifiers.addAll(ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute.func_111123_a(), slot, operation, (Entity)entity));
        }
        return modifiers;
    }

    public static AttributeModifier makeAttributeModifier(Temperature.Trait trait, double value, AttributeModifier.Operation operation) {
        if (!trait.isForAttributes()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
        }
        return new AttributeModifier(String.format("%s temperature modifier", trait.func_176610_l()), value, operation);
    }

    public static boolean isTemperatureAttribute(Attribute attribute) {
        return ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute).func_110624_b().equals("cold_sweat");
    }

    public static List<ModifiableAttributeInstance> getAllTemperatureAttributes(LivingEntity entity) {
        return Arrays.stream(VALID_ATTRIBUTE_TRAITS).map(trait -> EntityTempManager.getAttribute(trait, entity)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<TempModifier> getAllModifiers(LivingEntity entity) {
        ArrayList<TempModifier> allModifiers = new ArrayList<TempModifier>();
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                allModifiers.addAll(cap.getModifiers(trait));
            }
        });
        return allModifiers;
    }

    static {
        MENU_OWNER.setAccessible(true);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof LivingEntity && TEMPERATURE_ENABLED_ENTITIES.contains(((Entity)event.getObject()).func_200600_R())) {
                LivingEntity entity = (LivingEntity)event.getObject();
                final AbstractTempCap tempCap = entity instanceof PlayerEntity ? new PlayerTempCap() : new EntityTempCap();
                final LazyOptional capOptional = LazyOptional.of(() -> tempCap);
                ICapabilitySerializable<CompoundNBT> provider = new ICapabilitySerializable<CompoundNBT>(){

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                        if (cap == ModCapabilities.ENTITY_TEMPERATURE) {
                            return capOptional.cast();
                        }
                        return LazyOptional.empty();
                    }

                    public CompoundNBT serializeNBT() {
                        return tempCap.serializeNBT();
                    }

                    public void deserializeNBT(CompoundNBT nbt) {
                        tempCap.deserializeNBT(nbt);
                    }
                };
                event.addCapability(new ResourceLocation("cold_sweat", "temperature"), (ICapabilityProvider)provider);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void handleModUpdates(EntityJoinWorldEvent event) {
            Entity entity = event.getEntity();
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                ModUpdater.updateEntity((LivingEntity)entity);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void defineDefaultModifiers(DefaultTempModifiersEvent event) {
            LivingEntity entity = event.getEntity();
            boolean isPlayer = entity instanceof PlayerEntity;
            boolean isTempSensitive = entity.func_200600_R().func_220341_a(ModEntityTags.TEMPERATURE_SENSITIVE);
            if (EntityTempManager.hasClimateData((Entity)entity)) {
                boolean wasAdvanced;
                boolean isAdvanced = ConfigSettings.ADVANCED_ENTITY_TEMPERATURE.get();
                if (isAdvanced != (wasAdvanced = entity.getPersistentData().func_74767_n("AdvancedTemperature"))) {
                    Temperature.getModifiers(entity).clear();
                    entity.getPersistentData().func_74757_a("AdvancedTemperature", isAdvanced);
                }
                if (!isAdvanced) {
                    event.addModifier(Arrays.asList(Temperature.Trait.WORLD, Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT), (TempModifier)new EntityClimateTempModifier().tickRate(200), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
                    return;
                }
            }
            double tickMultiplier = isPlayer ? 1.0 : (isTempSensitive ? 4.0 : 40.0);
            int slowTickRate = (int)Math.min(60.0 * tickMultiplier, 400.0);
            int mediumTickRate = (int)(10.0 * tickMultiplier * 2.0);
            int mediumTickRate2 = (int)(10.0 * tickMultiplier);
            int fastTickRate = (int)(5.0 * tickMultiplier);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new BiomeTempModifier(isPlayer ? 49 : (isTempSensitive ? 16 : 9)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new ElevationTempModifier(isPlayer ? 49 : (isTempSensitive ? 16 : 1)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new ShadeTempModifier().tickRate(10), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod -> mod instanceof ElevationTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new BlockTempModifier(isPlayer ? -1 : 4).tickRate(fastTickRate), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new EntitiesTempModifier().tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifierById(Temperature.Trait.WORLD, new ResourceLocation("sereneseasons:season"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BiomeTempModifier));
            event.addModifierById(Temperature.Trait.WORLD, new ResourceLocation("weather2:storm"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BiomeTempModifier));
            event.addModifierById(Temperature.Trait.WORLD, new ResourceLocation("valkyrienskies:ship_blocks"), mod -> mod.tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BlockTempModifier));
            if (isPlayer && !(entity instanceof DummyPlayer)) {
                event.addModifier(Arrays.asList(Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT), (TempModifier)new AcclimationTempModifier().tickRate(20), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
                event.addModifier(Arrays.asList(VALID_MODIFIER_TRAITS), (TempModifier)new InventoryItemsTempModifier().tickRate(5), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            }
        }

        @SubscribeEvent
        public static void initModifiersOnEntity(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof LivingEntity && !event.getWorld().func_201670_d() && EntityTempManager.isTemperatureEnabled(event.getEntity())) {
                LivingEntity living = (LivingEntity)event.getEntity();
                EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                    Map<Temperature.Trait, List<TempModifier>> modifiers = EntityTempManager.gatherTempModifiers(living);
                    cap.clearModifiers();
                    cap.setModifiers(modifiers);
                    TaskScheduler.scheduleServer(() -> {
                        cap.tick(living);
                        Temperature.updateTemperature(living, cap, true);
                        Temperature.updateModifiers(living, cap);
                    }, 1);
                });
            }
        }

        @SubscribeEvent
        public static synchronized void cleanRemovedEntities(EntityLeaveWorldEvent event) {
            if (EntityTempManager.isTemperatureEnabled(event.getEntity())) {
                TEMP_MODIFIER_IMMUNITIES.keySet().removeIf(ent -> ent.field_70128_L);
            }
        }

        @SubscribeEvent
        public static void tickTemperature(LivingEvent.LivingUpdateEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (!EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R())) {
                return;
            }
            EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
                if (!entity.field_70170_p.field_72995_K) {
                    if (entity instanceof PlayerEntity || entity.field_70173_aa % 5 == 0) {
                        cap.tick(entity);
                    }
                } else {
                    cap.tickDummy(entity);
                }
                AtomicBoolean sync = new AtomicBoolean(false);
                for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                    List<TempModifier> modifiers = cap.getModifiers(trait);
                    for (int i = 0; i < modifiers.size(); ++i) {
                        boolean expired;
                        TempModifier modifier = modifiers.get(i);
                        if (modifier.getTicksExisted() % modifier.getTickRate() == 0) {
                            modifier.tick(entity);
                        }
                        if (modifier.isDirty()) {
                            sync.set(true);
                            modifier.markClean();
                        }
                        int expireTime = modifier.getExpireTime();
                        boolean bl = expired = modifier.setTicksExisted(modifier.getTicksExisted() + 1) > expireTime && expireTime != -1;
                        if (!expired) continue;
                        cap.removeModifier(modifier, trait);
                        modifier.onRemoved(entity, trait);
                        Temperature.updateSiblingsRemove(modifiers, entity, trait, modifier);
                        --i;
                    }
                }
                if (sync.get()) {
                    Temperature.updateModifiers(entity, cap);
                }
                if (!entity.field_70170_p.func_201670_d() && EntityTempManager.hasClimateData((Entity)entity) && entity.field_70173_aa % 5 == 0 && entity.func_70681_au().nextDouble() < 0.1) {
                    double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
                    double entityX = entity.func_226277_ct_();
                    double entityY = entity.func_226278_cu_() + (double)entity.func_213302_cg();
                    double entityZ = entity.func_226281_cx_();
                    if (worldTemp < cap.getTrait(Temperature.Trait.FREEZING_POINT)) {
                        WorldHelper.spawnParticleBatch(entity.field_70170_p, (IParticleData)ParticleTypesInit.MOB_COLD.get(), entityX, entityY, entityZ, 0.5, 0.5, 0.5, entity.func_70681_au().nextInt(2) + 2, 0.0);
                    } else if (worldTemp > cap.getTrait(Temperature.Trait.BURNING_POINT)) {
                        WorldHelper.spawnParticleBatch(entity.field_70170_p, (IParticleData)ParticleTypesInit.MOB_HOT.get(), entityX, entityY, entityZ, 0.5, 0.5, 0.5, entity.func_70681_au().nextInt(2) + 2, 0.0);
                    }
                }
            });
        }

        @SubscribeEvent
        public static void carryOverPersistentAttributes(PlayerEvent.Clone event) {
            PlayerEntity oldPlayer = event.getOriginal();
            PlayerEntity newPlayer = event.getPlayer();
            if (!newPlayer.field_70170_p.field_72995_K) {
                ((Collection)EntityTempManager.getTemperatureCap((Entity)oldPlayer).map(ITemperatureCap::getPersistentAttributes).orElse(new HashSet())).forEach(attr -> {
                    ModifiableAttributeInstance newAttr = newPlayer.func_110148_a(attr);
                    ModifiableAttributeInstance oldAttr = oldPlayer.func_110148_a(attr);
                    if (newAttr != null && oldAttr != null) {
                        newAttr.func_111128_a(oldAttr.func_111125_b());
                        EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> cap.markPersistentAttribute((Attribute)attr));
                    }
                });
            }
        }

        @SubscribeEvent
        public static void handlePlayerReset(PlayerEvent.Clone event) {
            PlayerEntity oldPlayer = event.getOriginal();
            PlayerEntity newPlayer = event.getPlayer();
            EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> {
                if (!event.isWasDeath()) {
                    EntityTempManager.getTemperatureCap((Entity)oldPlayer).ifPresent(cap::copy);
                }
            });
            CAP_CACHE.remove((Entity)oldPlayer);
        }

        @SubscribeEvent
        public static void addInventoryListeners(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof PlayerEntity) {
                final PlayerEntity player = (PlayerEntity)event.getEntity();
                player.field_71070_bA.func_75132_a(new IContainerListener(){

                    public void func_71111_a(Container menu, int slotIndex, ItemStack stack) {
                        Slot slot = menu.func_75139_a(slotIndex);
                        if (!(slot instanceof CraftingResultSlot) && slot.field_75224_c == player.field_71071_by && ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.func_77973_b())) {
                            player.func_193102_a(new ResourceLocation[]{new ResourceLocation("cold_sweat", "sewing_table")});
                        }
                    }

                    public void func_71112_a(Container container, int slot, int value) {
                    }

                    public void func_71110_a(Container container, NonNullList<ItemStack> stacks) {
                    }
                });
            }
        }

        @SubscribeEvent
        public static void cancelDisabledModifiers(TempModifierEvent.Calculate.Pre event) {
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            if (modifierKey != null && ConfigSettings.DISABLED_MODIFIERS.get().contains(modifierKey)) {
                modifier.expires(0);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void calculateModifierImmunity(LivingEvent.LivingUpdateEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (!entity.field_70170_p.func_201670_d() && entity.field_70173_aa % 20 == 0 && EntityTempManager.isTemperatureEnabled((Entity)entity)) {
                HashMap<ResourceLocation, Double> immunities = new HashMap<ResourceLocation, Double>();
                for (Map.Entry<ItemStack, InsulatorData> entry : EntityTempManager.getInsulatorsOnEntity(entity).entrySet()) {
                    ItemStack stack;
                    InsulatorData insulator = entry.getValue();
                    if (!insulator.test((Entity)entity, stack = entry.getKey())) continue;
                    immunities.putAll(insulator.immuneTempModifiers());
                }
                if (entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    for (Map.Entry<ItemStack, Pair<ItemTempData, Either<Integer, ItemTempData.SlotType>>> entry : EntityTempManager.getInventoryTemperaturesOnEntity((LivingEntity)player).entrySet()) {
                        ItemTempData itemTemp = (ItemTempData)entry.getValue().getFirst();
                        ItemStack stack = entry.getKey();
                        if (!((Boolean)((Either)entry.getValue().getSecond()).map(slot -> itemTemp.test((Entity)player, stack, (int)slot, null), slot -> itemTemp.test((Entity)entity, stack, (ItemTempData.SlotType)slot))).booleanValue()) continue;
                        immunities.putAll(itemTemp.immuneTempModifiers());
                    }
                    if (player.func_184187_bx() != null) {
                        for (MountData mountData : ConfigSettings.INSULATED_MOUNTS.get().get((Object)player.func_184187_bx().func_200600_R())) {
                            immunities.putAll(mountData.modifierImmunities());
                        }
                    }
                }
                TEMP_MODIFIER_IMMUNITIES.put((Entity)entity, immunities);
            }
        }

        @SubscribeEvent
        public static void checkModifierImmunity(TempModifierEvent.Calculate.Post event) {
            if (event.getEntity() instanceof DummyPlayer) {
                return;
            }
            if (!event.getTrait().isForAttributes()) {
                return;
            }
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            LivingEntity entity = event.getEntity();
            double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
            if (immunity > 0.0) {
                Function<Double, Double> oldFunction = event.getFunction();
                event.setFunction(temp -> {
                    double lastInput = modifier instanceof BiomeTempModifier ? Temperature.getNeutralWorldTemp(entity) : temp;
                    return CSMath.blend((Double)oldFunction.apply((Double)temp), lastInput, immunity, 0.0, 1.0);
                });
            }
        }

        @SubscribeEvent
        public static void preventFullyImmuneModifiers(TempModifierEvent.Add event) {
            if (event.getEntity() instanceof DummyPlayer) {
                return;
            }
            if (!event.getTrait().isForAttributes()) {
                return;
            }
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            LivingEntity entity = event.getEntity();
            double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
            if (immunity == 1.0) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void handleWaterFreezingFire(TickEvent.PlayerTickEvent event) {
            PlayerEntity player = event.player;
            if (!player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START && player.field_70173_aa % 5 == 0 && !player.func_175149_v() && (WorldHelper.isInWater((Entity)player) || player.field_70173_aa % 40 == 0 && WorldHelper.isRainingAt(player.field_70170_p, player.func_233580_cy_()))) {
                Temperature.addModifier((LivingEntity)player, new WaterTempModifier().tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
            }
        }

        @SubscribeEvent
        public static void onTridentUse(LivingEntityUseItemEvent.Stop event) {
            LivingEntity entity = event.getEntityLiving();
            ItemStack stack = event.getItem();
            if (!entity.field_70170_p.func_201670_d()) {
                TaskScheduler.scheduleServer(() -> {
                    if (stack.func_77973_b() instanceof TridentItem && EnchantmentHelper.func_203190_g((ItemStack)stack) > 0 && !entity.func_203005_aq()) {
                        Temperature.removeModifiers(entity, Temperature.Trait.WORLD, WaterTempModifier.class);
                    }
                }, 5);
            }
        }

        @SubscribeEvent
        public static void tickInventoryAttributeChanges(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START && event.player.field_70173_aa % 20 == 0) {
                for (ItemStack item : event.player.field_71071_by.field_70462_a) {
                    EntityTempManager.updateInventoryTempAttributes(item, item, (LivingEntity)event.player);
                }
            }
        }

        @SubscribeEvent
        public static void updateInventoryAttributesOnSlotChange(ContainerChangedEvent event) {
            if (event.getContainer() instanceof PlayerContainer) {
                PlayerContainer inventory = (PlayerContainer)event.getContainer();
                EntityTempManager.updateInventoryTempAttributes(event.getOldStack(), event.getNewStack(), (LivingEntity)EntityTempManager.getOwner(inventory));
            }
        }

        @SubscribeEvent
        public static void tickInsulationAttributeChanges(LivingEvent.LivingUpdateEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (entity.field_70173_aa % 20 == 0) {
                for (ItemStack armor : entity.func_184193_aE()) {
                    if (armor.func_190926_b()) continue;
                    EntityTempManager.updateInsulationAttributeModifiers(entity, armor, armor, Insulation.Slot.ARMOR);
                }
            }
        }

        @SubscribeEvent
        public static void updateInsulationAttributesOnEquipmentChange(LivingEquipmentChangeEvent event) {
            EntityTempManager.updateInsulationAttributeModifiers(event.getEntityLiving(), event.getFrom(), event.getTo(), Insulation.Slot.ARMOR);
            for (ItemStack armor : event.getEntity().func_184193_aE()) {
                if (armor.func_190926_b()) continue;
                EntityTempManager.updateInsulationAttributeModifiers(event.getEntityLiving(), armor, armor, Insulation.Slot.ARMOR);
            }
        }

        @SubscribeEvent
        public static void onInsulationAdded(PotionEvent.PotionAddedEvent event) {
            LivingEntity entity = event.getEntityLiving();
            EffectInstance effect = event.getPotionEffect();
            if (!entity.field_70170_p.field_72995_K && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.func_188419_a() == ModEffects.FRIGIDNESS || effect.func_188419_a() == ModEffects.WARMTH)) {
                boolean isWarmth = effect.func_188419_a() == ModEffects.WARMTH;
                int strength = effect.func_76458_c() + 1;
                ThermalSourceTempModifier newMod = (ThermalSourceTempModifier)(isWarmth ? new WarmthTempModifier(strength) : new FrigidnessTempModifier(strength)).expires(effect.func_76459_b());
                ThermalSourceTempModifier oldMod = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class).orElse(null);
                if (oldMod == null || oldMod.getStrength() <= strength) {
                    Temperature.removeModifiers(entity, Temperature.Trait.WORLD, newMod.getClass());
                    Temperature.addModifier(entity, newMod, Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                }
            }
        }

        @SubscribeEvent
        public static void onInsulationRemoved(PotionEvent.PotionRemoveEvent event) {
            Optional<ThermalSourceTempModifier> modifier;
            LivingEntity entity = event.getEntityLiving();
            EffectInstance effect = event.getPotionEffect();
            if (effect != null && !entity.field_70170_p.field_72995_K && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.func_188419_a() == ModEffects.FRIGIDNESS || effect.func_188419_a() == ModEffects.WARMTH) && (modifier = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class)).isPresent()) {
                boolean isWarmth = effect.func_188419_a() == ModEffects.WARMTH;
                CompoundNBT nbt = modifier.get().getNBT();
                if (isWarmth) {
                    nbt.func_74768_a("Warming", 0);
                } else {
                    nbt.func_74768_a("Cooling", 0);
                }
                if (isWarmth ? !entity.func_70644_a(ModEffects.FRIGIDNESS) : !entity.func_70644_a(ModEffects.WARMTH)) {
                    Temperature.removeModifiers(entity, Temperature.Trait.WORLD, mod -> mod instanceof ThermalSourceTempModifier);
                }
            }
        }

        @SubscribeEvent
        public static void onSleep(SleepFinishedTimeEvent event) {
            if (!event.getWorld().func_201670_d()) {
                event.getWorld().func_217369_A().forEach(player -> {
                    if (player.func_70608_bn()) {
                        double temp = Temperature.get((LivingEntity)player, Temperature.Trait.CORE);
                        Temperature.set((LivingEntity)player, Temperature.Trait.CORE, temp / 4.0);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void playerRiding(TickEvent.PlayerTickEvent event) {
            PlayerEntity player;
            if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.func_201670_d() && event.player.field_70173_aa % 5 == 0 && (player = event.player).func_184187_bx() != null) {
                Entity mount = player.func_184187_bx();
                if (mount instanceof MinecartEntity && ((MinecartEntity)mount).func_174897_t().func_177230_c() == ModBlocks.MINECART_INSULATION) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(1.0, 1.0).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                } else {
                    MountData entityInsul = ConfigSettings.INSULATED_MOUNTS.get().get((Object)mount.func_200600_R()).stream().filter(mnt -> mnt.test(mount)).findFirst().orElse(null);
                    if (entityInsul != null) {
                        Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(entityInsul.coldInsulation(), entityInsul.heatInsulation()).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onEatFood(LivingEntityUseItemEvent.Finish event) {
            ItemStack item = event.getItem();
            if (event.getEntity() instanceof PlayerEntity && (item.func_77975_n() == UseAction.DRINK || item.func_77975_n() == UseAction.EAT) && !event.getEntity().field_70170_p.field_72995_K) {
                PlayerEntity player = (PlayerEntity)event.getEntity();
                for (FoodData foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)item.func_77973_b())) {
                    if (foodData == null || !foodData.test(item)) continue;
                    double temperature = foodData.temperature();
                    int duration = foodData.duration();
                    Temperature.Trait trait = foodData.duration() > 0 ? Temperature.Trait.BASE : Temperature.Trait.CORE;
                    FoodTempModifier foodModifier = item.func_77973_b() == ModItems.SOUL_SPROUT ? new SoulSproutTempModifier(temperature) : new FoodTempModifier(temperature);
                    foodModifier.getNBT().func_74778_a("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.func_77973_b()).toString());
                    foodModifier.getNBT().func_74768_a("duration", duration);
                    ((TempModifier)foodModifier.expires(duration)).tickRate(duration);
                    if (foodData.stackLimit() > 1 && Temperature.addModifier((LivingEntity)player, foodModifier, trait, Placement.Duplicates.EXACT, foodData.stackLimit(), Placement.AFTER_LAST)) continue;
                    Temperature.addOrReplaceModifier((LivingEntity)player, foodModifier, trait, Placement.Duplicates.EXACT);
                }
            }
        }
    }
}

