/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.util.TypedField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.IArmorVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ItemInsulationManager {
    public static SidedCapabilityCache<IInsulatableCap, ItemStack> CAP_CACHE = new SidedCapabilityCache(() -> ModCapabilities.ITEM_INSULATION);

    public static LazyOptional<IInsulatableCap> getInsulationCap(ItemStack stack) {
        return ItemInsulationManager.isInsulatable(stack) ? CAP_CACHE.get(stack) : LazyOptional.empty();
    }

    public static int getInsulationSlots(ItemStack stack) {
        if (ItemInsulationManager.isInsulatable(stack)) {
            Item item = stack.func_77973_b();
            Optional slotOverride = ConfigSettings.INSULATION_SLOT_OVERRIDES.get().get((Object)item).stream().findFirst();
            if (slotOverride.isPresent() && ((ItemInsulationSlotsData)slotOverride.get()).test(stack)) {
                return ((ItemInsulationSlotsData)slotOverride.get()).slots();
            }
            return ConfigSettings.INSULATION_SLOTS.get().getSlots(MobEntity.func_184640_d((ItemStack)stack), stack);
        }
        return 0;
    }

    public static boolean isInsulatable(ItemStack stack) {
        return stack.func_77973_b() instanceof IArmorVanishable && !ConfigSettings.INSULATION_BLACKLIST.get().contains(stack.func_77973_b()) && ItemInsulationManager.getInsulatorInsulation(stack).isEmpty();
    }

    public static int getSlotsFilled(Collection<InsulatorData> insulators) {
        int slots = 0;
        for (InsulatorData data : insulators) {
            if (data.fillSlots()) {
                slots += Insulation.splitList(data.insulation()).size();
                continue;
            }
            ++slots;
        }
        return slots;
    }

    public static Multimap<Item, InsulatorData> getInsulatorsForSlotType(Insulation.Slot slot) {
        switch (slot) {
            case ITEM: {
                return ConfigSettings.INSULATION_ITEMS.get();
            }
            case ARMOR: {
                return ConfigSettings.INSULATING_ARMORS.get();
            }
            case CURIO: {
                return ConfigSettings.INSULATING_CURIOS.get();
            }
        }
        return HashMultimap.create();
    }

    public static List<Insulation> getInsulatorInsulation(ItemStack stack) {
        if (!ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.func_77973_b())) {
            return ImmutableList.of();
        }
        return ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.func_77973_b()).stream().map(InsulatorData::insulation).flatMap(Collection::stream).filter(ins -> !ins.isEmpty()).collect(Collectors.toList());
    }

    public static List<InsulatorData> getInsulatorsForStack(ItemStack stack, Insulation.Slot slot) {
        if (stack.func_190926_b()) {
            return new ArrayList<InsulatorData>();
        }
        ArrayList<InsulatorData> insulators = new ArrayList<InsulatorData>();
        if (slot == Insulation.Slot.ARMOR && ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> insulators.addAll(ItemInsulationManager.getAppliedArmorInsulators(stack)));
        }
        insulators.addAll(ItemInsulationManager.getInsulatorsForSlotType(slot).get((Object)stack.func_77973_b()));
        return insulators;
    }

    public static List<InsulatorData> getAppliedArmorInsulators(ItemStack armor) {
        return ((List)ItemInsulationManager.getInsulationCap(armor).map(IInsulatableCap::getInsulation).orElse(new ArrayList())).stream().map(Pair::getSecond).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<AttributeModifier> getArmorInsulationAttributes(ItemStack stack, Attribute attribute, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (InsulatorData insulator : ItemInsulationManager.getInsulatorsForStack(stack, Insulation.Slot.ARMOR)) {
            if (!insulator.test(owner, stack)) continue;
            modifiers.addAll(insulator.attributes().get(attribute).stream().filter(mod -> operation == null || mod.func_220375_c() == operation).collect(Collectors.toList()));
        }
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Attribute attribute, EquipmentSlotType slot, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation != null ? (Collection)stack.func_111283_C(slot).get((Object)attribute).stream().filter(mod -> mod.func_220375_c() == operation).collect(Collectors.toList()) : stack.func_111283_C(slot).get((Object)attribute));
        modifiers.addAll(ItemInsulationManager.getArmorInsulationAttributes(stack, attribute, operation, owner));
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Attribute attribute, EquipmentSlotType slot) {
        return ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute, slot, null, null);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        static IContainerListener INSULATION_LISTENER = new IContainerListener(){

            public void func_71111_a(Container sendingContainer, int slot, ItemStack stack) {
                ItemStack containerStack = sendingContainer.func_75139_a(slot).func_75211_c();
                ItemInsulationManager.getInsulationCap(containerStack).ifPresent(cap -> {
                    containerStack.func_196082_o().func_82580_o("Insulation");
                    containerStack.func_196082_o().func_197643_a(cap.serializeNBT());
                });
            }

            public void func_71110_a(Container pContainerToSend, NonNullList<ItemStack> pItemsList) {
            }

            public void func_71112_a(Container pContainer, int pVarToUpdate, int pNewValue) {
            }
        };
        static final TypedField<List<IContainerListener>> SLOT_LISTENERS = TypedField.of(ObfuscationReflectionHelper.findField(Container.class, (String)"field_75149_d"));

        @SubscribeEvent
        public static void attachCapabilityToItemHandler(AttachCapabilitiesEvent<ItemStack> event) {
            ItemStack stack = (ItemStack)event.getObject();
            if (ItemInsulationManager.isInsulatable(stack)) {
                final ItemInsulationCap itemInsulationCap = new ItemInsulationCap();
                final LazyOptional capOptional = LazyOptional.of(() -> itemInsulationCap);
                final Capability<IInsulatableCap> capability = ModCapabilities.ITEM_INSULATION;
                ICapabilitySerializable<CompoundNBT> provider = new ICapabilitySerializable<CompoundNBT>(){

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                        if (cap == capability) {
                            return capOptional.cast();
                        }
                        return LazyOptional.empty();
                    }

                    public CompoundNBT serializeNBT() {
                        return itemInsulationCap.serializeNBT();
                    }

                    public void deserializeNBT(CompoundNBT nbt) {
                        itemInsulationCap.deserializeNBT(nbt);
                    }
                };
                event.addCapability(new ResourceLocation("cold_sweat", "item_insulation"), (ICapabilityProvider)provider);
            }
        }

        @SubscribeEvent
        public static void handleInventoryOpen(PlayerContainerEvent event) {
            event.getPlayer().getPersistentData().func_74757_a("InventoryOpen", event instanceof PlayerContainerEvent.Open);
        }

        @SubscribeEvent
        public static void clearCachePeriodically(TickEvent.WorldTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.world.func_82737_E() % 200L == 0L) {
                CAP_CACHE.clear();
            }
        }

        @SubscribeEvent
        public static void onContainerOpen(PlayerContainerEvent.Open event) {
            event.getContainer().func_75132_a(INSULATION_LISTENER);
        }

        @SubscribeEvent
        public static void onContainerClose(PlayerContainerEvent.Close event) {
            SLOT_LISTENERS.get(event.getContainer()).remove(INSULATION_LISTENER);
            event.getContainer().func_75142_b();
        }

        static {
            SLOT_LISTENERS.field().setAccessible(true);
        }
    }
}

