/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class TempAttributeTraitArgument
implements ArgumentType<Temperature.Trait> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> new TranslationTextComponent("commands.forge.arguments.enum.invalid", new Object[]{constants, found}));

    public static TempAttributeTraitArgument attribute() {
        return new TempAttributeTraitArgument();
    }

    public static Temperature.Trait getAttribute(CommandContext<CommandSource> context, String argument) {
        return (Temperature.Trait)context.getArgument(argument, Temperature.Trait.class);
    }

    public Temperature.Trait parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Temperature.Trait.fromID(name);
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)Arrays.toString(this.getExamples().toArray()));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197005_b(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of(EntityTempManager.VALID_ATTRIBUTE_TRAITS).map(Temperature.Trait::func_176610_l).collect(Collectors.toList());
    }

    public static class Serializer
    implements IArgumentSerializer<TempAttributeTraitArgument> {
        public void serializeToNetwork(TempAttributeTraitArgument argument, PacketBuffer buffer) {
        }

        public TempAttributeTraitArgument deserializeFromNetwork(PacketBuffer buffer) {
            return new TempAttributeTraitArgument();
        }

        public void serializeToJson(TempAttributeTraitArgument argument, JsonObject json) {
        }
    }
}

