/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.common.command.BaseCommand;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class ColdSweatCommand
extends BaseCommand {
    public ColdSweatCommand(String name, int permissionLevel, boolean enabled) {
        super(name, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.then(Commands.func_197057_a((String)"dumpconfigs").executes(this::executeDumpConfigs))).then(Commands.func_197057_a((String)"reload").executes(this::executeReloadConfigs));
    }

    private int executeReloadConfigs(CommandContext<CommandSource> context) {
        try {
            Method openConfig = ConfigTracker.class.getDeclaredMethod("openConfig", ModConfig.class, Path.class);
            Field configsField = ConfigTracker.class.getDeclaredField("configsByMod");
            openConfig.setAccessible(true);
            configsField.setAccessible(true);
            ConcurrentHashMap configsByMod = (ConcurrentHashMap)configsField.get(ConfigTracker.INSTANCE);
            for (ModConfig config : ((Map)configsByMod.get("cold_sweat")).values()) {
                openConfig.invoke((Object)ConfigTracker.INSTANCE, config, FMLPaths.CONFIGDIR.get());
            }
            ConfigLoadingHandler.loadConfigs(((CommandSource)context.getSource()).func_241861_q());
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.reload.success"), true);
        }
        catch (Exception e) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.reload.failure", new Object[]{e.getMessage()}));
            ColdSweat.LOGGER.error("Error reloading Cold Sweat configs", (Throwable)e);
        }
        return 1;
    }

    private int executeDumpConfigs(CommandContext<CommandSource> context) {
        try {
            Path dumpPath = FMLPaths.CONFIGDIR.get().resolve("coldsweat").resolve("dump");
            if (dumpPath.toFile().exists()) {
                FileUtils.deleteDirectory((File)dumpPath.toFile());
            }
            DynamicRegistries registryAccess = ((CommandSource)context.getSource()).func_241861_q();
            File settingsFile = dumpPath.resolve("config_settings.txt").toFile();
            ArrayList settingsLines = new ArrayList();
            ConfigSettings.CONFIG_SETTINGS.forEach((location, holder) -> {
                if (holder.getCodec() == null) {
                    return;
                }
                JsonElement json = holder.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, holder.get(registryAccess)).result().orElse(null);
                if (json == null) {
                    return;
                }
                if (json instanceof JsonObject || json instanceof JsonArray) {
                    File file = dumpPath.resolve("settings").resolve(location.func_110623_a() + ".json").toFile();
                    file.getParentFile().mkdirs();
                    try {
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        JsonElement je = new JsonParser().parse(json.toString());
                        String prettyJsonString = gson.toJson(je);
                        FileWriter writer = new FileWriter(file);
                        writer.write(prettyJsonString);
                        writer.close();
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Error dumping config {}", location, (Object)e);
                    }
                } else {
                    String line = location.toString() + " = " + json.getAsString();
                    settingsLines.add(line);
                }
            });
            if (!settingsLines.isEmpty()) {
                settingsFile.getParentFile().mkdirs();
                try (FileWriter writer = new FileWriter(settingsFile);){
                    for (String line : settingsLines) {
                        writer.write(line + System.lineSeparator());
                    }
                }
                catch (Exception e) {
                    ColdSweat.LOGGER.error("Error writing config settings file", (Throwable)e);
                }
            }
            Style fileLinkStyle = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, dumpPath.toAbsolutePath().toString())).func_240712_a_(TextFormatting.GRAY).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("tooltip.open_link")));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.dump.success", new Object[]{new StringTextComponent(dumpPath.toString()).func_230530_a_(fileLinkStyle)}), true);
        }
        catch (Exception e) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.dump.failure", new Object[]{e.getMessage()}));
            ColdSweat.LOGGER.error("Error dumping Cold Sweat configs", (Throwable)e);
        }
        return 1;
    }
}

