/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ContainerInit;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class HearthContainer
extends Container {
    public final HearthBlockEntity te;

    public HearthContainer(int windowId, PlayerInventory playerInv, final HearthBlockEntity te) {
        super((ContainerType)ContainerInit.HEARTH_CONTAINER_TYPE.get(), windowId);
        this.te = te;
        this.func_75146_a(new Slot((IInventory)te, 0, 80, 48){

            public boolean func_75214_a(ItemStack stack) {
                if (te.getItemFuel(stack) != 0 || stack.func_77973_b() == Items.field_151117_aB) {
                    return true;
                }
                List effects = PotionUtils.func_185189_a((ItemStack)stack);
                return !effects.isEmpty() && effects.stream().noneMatch(eff -> ConfigSettings.HEARTH_POTION_BLACKLIST.get().contains(eff.func_188419_a()));
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInv, col + 9 * row + 9, 8 + col * 18, 166 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInv, col, 8 + col * 18, 142));
        }
    }

    public HearthContainer(int windowId, PlayerInventory playerInv, PacketBuffer data) {
        this(windowId, playerInv, HearthContainer.getTileEntity(playerInv, data));
    }

    public int getHotFuel() {
        return this.te.getHotFuel();
    }

    public int getColdFuel() {
        return this.te.getColdFuel();
    }

    private static HearthBlockEntity getTileEntity(PlayerInventory playerInv, PacketBuffer data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "PacketBuffer inventory cannot be null");
        TileEntity te = playerInv.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (te instanceof HearthBlockEntity) {
            return (HearthBlockEntity)te;
        }
        throw new IllegalStateException("Tile Entity is not correct");
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return playerIn.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.te.func_174877_v())) <= 64.0;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 1, 37, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (this.func_75139_a(0).func_75214_a(itemstack)) {
                    if (!this.func_75135_a(itemstack1, 0, 1, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (CSMath.betweenInclusive(index, this.field_75151_b.size() - 9, this.field_75151_b.size() - 1)) {
                    if (!this.func_75135_a(itemstack1, 1, this.field_75151_b.size() - 10, false)) {
                        slot.func_75220_a(itemstack1, itemstack);
                        return ItemStack.field_190927_a;
                    }
                } else if (CSMath.betweenInclusive(index, 1.0, this.field_75151_b.size() - 10) && !this.func_75135_a(itemstack1, this.field_75151_b.size() - 9, this.field_75151_b.size(), false)) {
                    slot.func_75220_a(itemstack1, itemstack);
                    return ItemStack.field_190927_a;
                }
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }
}

