/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.core.init.ContainerInit;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class IceboxContainer
extends Container {
    public final IceboxBlockEntity te;

    public IceboxContainer(int windowId, PlayerInventory playerInv, final IceboxBlockEntity te) {
        super((ContainerType)ContainerInit.ICEBOX_CONTAINER_TYPE.get(), windowId);
        this.te = te;
        this.func_75146_a(new Slot((IInventory)te, 0, 80, 62){

            public boolean func_75214_a(ItemStack stack) {
                return te.getItemFuel(stack) > 0;
            }
        });
        for (int in = 1; in < 10; ++in) {
            this.func_75146_a(new Slot((IInventory)te, in, -10 + in * 18, 35){

                public boolean func_75214_a(ItemStack stack) {
                    return ModItemTags.ICEBOX_VALID.func_230235_a_((Object)stack.func_77973_b()) || CompatManager.isSpoiledLoaded() && stack.func_222117_E();
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInv, col + 9 * row + 9, 8 + col * 18, 163 - (4 - row) * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInv, col, 8 + col * 18, 149));
        }
    }

    public IceboxContainer(int windowId, PlayerInventory playerInv, PacketBuffer data) {
        this(windowId, playerInv, IceboxContainer.getTileEntity(playerInv, data));
    }

    public int getFuel() {
        return this.te.getFuel();
    }

    private static IceboxBlockEntity getTileEntity(PlayerInventory playerInv, PacketBuffer data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "PacketBuffer inventory cannot be null");
        TileEntity te = playerInv.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (te instanceof IceboxBlockEntity) {
            return (IceboxBlockEntity)te;
        }
        throw new IllegalStateException("Tile Entity is not correct");
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return playerIn.func_70092_e((double)this.te.func_174877_v().func_177958_n(), (double)this.te.func_174877_v().func_177956_o(), (double)this.te.func_174877_v().func_177952_p()) <= 64.0;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (CSMath.betweenInclusive(index, 0.0, 9.0)) {
                if (!this.func_75135_a(itemstack1, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(1)).func_75214_a(itemstack)) {
                    if (!this.func_75135_a(itemstack1, 1, 10, false)) {
                        slot.func_75220_a(itemstack1, itemstack);
                        return ItemStack.field_190927_a;
                    }
                } else if (((Slot)this.field_75151_b.get(0)).func_75214_a(itemstack)) {
                    if (!this.func_75135_a(itemstack1, 0, 1, false)) {
                        slot.func_75220_a(itemstack1, itemstack);
                        return ItemStack.field_190927_a;
                    }
                } else if (CSMath.betweenInclusive(index, this.field_75151_b.size() - 9, this.field_75151_b.size())) {
                    if (!this.func_75135_a(itemstack1, 10, 36, false)) {
                        slot.func_75220_a(itemstack1, itemstack);
                        return ItemStack.field_190927_a;
                    }
                } else if (CSMath.betweenInclusive(index, 10.0, this.field_75151_b.size() - 9) && !this.func_75135_a(itemstack1, this.field_75151_b.size() - 9, this.field_75151_b.size(), false)) {
                    slot.func_75220_a(itemstack1, itemstack);
                    return ItemStack.field_190927_a;
                }
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }
}

