/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.api.event.common.insulation.InsulateItemEvent;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ContainerInit;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.IArmorVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.AbstractRepairContainer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class SewingContainer
extends AbstractRepairContainer {
    protected boolean quickMoving = false;
    protected PlayerInventory playerInventory;

    public SewingContainer(int containerId, PlayerInventory inventory) {
        this((ContainerType)ContainerInit.SEWING_CONTAINER_TYPE.get(), containerId, inventory, IWorldPosCallable.field_221489_a);
    }

    public SewingContainer(int i, PlayerInventory inventory, PacketBuffer friendlyByteBuf) {
        this(i, inventory);
    }

    public SewingContainer(ContainerType<?> menuType, int containerId, PlayerInventory inventory, IWorldPosCallable chunkAccess) {
        super(menuType, containerId, inventory, chunkAccess);
        this.playerInventory = inventory;
        this.field_75151_b.set(0, new Slot(this.field_234643_d_, 0, 43, 26){
            {
                this.field_75222_d = 0;
            }

            public boolean func_75214_a(ItemStack stack) {
                return ItemInsulationManager.isInsulatable(stack);
            }
        });
        this.field_75151_b.set(1, new Slot(this.field_234643_d_, 1, 43, 53){
            {
                this.field_75222_d = 1;
            }

            public boolean func_75214_a(ItemStack stack) {
                return ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.func_77973_b()) || Tags.Items.SHEARS.func_230235_a_((Object)stack.func_77973_b());
            }
        });
        this.field_75151_b.set(2, new Slot((IInventory)this.field_234642_c_, 2, 121, 39){
            {
                this.field_75222_d = 2;
            }

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity player) {
                return SewingContainer.this.func_230303_b_(player, this.func_75216_d());
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                return SewingContainer.this.func_230301_a_(player, stack);
            }
        });
    }

    public int getResultSlot() {
        return 2;
    }

    public ItemStack getItem(int index) {
        return this.func_75139_a(index).func_75211_c();
    }

    public void growItem(int index, int amount) {
        ItemStack stack = this.getItem(index);
        stack.func_190917_f(amount);
        this.func_75141_a(index, stack);
    }

    protected boolean func_230303_b_(PlayerEntity player, boolean hasStack) {
        return true;
    }

    protected ItemStack func_230301_a_(PlayerEntity player, ItemStack stack) {
        ItemStack input1 = this.getItem(0);
        ItemStack input2 = this.getItem(1);
        if (this.isRemovingInsulation()) {
            ItemInsulationManager.getInsulationCap(input1).ifPresent(cap -> {
                if (!cap.getInsulation().isEmpty()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        input2.func_222118_a(1, (LivingEntity)player, item -> {});
                    }
                    cap.removeInsulationItem(cap.getInsulationItem(cap.getInsulation().size() - 1));
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187763_eJ, SoundCategory.PLAYERS, 0.8f, 1.0f);
                    input1.func_196082_o().func_197643_a(cap.serializeNBT());
                }
            });
            this.func_82848_d();
            this.func_75142_b();
        } else if (ItemInsulationManager.isInsulatable(stack)) {
            if (!this.quickMoving) {
                this.growItem(0, -1);
                this.growItem(1, -1);
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_191257_dH, SoundCategory.BLOCKS, 0.5f, 1.0f);
            if (player instanceof ServerPlayerEntity) {
                ModAdvancementTriggers.ARMOR_INSULATED.trigger((ServerPlayerEntity)player, input1, input2);
            }
        }
        if (stack.func_77973_b() instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)stack.func_77973_b();
            SoundEvent equipSound = armor.func_200880_d().func_200899_b();
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), equipSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return stack;
    }

    protected boolean func_230302_a_(BlockState state) {
        return state.func_203425_a(ModBlocks.SEWING_TABLE);
    }

    public void func_82848_d() {
        if (this.quickMoving) {
            return;
        }
        ItemStack wearableItem = this.getItem(0);
        ItemStack insulatorItem = this.getItem(1);
        if (wearableItem.func_190926_b() || insulatorItem.func_190926_b()) {
            this.func_75141_a(this.getResultSlot(), ItemStack.field_190927_a);
            return;
        }
        if (ItemInsulationManager.isInsulatable(wearableItem)) {
            ItemStack processed;
            if (this.isRemovingInsulation()) {
                ItemInsulationManager.getInsulationCap(wearableItem).ifPresent(cap -> {
                    if (!cap.getInsulation().isEmpty()) {
                        this.func_75141_a(this.getResultSlot(), cap.getInsulationItem(cap.getInsulation().size() - 1).func_77946_l());
                    }
                });
            } else if (!(ConfigSettings.INSULATION_ITEMS.get().get((Object)insulatorItem.func_77973_b()).isEmpty() || insulatorItem.func_77973_b() instanceof IArmorVanishable && MobEntity.func_184640_d((ItemStack)wearableItem) != MobEntity.func_184640_d((ItemStack)insulatorItem) || !this.insulateArmorItem(processed = wearableItem.func_77946_l(), insulatorItem))) {
                ItemInsulationManager.getInsulationCap(wearableItem).ifPresent(cap -> processed.func_196082_o().func_197643_a(cap.serializeNBT()));
                this.func_75141_a(this.getResultSlot(), processed);
            }
        }
    }

    private boolean insulateArmorItem(ItemStack armorItem, ItemStack insulatorItem) {
        if (!ItemInsulationManager.isInsulatable(armorItem)) {
            return false;
        }
        InsulateItemEvent insulateEvent = new InsulateItemEvent(armorItem, insulatorItem, this.field_234645_f_);
        MinecraftForge.EVENT_BUS.post((Event)insulateEvent);
        if (insulateEvent.isCanceled()) {
            return false;
        }
        insulatorItem = insulateEvent.getInsulator();
        IInsulatableCap insulCap = (IInsulatableCap)ItemInsulationManager.getInsulationCap(armorItem).orElseThrow(() -> new IllegalStateException(String.format("Item %s does not have insulation capability", armorItem)));
        ItemStack insulator = insulatorItem.func_77946_l();
        insulator.func_190920_e(1);
        if (!insulCap.canAddInsulationItem(armorItem, insulator)) {
            return false;
        }
        insulCap.addInsulationItem(insulator);
        if (armorItem.func_77956_u()) {
            Map armorEnch = EnchantmentHelper.func_82781_a((ItemStack)armorItem);
            insulator.func_77986_q().removeIf(nbt -> {
                CompoundNBT enchantTag = (CompoundNBT)nbt;
                Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantTag.func_74779_i("id")));
                if (ench == null) {
                    return false;
                }
                if (ench.func_92089_a(armorItem) && armorEnch.keySet().stream().allMatch(ench2 -> ench2.func_191560_c(ench))) {
                    armorItem.func_77966_a(ench, enchantTag.func_74762_e("lvl"));
                    return true;
                }
                return false;
            });
        }
        return true;
    }

    public boolean isRemovingInsulation() {
        return Tags.Items.SHEARS.func_230235_a_((Object)this.getItem(1).func_77973_b());
    }

    public void func_75134_a(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            for (int i = 0; i < this.field_234643_d_.func_70302_i_(); ++i) {
                ItemStack itemStack = this.func_75139_a(i).func_75211_c();
                if (!itemStack.func_190926_b()) {
                    if (player.func_70089_S() && !serverPlayer.func_193105_t()) {
                        player.field_71071_by.func_191975_a(player.field_70170_p, itemStack);
                    } else {
                        player.func_71019_a(itemStack, true);
                    }
                }
                this.func_75139_a(i).func_75215_d(ItemStack.field_190927_a);
            }
        }
        super.func_75134_a(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        try {
            if (index == this.getResultSlot() && !this.isRemovingInsulation()) {
                this.quickMoving = true;
                Slot resultSlot = (Slot)this.field_75151_b.get(index);
                ItemStack result = resultSlot.func_75211_c();
                if (result.func_190926_b()) {
                    ItemStack itemStack = result;
                    return itemStack;
                }
                do {
                    this.growItem(0, -1);
                    this.growItem(1, -1);
                } while (this.insulateArmorItem(result, this.getItem(1)));
            }
        }
        finally {
            this.quickMoving = false;
        }
        return super.func_82846_b(player, index);
    }
}

