/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.momosoftworks.coldsweat.core.init.MemoryInit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class PrepareRamTask<E extends CreatureEntity>
extends Task<E> {
    private final ToIntFunction<E> cooldown;
    private final int minRamDistance;
    private final int maxRamDistance;
    private final float speed;
    private final EntityPredicate entityPredicate;
    private final int prepareTime;
    private final Function<E, SoundEvent> sound;
    private Optional<Long> prepareStartTime = Optional.empty();
    private Optional<Ram> ram = Optional.empty();

    public PrepareRamTask(ToIntFunction<E> cooldown, int minRamDistance, int maxRamDistance, float speed, EntityPredicate entityPredicate, int prepareTime, Function<E, SoundEvent> sound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryInit.RAM_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryInit.RAM_TARGET.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), 160);
        this.cooldown = cooldown;
        this.minRamDistance = minRamDistance;
        this.maxRamDistance = maxRamDistance;
        this.speed = speed;
        this.entityPredicate = entityPredicate;
        this.prepareTime = prepareTime;
        this.sound = sound;
    }

    protected void start(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        Brain brain = entityIn.func_213375_cj();
        brain.func_218207_c(MemoryModuleType.field_220946_g).flatMap(mobs -> mobs.stream().filter(mob -> this.entityPredicate.func_221015_a((LivingEntity)entityIn, mob)).findFirst()).ifPresent(mob -> this.findRam((CreatureEntity)entityIn, (LivingEntity)mob));
    }

    protected void stop(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        Brain brain = entityIn.func_213375_cj();
        if (!brain.func_218191_a((MemoryModuleType)MemoryInit.RAM_TARGET.get())) {
            worldIn.func_72960_a(entityIn, (byte)59);
            brain.func_218205_a((MemoryModuleType)MemoryInit.RAM_COOLDOWN_TICKS.get(), (Object)this.cooldown.applyAsInt(entityIn));
        }
    }

    protected boolean canStillUse(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        return this.ram.isPresent() && this.ram.get().getEntity().func_70089_S();
    }

    protected void tick(ServerWorld worldIn, E entityIn, long gameTime) {
        if (this.ram.isPresent()) {
            boolean isTargeting;
            entityIn.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(this.ram.get().getStart(), this.speed, 0));
            entityIn.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)this.ram.get().getEntity(), true));
            boolean bl = isTargeting = !this.ram.get().getEntity().func_233580_cy_().equals((Object)this.ram.get().getEnd());
            if (isTargeting) {
                worldIn.func_72960_a(entityIn, (byte)59);
                entityIn.func_70661_as().func_75500_f();
                this.findRam((CreatureEntity)entityIn, this.ram.get().entity);
            } else {
                BlockPos pos = entityIn.func_233580_cy_();
                if (pos.equals((Object)this.ram.get().getStart())) {
                    worldIn.func_72960_a(entityIn, (byte)58);
                    if (!this.prepareStartTime.isPresent()) {
                        this.prepareStartTime = Optional.of(gameTime);
                    }
                    if (gameTime - this.prepareStartTime.get() >= (long)this.prepareTime) {
                        entityIn.func_213375_cj().func_218205_a((MemoryModuleType)MemoryInit.RAM_TARGET.get(), (Object)this.calculateRamTarget(pos, this.ram.get().getEnd()));
                        worldIn.func_217384_a(null, entityIn, this.sound.apply(entityIn), SoundCategory.HOSTILE, 1.0f, 1.0f);
                        this.ram = Optional.empty();
                    }
                }
            }
        }
    }

    private Vector3d calculateRamTarget(BlockPos start, BlockPos end) {
        double x = 0.5 * (double)MathHelper.func_219802_k((double)(start.func_177958_n() - end.func_177958_n()));
        double z = 0.5 * (double)MathHelper.func_219802_k((double)(start.func_177952_p() - end.func_177952_p()));
        return Vector3d.func_237492_c_((Vector3i)end).func_72441_c(x, 0.0, z);
    }

    private Optional<BlockPos> findRamStart(CreatureEntity entity, LivingEntity target) {
        BlockPos pos = target.func_233580_cy_();
        if (!this.canReach(entity, pos)) {
            return Optional.empty();
        }
        ArrayList positions = Lists.newArrayList();
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.func_189533_g((Vector3i)pos);
            for (int distance = 0; distance < this.maxRamDistance; ++distance) {
                if (this.canReach(entity, (BlockPos)mutable.func_189536_c(direction))) continue;
                mutable.func_189536_c(direction.func_176734_d());
                break;
            }
            if (mutable.func_218139_n((Vector3i)pos) < this.minRamDistance) continue;
            positions.add(mutable.func_185334_h());
        }
        PathNavigator navigator = entity.func_70661_as();
        Stream validPositions = positions.stream();
        BlockPos entityPos = entity.func_233580_cy_();
        entityPos.getClass();
        return validPositions.sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)entityPos).func_177951_i(arg_0))).filter(start -> {
            Path path = navigator.func_179680_a(start, 0);
            return path != null && path.func_224771_h();
        }).findFirst();
    }

    private boolean canReach(CreatureEntity entity, BlockPos target) {
        return entity.func_70661_as().func_188555_b(target) && entity.func_184643_a(WalkNodeProcessor.func_237231_a_((IBlockReader)entity.field_70170_p, (BlockPos.Mutable)target.func_239590_i_())) == 0.0f;
    }

    private void findRam(CreatureEntity entity, LivingEntity target) {
        this.prepareStartTime = Optional.empty();
        this.ram = this.findRamStart(entity, target).map(start -> new Ram((BlockPos)start, target.func_233580_cy_(), target));
    }

    public static class Ram {
        private final BlockPos start;
        private final BlockPos end;
        private final LivingEntity entity;

        public Ram(BlockPos start, BlockPos end, LivingEntity entity) {
            this.start = start;
            this.end = end;
            this.entity = entity;
        }

        public BlockPos getStart() {
            return this.start;
        }

        public BlockPos getEnd() {
            return this.end;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }
    }
}

