/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.DisableHearthParticlesMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class HearthSaveDataHandler {
    public static final Set<Pair<BlockPos, ResourceLocation>> HEARTH_POSITIONS = new HashSet<Pair<BlockPos, ResourceLocation>>();
    public static final Set<Pair<BlockPos, ResourceLocation>> DISABLED_HEARTHS = new HashSet<Pair<BlockPos, ResourceLocation>>();

    @SubscribeEvent
    public static void saveDisabledHearths(PlayerEvent.PlayerLoggedOutEvent event) {
        event.getPlayer().getPersistentData().func_218657_a("disabledHearths", (INBT)HearthSaveDataHandler.serializeDisabledHearths());
    }

    public static CompoundNBT serializeDisabledHearths() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT disabledHearths = new ListNBT();
        for (Pair<BlockPos, ResourceLocation> pair : DISABLED_HEARTHS) {
            CompoundNBT hearthData = new CompoundNBT();
            hearthData.func_74772_a("Pos", ((BlockPos)pair.getFirst()).func_218275_a());
            hearthData.func_74778_a("Level", ((ResourceLocation)pair.getSecond()).toString());
            disabledHearths.add((Object)hearthData);
        }
        tag.func_218657_a("DisabledHearths", (INBT)disabledHearths);
        return tag;
    }

    public static void deserializeDisabledHearths(CompoundNBT disabledHearths) {
        DISABLED_HEARTHS.clear();
        for (INBT tag : disabledHearths.func_150295_c("DisabledHearths", 10)) {
            CompoundNBT hearthData = (CompoundNBT)tag;
            DISABLED_HEARTHS.add((Pair<BlockPos, ResourceLocation>)Pair.of((Object)BlockPos.func_218283_e((long)hearthData.func_74763_f("Pos")), (Object)new ResourceLocation(hearthData.func_74779_i("Level"))));
        }
    }

    @SubscribeEvent
    public static void loadDisabledHearths(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            CompoundNBT disabledHearths = new CompoundNBT();
            disabledHearths.func_218657_a("DisabledHearths", (INBT)player.getPersistentData().func_150295_c("DisabledHearths", 10));
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new DisableHearthParticlesMessage(disabledHearths));
        }
    }

    @SubscribeEvent
    public static void transferDisabledHearths(PlayerEvent.Clone event) {
        if (!event.getEntity().field_70170_p.func_201670_d()) {
            ListNBT disabledHearths = event.getOriginal().getPersistentData().func_150295_c("DisabledHearths", 10);
            event.getEntity().getPersistentData().func_218657_a("DisabledHearths", (INBT)disabledHearths);
        }
    }
}

