/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PreventPlayerSleep {
    @SubscribeEvent
    public static void onTrySleep(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        if (event.getResultStatus() != null || !ConfigSettings.CHECK_SLEEP_CONDITIONS.get().booleanValue() || ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().contains(player.field_70170_p.func_180495_p(event.getPos()).func_177230_c())) {
            return;
        }
        double bodyTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
        double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
        double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
        double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
        if (!CSMath.betweenExclusive(bodyTemp, -100.0, 100.0)) {
            Temperature.Trait trait = bodyTemp > 0.0 ? Temperature.Trait.HEAT_RESISTANCE : Temperature.Trait.COLD_RESISTANCE;
            if (Temperature.get((LivingEntity)player, trait) >= 1.0) {
                return;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("cold_sweat.message.sleep.body." + (bodyTemp > 99.0 ? "hot" : "cold")), true);
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
        } else if (!CSMath.betweenExclusive(worldTemp, minTemp, maxTemp)) {
            double tempResistance = Temperature.get((LivingEntity)player, worldTemp > maxTemp ? Temperature.Trait.HEAT_RESISTANCE : Temperature.Trait.COLD_RESISTANCE);
            if (tempResistance >= 1.0) {
                return;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("cold_sweat.message.sleep.world." + (worldTemp > maxTemp ? "hot" : "cold")), true);
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
        }
    }
}

