/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.common.insulation.InsulationTickEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ItemBreakEvent;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProcessEquipmentInsulation {
    @SubscribeEvent
    public static void applyArmorInsulation(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof ServerPlayerEntity && player.field_70173_aa % 20 == 0) {
            Advancement advancement;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            AtomicInteger fullyInsulatedSlots = new AtomicInteger(0);
            FastMap<String, Double> armorInsulation = new FastMap<String, Double>();
            double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
            double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
            double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
            for (ItemStack armorStack : player.func_184193_aE()) {
                if (!(armorStack.func_77973_b() instanceof ArmorItem)) continue;
                ProcessEquipmentInsulation.applyBuiltinArmorInsulation(armorInsulation, armorStack, player, worldTemp, minTemp, maxTemp);
                ProcessEquipmentInsulation.applySewnArmorInsulation(armorInsulation, armorStack, player, worldTemp, minTemp, maxTemp, fullyInsulatedSlots);
                double armorAmount = armorStack.func_111283_C(MobEntity.func_184640_d((ItemStack)armorStack)).entries().stream().filter(entry -> ((Attribute)entry.getKey()).equals(Attributes.field_233826_i_)).map(entry -> ((AttributeModifier)entry.getValue()).func_111164_d()).mapToDouble(Double::doubleValue).sum();
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_protection", Math.min(armorAmount, 20.0));
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_protection", Math.min(armorAmount, 20.0));
            }
            for (ItemStack curio : CompatManager.Curios.getCurios((LivingEntity)player)) {
                for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.func_77973_b())) {
                    if (!insulator.test((Entity)player, curio)) continue;
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_curios", insulator.getCold());
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_curios", insulator.getHeat());
                }
            }
            InsulationTickEvent insulationEvent = new InsulationTickEvent(player, armorInsulation);
            MinecraftForge.EVENT_BUS.post((Event)insulationEvent);
            if (!insulationEvent.isCanceled()) {
                double cold = insulationEvent.getProperty("cold");
                double heat = insulationEvent.getProperty("heat");
                if (cold > 0.0 || heat > 0.0) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new ArmorInsulationTempModifier(cold, heat).tickRate(20)).expires(20), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                }
            }
            if (fullyInsulatedSlots.get() >= 4 && serverPlayer.func_184102_h() != null && (advancement = serverPlayer.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation("cold_sweat:full_insulation"))) != null) {
                serverPlayer.func_192039_O().func_192750_a(advancement, "requirement");
            }
        }
    }

    private static void applyBuiltinArmorInsulation(Map<String, Double> armorInsulation, ItemStack armorStack, PlayerEntity player, double worldTemp, double minTemp, double maxTemp) {
        ArrayList armorInsulators = new ArrayList(ConfigSettings.INSULATING_ARMORS.get().get((Object)armorStack.func_77973_b()));
        if (!armorInsulators.isEmpty()) {
            Double newFactor = null;
            for (InsulatorData armorInsulator : armorInsulators) {
                if (!armorInsulator.test((Entity)player, armorStack)) continue;
                List<Insulation> insulations = Insulation.deepCopy(armorInsulator.insulation());
                for (Insulation insul : insulations) {
                    if (insul instanceof AdaptiveInsulation) {
                        AdaptiveInsulation adaptive = (AdaptiveInsulation)insul;
                        if (newFactor == null) {
                            AdaptiveInsulation.readFactorFromArmor(adaptive, armorStack);
                            newFactor = AdaptiveInsulation.calculateChange(adaptive, worldTemp, minTemp, maxTemp);
                            AdaptiveInsulation.setFactorToArmor(armorStack, newFactor);
                        }
                        adaptive.setFactor(newFactor);
                    }
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_armor", insul.getCold());
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_armor", insul.getHeat());
                }
            }
        }
    }

    private static void applySewnArmorInsulation(Map<String, Double> armorInsulation, ItemStack armorStack, PlayerEntity player, double worldTemp, double minTemp, double maxTemp, AtomicInteger fullyInsulatedSlots) {
        LazyOptional<IInsulatableCap> iCap = ItemInsulationManager.getInsulationCap(armorStack);
        List<InsulatorData> insulators = RequirementHolder.filterValid(ItemInsulationManager.getAppliedArmorInsulators(armorStack), (Entity)player);
        for (InsulatorData insulator : insulators) {
            for (Insulation insulation : insulator.insulation()) {
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_insulators", insulation.getCold());
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_insulators", insulation.getHeat());
            }
        }
        if ((armorInsulation.getOrDefault("cold_insulators", 0.0) + armorInsulation.getOrDefault("heat_insulators", 0.0)) / 2.0 >= (double)ItemInsulationManager.getInsulationSlots(armorStack)) {
            fullyInsulatedSlots.incrementAndGet();
        }
        if (iCap.resolve().isPresent() && iCap.resolve().get() instanceof ItemInsulationCap) {
            ItemInsulationCap cap = (ItemInsulationCap)iCap.resolve().get();
            cap.calcAdaptiveInsulation(worldTemp, minTemp, maxTemp);
            ProcessEquipmentInsulation.popExtraInsulation(cap, armorStack, player);
        }
    }

    private static void mapAdd(Map<String, Double> map, String key, double value) {
        map.put(key, map.getOrDefault(key, 0.0) + value);
    }

    private static void popExtraInsulation(ItemInsulationCap cap, ItemStack armorStack, PlayerEntity player) {
        List<Pair<ItemStack, List<InsulatorData>>> totalInsulation = cap.getInsulation();
        int filledInsulationSlots = totalInsulation.size();
        if (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
            WorldHelper.playEntitySound(SoundEvents.field_187629_cO, (Entity)player, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        while (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
            ItemStack removedItem = cap.removeInsulationItem((ItemStack)totalInsulation.get(totalInsulation.size() - 1).getFirst());
            WorldHelper.entityDropItem((Entity)player, removedItem);
            --filledInsulationSlots;
        }
    }

    @SubscribeEvent
    public static void onArmorBroken(ItemBreakEvent event) {
        ItemStack stack = event.getItemStack();
        LivingEntity entity = event.getEntityLiving();
        if (ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
                for (Pair<ItemStack, List<InsulatorData>> insulation : cap.getInsulation()) {
                    ItemEntity itemEntity = WorldHelper.entityDropItem((Entity)entity, (ItemStack)insulation.getFirst());
                    itemEntity.func_174867_a(8);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (source == DamageSource.field_190095_e && event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() == ModItems.HOGLIN_BOOTS) {
            event.setCanceled(true);
        }
    }
}

