/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.fluid;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public class ModFluidAttributes
extends FluidAttributes {
    private final BlockColor colorGetter;
    private final Supplier<SoundEvent> fillSound;
    private final Supplier<SoundEvent> emptySound;

    public ModFluidAttributes(CustomBuilder builder, Fluid fluid) {
        super((FluidAttributes.Builder)builder, fluid);
        this.colorGetter = builder.colorGetter;
        this.fillSound = builder.fillSound;
        this.emptySound = builder.emptySound;
    }

    public int getColor(IBlockDisplayReader level, BlockPos pos) {
        return this.colorGetter.getColor(level.func_180495_p(pos), level, pos, 0);
    }

    public SoundEvent getEmptySound() {
        return this.emptySound != null ? this.emptySound.get() : super.getEmptySound();
    }

    public SoundEvent getFillSound() {
        return this.fillSound != null ? this.fillSound.get() : super.getFillSound();
    }

    public static CustomBuilder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return new CustomBuilder(stillTexture, flowingTexture, ModFluidAttributes::new);
    }

    public static interface BlockColor {
        public int getColor(BlockState var1, @Nullable IBlockDisplayReader var2, @Nullable BlockPos var3, int var4);

        @OnlyIn(value=Dist.CLIENT)
        default public IBlockColor toMinecraft() {
            return new IBlockColor(){

                public int getColor(BlockState state, IBlockDisplayReader level, BlockPos pos, int tintIndex) {
                    return this.getColor(state, level, pos, tintIndex);
                }
            };
        }
    }

    public static class CustomBuilder
    extends FluidAttributes.Builder {
        private BlockColor colorGetter = (state, level, pos, index) -> -1;
        private Supplier<SoundEvent> fillSound;
        private Supplier<SoundEvent> emptySound;

        protected CustomBuilder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<CustomBuilder, Fluid, ModFluidAttributes> factory) {
            super(stillTexture, flowingTexture, (builder, fluid) -> {
                if (builder instanceof CustomBuilder) {
                    return (FluidAttributes)factory.apply((CustomBuilder)((Object)builder), (Fluid)fluid);
                }
                return null;
            });
        }

        public CustomBuilder color(BlockColor colorGetter) {
            this.colorGetter = colorGetter;
            return this;
        }

        public CustomBuilder sound(Supplier<SoundEvent> fillSound, Supplier<SoundEvent> emptySound) {
            this.fillSound = fillSound;
            this.emptySound = emptySound;
            return this;
        }
    }
}

