/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat;

import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.init.FetchSeasonsModsEvent;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.handler.ShearableFurManager;
import com.momosoftworks.coldsweat.common.entity.GoatEntity;
import com.momosoftworks.coldsweat.common.item.ThermometerItem;
import com.momosoftworks.coldsweat.compat.curios.EquipableCurio;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.GlassFluidPipeBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import sereneseasons.season.SeasonHooks;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.capability.CurioItemCapability;
import top.theillusivec4.curios.common.capability.ItemizedCurioCapability;

@Mod.EventBusSubscriber
public class CompatManager {
    private static final boolean BOP_LOADED = CompatManager.modLoaded("biomesoplenty");
    private static final boolean SERENE_SEASONS_LOADED = CompatManager.modLoaded("sereneseasons");
    private static final boolean CURIOS_LOADED = CompatManager.modLoaded("curios");
    private static final boolean SPIRIT_LOADED = CompatManager.modLoaded("spirit");
    private static final boolean BYG_LOADED = CompatManager.modLoaded("byg");
    private static final boolean CREATE_LOADED = CompatManager.modLoaded("create", "0.5.1");
    private static final boolean ATMOSPHERIC_LOADED = CompatManager.modLoaded("atmospheric");
    private static final boolean ENVIRONMENTAL_LOADED = CompatManager.modLoaded("environmental");
    private static final boolean TERRALITH_LOADED = CompatManager.modLoaded("terralith");
    private static final boolean WEATHER_LOADED = CompatManager.modLoaded("weather2");
    private static final boolean WYTHERS_LOADED = CompatManager.modLoaded("wwoo");
    private static final boolean BETTER_WEATHER_LOADED = CompatManager.modLoaded("betterweather");
    private static final boolean CAVES_AND_CLIFFS_LOADED = CompatManager.modLoaded("cavesandcliffs");
    private static final boolean TOOLTIPS_LOADED = CompatManager.modLoaded("legendarytooltips");
    private static final boolean PRIMAL_WINTER_LOADED = CompatManager.modLoaded("primalwinter");
    private static final boolean THIRST_LOADED = CompatManager.modLoaded("thirst", "1.16.5-1.3.8");
    private static final boolean ICEBERG_LOADED = CompatManager.modLoaded("iceberg");
    private static final boolean SPOILED_LOADED = CompatManager.modLoaded("spoiled");
    private static final boolean SUPPLEMENTARIES_LOADED = CompatManager.modLoaded("supplementaries");
    private static final boolean VALKYRIEN_SKIES_LOADED = CompatManager.modLoaded("valkyrienskies");
    private static final boolean TOUGH_AS_NAILS_LOADED = CompatManager.modLoaded("toughasnails");
    private static final boolean TWILIGHT_FOREST_LOADED = CompatManager.modLoaded("twilightforest");
    private static final boolean AETHER_LOADED = CompatManager.modLoaded("aether");
    private static final List<String> SEASONS_MODS = new ArrayList<String>();

    public static boolean modLoaded(String modID, String minVersion, String maxVersion) {
        List<String> disabledMods = ConfigSettings.DISABLED_MOD_COMPAT.get();
        if (disabledMods.contains(modID)) {
            return false;
        }
        ModFileInfo mod = FMLLoader.getLoadingModList().getModFileById(modID);
        if (mod == null) {
            return false;
        }
        ArtifactVersion version = ((IModInfo)mod.getMods().get(0)).getVersion();
        if (!minVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(minVersion)) < 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or higher for compat to be enabled! (found {})", (Object)modID, (Object)minVersion, (Object)version);
            return false;
        }
        if (!maxVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(maxVersion)) > 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or lower for compat to be enabled! (found {})", (Object)modID, (Object)maxVersion, (Object)version);
            return false;
        }
        return true;
    }

    public static boolean modLoaded(String modID, String minVersion) {
        return CompatManager.modLoaded(modID, minVersion, "");
    }

    public static boolean modLoaded(String modID) {
        return CompatManager.modLoaded(modID, "");
    }

    private static List<String> fetchSeasonsMods() {
        if (SEASONS_MODS.isEmpty()) {
            FetchSeasonsModsEvent event = new FetchSeasonsModsEvent();
            if (SERENE_SEASONS_LOADED) {
                event.addSeasonsMod("sereneseasons");
            }
            MinecraftForge.EVENT_BUS.post((Event)event);
            SEASONS_MODS.addAll(event.getSeasonsMods());
        }
        return SEASONS_MODS;
    }

    public static List<String> getSeasonsMods() {
        return CompatManager.fetchSeasonsMods();
    }

    public static boolean isBiomesOPlentyLoaded() {
        return BOP_LOADED;
    }

    public static boolean isSereneSeasonsLoaded() {
        return SERENE_SEASONS_LOADED;
    }

    public static boolean isCuriosLoaded() {
        return CURIOS_LOADED;
    }

    public static boolean isSpiritLoaded() {
        return SPIRIT_LOADED;
    }

    public static boolean isBiomesYoullGoLoaded() {
        return BYG_LOADED;
    }

    public static boolean isCreateLoaded() {
        return CREATE_LOADED;
    }

    public static boolean isAtmosphericLoaded() {
        return ATMOSPHERIC_LOADED;
    }

    public static boolean isEnvironmentalLoaded() {
        return ENVIRONMENTAL_LOADED;
    }

    public static boolean isTerralithLoaded() {
        return TERRALITH_LOADED;
    }

    public static boolean isWeather2Loaded() {
        return WEATHER_LOADED;
    }

    public static boolean isWythersLoaded() {
        return WYTHERS_LOADED;
    }

    public static boolean isBetterWeatherLoaded() {
        return BETTER_WEATHER_LOADED;
    }

    public static boolean isCavesAndCliffsLoaded() {
        return CAVES_AND_CLIFFS_LOADED;
    }

    public static boolean isLegendaryTooltipsLoaded() {
        return TOOLTIPS_LOADED;
    }

    public static boolean isPrimalWinterLoaded() {
        return PRIMAL_WINTER_LOADED;
    }

    public static boolean isThirstLoaded() {
        return THIRST_LOADED;
    }

    public static boolean isIcebergLoaded() {
        return ICEBERG_LOADED;
    }

    public static boolean isSpoiledLoaded() {
        return SPOILED_LOADED;
    }

    public static boolean isSupplementariesLoaded() {
        return SUPPLEMENTARIES_LOADED;
    }

    public static boolean isValkyrienSkiesLoaded() {
        return VALKYRIEN_SKIES_LOADED;
    }

    public static boolean isToughAsNailsLoaded() {
        return TOUGH_AS_NAILS_LOADED;
    }

    public static boolean isTwilightForestLoaded() {
        return TWILIGHT_FOREST_LOADED;
    }

    public static boolean isAetherLoaded() {
        return AETHER_LOADED;
    }

    public static boolean isGoat(Entity entity) {
        return CompatManager.isCavesAndCliffsLoaded() && entity instanceof com.blackgear.cavesandcliffs.common.entity.GoatEntity;
    }

    public static AnimalEntity createGoatFrom(final GoatEntity goat) {
        if (CompatManager.isCavesAndCliffsLoaded()) {
            return new Object(){

                public AnimalEntity create() {
                    com.blackgear.cavesandcliffs.common.entity.GoatEntity entity = new com.blackgear.cavesandcliffs.common.entity.GoatEntity((EntityType)CCBEntityTypes.GOAT.get(), goat.field_70170_p);
                    entity.func_82149_j((Entity)goat);
                    entity.field_70759_as = goat.field_70759_as;
                    entity.field_70761_aq = goat.field_70761_aq;
                    entity.func_70606_j(goat.func_110143_aJ());
                    entity.func_82227_f(goat.func_70631_g_());
                    entity.func_70873_a(goat.func_70874_b());
                    if (goat.func_145818_k_()) {
                        entity.func_200203_b(goat.func_200201_e());
                        entity.func_174805_g(goat.func_174833_aM());
                    }
                    entity.func_213317_d(goat.func_213322_ci());
                    entity.func_110149_m(goat.func_110139_bj());
                    entity.func_70050_g(goat.func_70086_ai());
                    entity.func_241209_g_(goat.func_223314_ad());
                    entity.func_189654_d(goat.func_189652_ae());
                    entity.func_184224_h(goat.func_190530_aW());
                    entity.func_174810_b(goat.func_174814_R());
                    entity.func_82142_c(goat.func_82150_aj());
                    entity.func_94061_f(goat.func_175446_cd());
                    entity.func_184641_n(goat.func_184638_cS());
                    if (goat.func_104002_bU()) {
                        entity.func_110163_bv();
                    }
                    entity.func_184195_f(goat.func_225510_bt_());
                    entity.func_204700_e(goat.func_234178_eO_());
                    entity.func_70604_c(goat.func_70643_av());
                    entity.func_130011_c((Entity)goat.func_110144_aD());
                    if (goat.func_110167_bD()) {
                        entity.func_110162_b(goat.func_110166_bE(), true);
                    }
                    entity.getPersistentData().func_197643_a(goat.getPersistentData());
                    entity.setScreaming(goat.isScreaming());
                    entity.func_233645_dx_().func_233788_a_(goat.func_233645_dx_().func_233794_c_());
                    ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> ShearableFurManager.getFurCap((Entity)goat).ifPresent(goatCap -> cap.deserializeNBT(goatCap.serializeNBT())));
                    return entity;
                }
            }.create();
        }
        return null;
    }

    public static void registerEventHandlers() {
        if (CURIOS_LOADED) {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onCurioChange(CurioChangeEvent event) {
                    EntityTempManager.updateInsulationAttributeModifiers(event.getEntityLiving(), event.getFrom(), event.getTo(), Insulation.Slot.CURIO);
                }
            });
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void registerEquipableCurios(AttachCapabilitiesEvent<ItemStack> event) {
                    ItemStack item = (ItemStack)event.getObject();
                    if (!(item.func_77973_b() instanceof ThermometerItem)) {
                        return;
                    }
                    EquipableCurio itemCurio = new EquipableCurio();
                    ItemizedCurioCapability itemizedCapability = new ItemizedCurioCapability((ICurioItem)itemCurio, item);
                    event.addCapability(CuriosCapability.ID_ITEM, CurioItemCapability.createProvider((ICurio)itemizedCapability));
                }
            });
        }
    }

    public static abstract class Valkyrien {
        public static Vector3d translateToShipCoords(Vector3d pos, Ship ship) {
            if (ship != null) {
                org.joml.Vector3d posVec = VectorConversionsMCKt.toJOML((IPosition)pos);
                ship.getWorldToShip().transformPosition(posVec);
                return VectorConversionsMCKt.toMinecraft((Vector3dc)posVec);
            }
            return pos;
        }

        public static AxisAlignedBB transformIfShipPos(World level, AxisAlignedBB aabb) {
            AtomicReference<AxisAlignedBB> translated = new AtomicReference<AxisAlignedBB>(aabb);
            StreamSupport.stream(VSGameUtilsKt.getShipsIntersecting((World)level, (AxisAlignedBB)aabb).spliterator(), false).findFirst().ifPresent(ship -> translated.set(VectorConversionsMCKt.toMinecraft((AABBdc)VectorConversionsMCKt.set((AABBd)new AABBd(), (AxisAlignedBB)aabb).transform(ship.getWorldToShip()))));
            return translated.get();
        }

        public static BlockPos transformIfShipPos(World level, BlockPos pos) {
            if (VALKYRIEN_SKIES_LOADED) {
                List shipTransforms = VSGameUtilsKt.transformToNearbyShipsAndWorld((World)level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0);
                if (shipTransforms.isEmpty()) {
                    return pos;
                }
                org.joml.Vector3d shipCoords = (org.joml.Vector3d)shipTransforms.get(0);
                return new BlockPos(VectorConversionsMCKt.toMinecraft((Vector3dc)shipCoords));
            }
            return pos;
        }
    }

    public static abstract class SereneSeasons {
        public static boolean isColdEnoughToSnow(World level, BlockPos pos) {
            return SERENE_SEASONS_LOADED && SeasonHooks.getBiomeTemperature((World)level, (Biome)level.func_226691_t_(pos), (BlockPos)pos) < 0.15f;
        }
    }

    public static abstract class Create {
        public static boolean isFluidPipe(BlockState state) {
            return CompatManager.isCreateLoaded() && (state.func_177230_c() instanceof FluidPipeBlock || state.func_177230_c() instanceof GlassFluidPipeBlock || state.func_177230_c() instanceof EncasedPipeBlock);
        }
    }

    public static abstract class Curios {
        public static boolean hasCurio(PlayerEntity player, Item curio) {
            return CURIOS_LOADED && Curios.getCurios((LivingEntity)player).stream().map(ItemStack::func_77973_b).anyMatch(item -> item == curio);
        }

        public static List<ItemStack> getCurios(LivingEntity entity) {
            if (!CURIOS_LOADED) {
                return new ArrayList<ItemStack>();
            }
            return entity.getCapability(CuriosCapability.INVENTORY).map(handler -> handler.getCurios().values()).map(handlers -> handlers.stream().map(ICurioStacksHandler::getStacks).map(stacks -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    list.add(stacks.getStackInSlot(i));
                }
                return list;
            }).flatMap(Collection::stream).collect(Collectors.toList())).orElse(new ArrayList());
        }
    }
}

