/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.compat.jei.JeiPlugin;
import com.momosoftworks.coldsweat.compat.jei.drawable.ItemDrawable;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.elements.DrawableResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ColdSweatFuelCategory
implements IRecipeCategory<JeiPlugin.FuelRecipe> {
    private final IDrawable icon;
    private final IDrawableStatic background;
    private final int width = this.getMaxWidth();
    private final int height;
    protected final IGuiHelper guiHelper;

    public ColdSweatFuelCategory(IGuiHelper guiHelper, ItemStack icon) {
        this.height = 34;
        this.icon = new ItemDrawable(icon);
        this.background = guiHelper.createBlankDrawable(this.width, this.height);
        this.guiHelper = guiHelper;
    }

    public abstract IFormattableTextComponent getTitleComponent();

    public abstract ResourceLocation getUid();

    public abstract Class<? extends JeiPlugin.FuelRecipe> getRecipeClass();

    protected abstract HearthBlockEntity getDummyBlockEntity();

    protected abstract ResourceLocation getEmptyGaugeTexture(JeiPlugin.FuelRecipe var1);

    protected abstract ResourceLocation getFilledGaugeTexture(JeiPlugin.FuelRecipe var1);

    public String getTitle() {
        return this.getTitleComponent().getString();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxWidth() {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        HearthBlockEntity dummyBlockEntity = this.getDummyBlockEntity();
        IFormattableTextComponent maxSmeltCountText = ColdSweatFuelCategory.createFillAmountText(dummyBlockEntity.getMaxFuel(), dummyBlockEntity);
        int maxStringWidth = fontRenderer.func_78256_a(maxSmeltCountText.getString());
        int textPadding = 20;
        return 18 + textPadding + maxStringWidth;
    }

    public IDrawableStatic getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout builder, JeiPlugin.FuelRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = builder.getItemStacks();
        guiItemStacks.init(0, true, 1, 17);
        guiItemStacks.set(ingredients);
    }

    public void draw(JeiPlugin.FuelRecipe recipe, MatrixStack poseStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer font = minecraft.field_71466_p;
        HearthBlockEntity dummyBlockEntity = this.getDummyBlockEntity();
        double fuel = Math.abs(recipe.fuelData().fuel());
        IFormattableTextComponent fillAmountText = ColdSweatFuelCategory.createFillAmountText(fuel, dummyBlockEntity);
        int textWidth = font.func_78256_a(fillAmountText.getString());
        int textX = this.width - 12 - textWidth;
        int textY = this.height - 20;
        font.func_243248_b(poseStack, (ITextComponent)fillAmountText, (float)textX, (float)textY, -8355712);
        int gaugeHeight = fuel <= 0.0 ? 0 : (int)Math.round(CSMath.blend(2.0, 14.0, fuel, 0.0, (double)dummyBlockEntity.getMaxFuel()));
        int maxGaugeHeight = 14;
        DrawableResource fuelGauge = new DrawableResource(this.getFilledGaugeTexture(recipe), 0, 14 - gaugeHeight, 14, gaugeHeight, 0, 0, 0, 0, 14, 14);
        DrawableResource emptyFuelGauge = new DrawableResource(this.getEmptyGaugeTexture(recipe), 0, 0, 14, 14, 0, 0, 0, 0, 14, 14);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        emptyFuelGauge.draw(poseStack, 2, 0);
        fuelGauge.draw(poseStack, 2, 0 + (maxGaugeHeight - gaugeHeight));
        this.guiHelper.getSlotDrawable().draw(poseStack, 1, 17);
    }

    public void setIngredients(JeiPlugin.FuelRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(recipe.input()));
    }

    private static IFormattableTextComponent createFillAmountText(double fuelAmount, HearthBlockEntity dummyBlockEntity) {
        int fuelInterval = dummyBlockEntity.getFuelDrainInterval();
        int durationTicks = (int)Math.round(fuelAmount * (double)fuelInterval);
        return new TranslationTextComponent("jei.cold_sweat.fuel_duration", new Object[]{StringUtils.func_76337_a((int)durationTicks)});
    }
}

