/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.compat.jei.JeiPlugin;
import com.momosoftworks.coldsweat.compat.jei.drawable.ItemDrawable;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.elements.DrawableResource;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class SewingCategory
implements IRecipeCategory<JeiPlugin.SewingRecipe> {
    private static final ItemStack INSULATABLE_ITEM = Items.field_151030_Z.func_190903_i();
    private final IDrawable icon;
    private final IDrawable background;
    protected final IGuiHelper guiHelper;

    public SewingCategory(IGuiHelper guiHelper) {
        int width = 130;
        int height = 34;
        this.icon = new ItemDrawable(ModItems.SEWING_TABLE.func_190903_i());
        this.background = guiHelper.createBlankDrawable(width, height);
        this.guiHelper = guiHelper;
    }

    public String getTitle() {
        return new TranslationTextComponent("jei.cold_sweat.category.sewing").getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(JeiPlugin.SewingRecipe recipe, MatrixStack poseStack, double mouseX, double mouseY) {
        DrawableResource plusSign = new DrawableResource(new ResourceLocation("jei", "textures/gui/recipe_plus_sign.png"), 0, 0, 13, 13, 0, 0, 0, 0, 13, 13);
        plusSign.draw(poseStack, 31, 12);
        DrawableResource arrow = new DrawableResource(new ResourceLocation("jei", "textures/gui/recipe_arrow.png"), 0, 0, 24, 17, 0, 0, 0, 0, 24, 17);
        arrow.draw(poseStack, 76, 10);
        this.guiHelper.getSlotDrawable().draw(poseStack, 8, 10);
        this.guiHelper.getSlotDrawable().draw(poseStack, 53, 10);
        this.guiHelper.getSlotDrawable().draw(poseStack, 105, 10);
    }

    public ResourceLocation getUid() {
        return JeiPlugin.SEWING_RECIPE_CATEGORY;
    }

    public Class<JeiPlugin.SewingRecipe> getRecipeClass() {
        return JeiPlugin.SewingRecipe.class;
    }

    public void setRecipe(IRecipeLayout builder, JeiPlugin.SewingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = builder.getItemStacks();
        guiItemStacks.init(0, true, 8, 10);
        guiItemStacks.init(1, true, 53, 10);
        guiItemStacks.init(2, false, 105, 10);
        guiItemStacks.set(0, Arrays.asList(recipe.input()));
        guiItemStacks.set(1, Arrays.asList(INSULATABLE_ITEM));
        guiItemStacks.set(2, Arrays.asList(SewingCategory.getInsulatedItem(recipe.input())));
    }

    public void setIngredients(JeiPlugin.SewingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(recipe.input(), INSULATABLE_ITEM));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)SewingCategory.getInsulatedItem(recipe.input()));
    }

    private static ItemStack getInsulatedItem(ItemStack input) {
        ItemStack insulatedItem = INSULATABLE_ITEM.func_77946_l();
        ItemInsulationManager.getInsulationCap(insulatedItem).ifPresent(cap -> {
            cap.addInsulationItem(input);
            insulatedItem.func_196082_o().func_197643_a(cap.serializeNBT());
        });
        return insulatedItem;
    }
}

