/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.registry.LoadRegistriesEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.BlockTempBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.DryingItemBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.EntityClimateBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.EntityTempBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.FoodBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.FuelBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.InsulatingMountBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.InsulatorBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.ItemTempBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.builder.SpawnBiomeBuilderJS;
import com.momosoftworks.coldsweat.compat.kubejs.util.TempModifierDataJS;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import dev.latvian.kubejs.event.StartupEventJS;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;

public class ModRegistriesEventJS
extends StartupEventJS {
    private final LoadRegistriesEvent.Pre event;

    public ModRegistriesEventJS(LoadRegistriesEvent.Pre event) {
        this.event = event;
    }

    public void addBlockTemperature(Consumer<BlockTempBuilderJS> builder, BlockTempBuilderJS.Function function) {
        BlockTempBuilderJS blockTempJS = new BlockTempBuilderJS();
        builder.accept(blockTempJS);
        BlockTemp blockTemp = blockTempJS.build(function);
        if (blockTemp.getAffectedBlocks().isEmpty()) {
            return;
        }
        BlockTempRegistry.register(blockTemp);
        ColdSweat.LOGGER.info("Registered KubeJS block temperature for blocks: {}", blockTempJS.blocks);
    }

    public void addBlockTemperature(double temperature, String units, Consumer<BlockTempBuilderJS> builder) {
        builder = ((Consumer<BlockTempBuilderJS>)blockTemp -> blockTemp.units(Temperature.Units.fromID(units))).andThen(builder);
        this.addBlockTemperature(builder, (level, entity, state, pos, distance) -> temperature);
    }

    public void addInsulator(Consumer<InsulatorBuilderJS> builder) {
        InsulatorData insulatorDate;
        InsulatorBuilderJS insulatorJS = new InsulatorBuilderJS();
        builder.accept(insulatorJS);
        if (insulatorJS.itemPredicate.isEmpty()) {
            insulatorJS.itemPredicate.add(new ItemRequirement(Collections.singleton(null), null), false);
        }
        if (!(insulatorDate = insulatorJS.build()).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.INSULATOR_DATA, insulatorDate);
    }

    public void addFoodTemperature(Consumer<FoodBuilderJS> builder) {
        FoodData foodData;
        FoodBuilderJS foodJS = new FoodBuilderJS();
        builder.accept(foodJS);
        if (foodJS.itemPredicate.isEmpty()) {
            foodJS.itemPredicate.add(new ItemRequirement(Collections.singleton(null), null), false);
        }
        if (!(foodData = foodJS.build()).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.FOOD_DATA, foodData);
    }

    private void addFuel(Consumer<FuelBuilderJS> builder, FuelData.FuelType fuelType) {
        FuelData fuelData;
        FuelBuilderJS fuelJS = new FuelBuilderJS();
        builder.accept(fuelJS);
        if (fuelJS.itemPredicate.isEmpty()) {
            fuelJS.itemPredicate.add(new ItemRequirement(Collections.singleton(null), null), false);
        }
        if (!(fuelData = fuelJS.build(fuelType)).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.FUEL_DATA, fuelData);
    }

    public void addHearthFuel(Consumer<FuelBuilderJS> builder) {
        this.addFuel(builder, FuelData.FuelType.HEARTH);
    }

    public void addBoilerFuel(Consumer<FuelBuilderJS> builder) {
        this.addFuel(builder, FuelData.FuelType.BOILER);
    }

    public void addIceboxFuel(Consumer<FuelBuilderJS> builder) {
        this.addFuel(builder, FuelData.FuelType.ICEBOX);
    }

    public void addSoulspringLampFuel(Consumer<FuelBuilderJS> builder) {
        this.addFuel(builder, FuelData.FuelType.SOUL_LAMP);
    }

    public void addItemTemperature(Consumer<ItemTempBuilderJS> builder) {
        ItemTempData itemData;
        ItemTempBuilderJS itemTempJS = new ItemTempBuilderJS();
        builder.accept(itemTempJS);
        if (itemTempJS.itemPredicate.isEmpty()) {
            itemTempJS.itemPredicate.add(new ItemRequirement(Collections.singleton(null), null), false);
        }
        if (!(itemData = itemTempJS.build()).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.ITEM_TEMP_DATA, itemData);
    }

    public void addDryingItem(Consumer<DryingItemBuilderJS> builder) {
        DryingItemData dryingData;
        DryingItemBuilderJS dryingItemJS = new DryingItemBuilderJS();
        builder.accept(dryingItemJS);
        if (dryingItemJS.itemPredicate.isEmpty()) {
            dryingItemJS.itemPredicate.add(new ItemRequirement(Collections.singleton(null), null), false);
        }
        if (!(dryingData = dryingItemJS.build()).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.DRYING_ITEM_DATA, dryingData);
    }

    private <K, V extends ConfigData> void addRegistryConfig(RegistryKey<Registry<K>> keyRegistry, RegistryHolder<V> modRegistry, String[] rawKeys, Function<NegatableList<K>, V> constructor) {
        NegatableList<K> parsed = ConfigHelper.parseRegistryItems(keyRegistry, this.event.getRegistryAccess(), rawKeys);
        if (parsed.isEmpty()) {
            ColdSweat.LOGGER.error("Failed to find any {} in: {}", (Object)keyRegistry.func_240901_a_().func_110623_a(), (Object)Arrays.toString(rawKeys));
            return;
        }
        ConfigData configData = (ConfigData)constructor.apply(parsed);
        configData.setConfigType(ConfigData.Type.KUBEJS);
        if (!configData.areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(modRegistry, configData);
    }

    public void addBiomeTemperature(double minTemp, double maxTemp, String units, String[] biomes, double waterTemp) {
        this.addRegistryConfig(Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, biomes, parsedBiomes -> new BiomeTempData((NegatableList<Biome>)parsedBiomes, minTemp, maxTemp, Temperature.Units.fromID(units), waterTemp, false, false));
    }

    public void addBiomeTemperature(double minTemp, double maxTemp, String units, String ... biomes) {
        this.addRegistryConfig(Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, biomes, parsedBiomes -> new BiomeTempData((NegatableList<Biome>)parsedBiomes, minTemp, maxTemp, Temperature.Units.fromID(units), Double.NaN, false, false));
    }

    public void addBiomeOffset(double minTemp, double maxTemp, String units, String[] biomes, double waterTemp) {
        this.addRegistryConfig(Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, biomes, parsedBiomes -> new BiomeTempData((NegatableList<Biome>)parsedBiomes, minTemp, maxTemp, Temperature.Units.fromID(units), waterTemp, true, false));
    }

    public void addBiomeOffset(double minTemp, double maxTemp, String units, String ... biomes) {
        this.addRegistryConfig(Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, biomes, parsedBiomes -> new BiomeTempData((NegatableList<Biome>)parsedBiomes, minTemp, maxTemp, Temperature.Units.fromID(units), Double.NaN, true, false));
    }

    public void addDimensionTemperature(double temperature, String units, String ... dimensions) {
        this.addRegistryConfig(Registry.field_239698_ad_, ModRegistries.DIMENSION_TEMP_DATA, dimensions, parsedDimensions -> new DimensionTempData((NegatableList<DimensionType>)parsedDimensions, temperature, Temperature.Units.fromID(units), false));
    }

    public void addDimensionTemperature(double temperature, String ... dimensions) {
        this.addDimensionTemperature(temperature, "mc", dimensions);
    }

    public void addDimensionOffset(double temperature, String units, String ... dimensions) {
        this.addRegistryConfig(Registry.field_239698_ad_, ModRegistries.DIMENSION_TEMP_DATA, dimensions, parsedDimensions -> new DimensionTempData((NegatableList<DimensionType>)parsedDimensions, temperature, Temperature.Units.fromID(units), true));
    }

    public void addDimensionOffset(double temperature, String ... dimensions) {
        this.addDimensionOffset(temperature, "mc", dimensions);
    }

    public void addStructureTemperature(double temperature, String units, String ... structures) {
        this.addRegistryConfig(Registry.field_243553_av, ModRegistries.STRUCTURE_TEMP_DATA, structures, parsedStructures -> new StructureTempData((NegatableList<StructureFeature<?, ?>>)parsedStructures, temperature, Temperature.Units.fromID(units), false));
    }

    public void addStructureTemperature(double temperature, String ... structures) {
        this.addStructureTemperature(temperature, "mc", structures);
    }

    public void addStructureOffset(double temperature, String units, String ... structures) {
        this.addRegistryConfig(Registry.field_243553_av, ModRegistries.STRUCTURE_TEMP_DATA, structures, parsedStructures -> new StructureTempData((NegatableList<StructureFeature<?, ?>>)parsedStructures, temperature, Temperature.Units.fromID(units), true));
    }

    public void addStructureOffset(double temperature, String ... structures) {
        this.addStructureOffset(temperature, "mc", structures);
    }

    public void addEntityTemperature(Consumer<EntityTempBuilderJS> builder) {
        EntityTempData entityTempData;
        EntityTempBuilderJS entityTempJS = new EntityTempBuilderJS();
        builder.accept(entityTempJS);
        if (entityTempJS.entityPredicate.isEmpty()) {
            entityTempJS.entityPredicate.add(new EntityRequirement(Collections.singleton(null), null), false);
        }
        if (!(entityTempData = entityTempJS.build()).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.ENTITY_TEMP_DATA, entityTempData);
    }

    public void addEntityClimate(Consumer<EntityClimateBuilderJS> builder) {
        EntityClimateData entityClimateData;
        EntityClimateBuilderJS entityClimateJS = new EntityClimateBuilderJS();
        builder.accept(entityClimateJS);
        if (entityClimateJS.entityPredicate.isEmpty()) {
            entityClimateJS.entityPredicate.add(new EntityRequirement(Collections.singleton(null), null), false);
        }
        if (!(entityClimateData = entityClimateJS.build()).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.ENTITY_CLIMATE_DATA, entityClimateData);
    }

    public void addInsulatingMount(Consumer<InsulatingMountBuilderJS> builder) {
        MountData mountData;
        InsulatingMountBuilderJS insulatingMountJS = new InsulatingMountBuilderJS();
        builder.accept(insulatingMountJS);
        if (insulatingMountJS.entityPredicate.isEmpty()) {
            insulatingMountJS.entityPredicate.add(new EntityRequirement(Collections.singleton(null), null), false);
        }
        if (!(mountData = insulatingMountJS.build()).areRequiredModsLoaded()) {
            return;
        }
        this.event.addRegistryEntry(ModRegistries.MOUNT_DATA, mountData);
    }

    public void addSpawnBiomes(Consumer<SpawnBiomeBuilderJS> builder) {
        SpawnBiomeBuilderJS spawnBiomeJS = new SpawnBiomeBuilderJS();
        builder.accept(spawnBiomeJS);
        SpawnBiomeData spawnBiomeData = spawnBiomeJS.build();
        if (!spawnBiomeData.areRequiredModsLoaded()) {
            return;
        }
        if (spawnBiomeJS.biomes.isEmpty()) {
            spawnBiomeJS.biomes.add(null);
        }
        this.event.addRegistryEntry(ModRegistries.ENTITY_SPAWN_BIOME_DATA, spawnBiomeData);
    }

    public void addTempModifier(String id, Function<TempModifierDataJS, Function<Double, Double>> constructor) {
        ResourceLocation key = new ResourceLocation(id);
        if (key.func_110624_b().equals("minecraft")) {
            ColdSweat.LOGGER.error("KubeJS: Non-Minecraft namespace required for TempModifier IDs (i.e. mymod:my_modifier)");
            return;
        }
        TempModifierRegistry.register(key, () -> new TempModifierJS(constructor));
    }

    static class TempModifierJS
    extends TempModifier {
        Function<TempModifierDataJS, Function<Double, Double>> constructor;

        public TempModifierJS(Function<TempModifierDataJS, Function<Double, Double>> constructor) {
            this.constructor = constructor;
        }

        @Override
        protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
            return this.constructor.apply(new TempModifierDataJS(entity, trait));
        }
    }
}

