/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event.builder;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.List;
import net.minecraft.entity.EntityType;

public class EntityClimateBuilderJS {
    public NegatableList<EntityRequirement> entityPredicate = new NegatableList();
    public double minTemp = -1.7976931348623157E308;
    public double maxTemp = Double.MAX_VALUE;
    public double rate = 1.0;
    public Temperature.Units units = Temperature.Units.MC;

    public EntityClimateBuilderJS entities(String ... entities) {
        List<EntityType<?>> entList = RegistryHelper.mapTaggableList(ConfigHelper.getEntityTypes(entities));
        if (entList.isEmpty() && entities.length != 0) {
            this.entityPredicate.add(EntityRequirement.NONE, true);
        } else {
            this.entityPredicate.add(new EntityRequirement(entList, null), false);
        }
        return this;
    }

    public EntityClimateBuilderJS temperature(double minTempOffset, double maxTempOffset) {
        this.minTemp = minTempOffset;
        this.maxTemp = maxTempOffset;
        return this;
    }

    public EntityClimateBuilderJS rate(double rate) {
        this.rate = rate;
        return this;
    }

    public EntityClimateBuilderJS units(String units) {
        this.units = Temperature.Units.fromID(units);
        return this;
    }

    public EntityClimateData build() {
        EntityClimateData data = new EntityClimateData(this.entityPredicate, this.minTemp, this.maxTemp, this.rate, this.units);
        data.setConfigType(ConfigData.Type.KUBEJS);
        return data;
    }
}

