/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.registry.AddRegistriesEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.LoadRegistriesEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.ConfiguredBlockTemp;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.TempModifierInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncConfigSettingsMessage;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RegistryModifierData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.resources.IResource;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ConfigLoadingHandler {
    public static final Multimap<RegistryHolder<?>, RegistryModifierData<?>> REGISTRY_MODIFIERS = new RegistryMultiMap();
    private static boolean REGISTRIES_INITIALIZED = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loadConfigsEvent(FMLServerAboutToStartEvent event) {
        ConfigLoadingHandler.loadConfigs(event.getServer().func_244267_aX());
    }

    public static void loadConfigs(DynamicRegistries registryAccess) {
        long startTime = System.nanoTime();
        ConfigSettings.clear();
        BlockTempRegistry.flush();
        ModRegistries.getRegistries().forEach((registryKey, registry) -> registry.flush());
        RegistryMultiMap registries = new RegistryMultiMap();
        ColdSweat.LOGGER.info("Loading registries from configs...");
        registries.putAll(ConfigLoadingHandler.collectUserRegistries());
        ColdSweat.LOGGER.info("Loading registries from data resources...");
        registries.putAll(ConfigLoadingHandler.collectDataRegistries());
        ConfigLoadingHandler.logAndAddRegistries(registryAccess, registries);
        ColdSweat.LOGGER.info("Loading TOML configs...");
        ConfigSettings.load(registryAccess, false);
        TempModifierInit.buildBlockConfigs();
        ColdSweat.LOGGER.info("Loading BlockTemps...");
        TempModifierInit.buildBlockRegistries();
        TaskScheduler.scheduleServer(() -> ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncConfigSettingsMessage(registryAccess)), 1);
    }

    @SubscribeEvent
    public static void initRegistries(FMLServerAboutToStartEvent event) {
        if (REGISTRIES_INITIALIZED) {
            return;
        }
        ColdSweat.LOGGER.info("Gathering Cold Sweat registries");
        AddRegistriesEvent addRegistriesEvent = new AddRegistriesEvent();
        MinecraftForge.EVENT_BUS.start();
        MinecraftForge.EVENT_BUS.post((Event)addRegistriesEvent);
        REGISTRIES_INITIALIZED = true;
    }

    public static Multimap<RegistryHolder<?>, ? extends ConfigData> collectDataRegistries() {
        ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().addAll(ModBlockTags.HEARTH_SPREAD_WHITELIST.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.debug("Adding block {} to hearth spread whitelist", holder)).collect(Collectors.toSet()));
        ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().addAll(ModBlockTags.HEARTH_SPREAD_BLACKLIST.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.debug("Adding block {} to hearth spread blacklist", holder)).collect(Collectors.toSet()));
        ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().addAll(ModBlockTags.IGNORE_SLEEP_CHECK.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.debug("Disabling sleeping conditions check for block {}", holder)).collect(Collectors.toSet()));
        ConfigSettings.INSULATION_BLACKLIST.get().addAll(ModItemTags.NOT_INSULATABLE.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.debug("Adding item {} to insulation blacklist", holder)).collect(Collectors.toSet()));
        RegistryMultiMap registries = new RegistryMultiMap();
        for (Map.Entry<ResourceLocation, RegistryHolder<?>> entry : ModRegistries.getRegistries().entrySet()) {
            RegistryHolder<?> registry = entry.getValue();
            try {
                String registryPath = String.format("%s/%s", "cold_sweat", registry.key().func_240901_a_().func_110623_a());
                for (ResourceLocation resourceLocation : ModRegistries.getResourceManager().func_199003_a(registryPath, file -> file.endsWith(".json"))) {
                    IResource resource = ModRegistries.getResourceManager().func_199002_a(resourceLocation);
                    try {
                        InputStream inputStream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            JsonElement requiredModsField;
                            NegatableList<String> requiredMods;
                            JsonObject json = JSONUtils.func_212743_a((Reader)new InputStreamReader(inputStream));
                            String relativePath = resourceLocation.func_110623_a().replace(registryPath, "");
                            relativePath = relativePath.substring(1, relativePath.length() - 5);
                            ResourceLocation registryId = new ResourceLocation(resourceLocation.func_110624_b(), relativePath);
                            RegistryKey registryKey = RegistryKey.func_240903_a_(registry.key(), (ResourceLocation)registryId);
                            if (json.has("required_mods") && !(requiredMods = ConfigData.REQUIRED_MODS_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)(requiredModsField = json.get("required_mods"))).result().orElse(new NegatableList())).test(CompatManager::modLoaded)) {
                                ColdSweat.LOGGER.info("Skipping registration of {} {}: required mods not met", (Object)registry.key().func_240901_a_(), (Object)registryId);
                                continue;
                            }
                            registry.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)ColdSweat.LOGGER).error(arg_0)).ifPresent(data -> {
                                if (!data.areRequiredModsLoaded()) {
                                    ColdSweat.LOGGER.warn("Skipping registration of {} {}: missing required mods", registry.key(), (Object)registryId);
                                    return;
                                }
                                data.setConfigType(ConfigData.Type.JSON);
                                data.setRegistryKey((RegistryKey<? extends ConfigData>)registryKey);
                                registry.register(registryId, data);
                                ((RegistryMultiMap)registries).put(registry, data);
                            });
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Failed to load JSON registry: {}", registry.key(), (Object)e);
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        return registries;
    }

    public static Multimap<RegistryHolder<?>, ? extends ConfigData> collectUserRegistries() {
        RegistryMultiMap registries = new RegistryMultiMap();
        for (Map.Entry<ResourceLocation, RegistryHolder<?>> entry : ModRegistries.getRegistries().entrySet()) {
            RegistryHolder<?> registry = entry.getValue();
            registries.putAll(registry, ConfigLoadingHandler.parseConfigData(registry));
        }
        return registries;
    }

    private static void logAndAddRegistries(DynamicRegistries registryAccess, Multimap<RegistryHolder<?>, ? extends ConfigData> registries) {
        ConfigLoadingHandler.setDefaultRegistryPriority(registries);
        ConfigLoadingHandler.loadRegistryModifiers();
        for (ConfigData data : registries.values()) {
            data.setConfigType(ConfigData.Type.JSON);
        }
        LoadRegistriesEvent.Pre event = new LoadRegistriesEvent.Pre(registryAccess, registries, REGISTRY_MODIFIERS);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ConfigLoadingHandler.modifyRegistries(event.getRegistries());
        Collection<InsulatorData> insulators = event.getRegistry(ModRegistries.INSULATOR_DATA);
        ConfigLoadingHandler.addInsulatorConfigs(insulators);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulators", insulators.size()), insulators);
        Collection<FuelData> fuels = event.getRegistry(ModRegistries.FUEL_DATA);
        ConfigLoadingHandler.addFuelConfigs(fuels);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s fuels", fuels.size()), fuels);
        Collection<FoodData> foods = event.getRegistry(ModRegistries.FOOD_DATA);
        ConfigLoadingHandler.addFoodConfigs(foods);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s foods", foods.size()), foods);
        Collection<ItemTempData> itemTemps = event.getRegistry(ModRegistries.ITEM_TEMP_DATA);
        ConfigLoadingHandler.addItemTempConfigs(itemTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s item temperatures", itemTemps.size()), itemTemps);
        Collection<DryingItemData> dryingItems = event.getRegistry(ModRegistries.DRYING_ITEM_DATA);
        ConfigLoadingHandler.addDryingItemConfigs(dryingItems);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s drying items", dryingItems.size()), dryingItems);
        Collection<ItemInsulationSlotsData> insulationSlots = event.getRegistry(ModRegistries.INSULATION_SLOTS_DATA);
        ConfigLoadingHandler.addInsulationSlotConfigs(insulationSlots);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulation slots configs", insulationSlots.size()), insulationSlots);
        Collection<BlockTempData> blockTemps = event.getRegistry(ModRegistries.BLOCK_TEMP_DATA);
        ConfigLoadingHandler.addBlockTempConfigs(blockTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s block temperatures", blockTemps.size()), blockTemps);
        Collection<BiomeTempData> biomeTemps = event.getRegistry(ModRegistries.BIOME_TEMP_DATA);
        ConfigLoadingHandler.addBiomeTempConfigs(biomeTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s biome temperatures", biomeTemps.size()), biomeTemps);
        Collection<DimensionTempData> dimensionTemps = event.getRegistry(ModRegistries.DIMENSION_TEMP_DATA);
        ConfigLoadingHandler.addDimensionTempConfigs(dimensionTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s dimension temperatures", dimensionTemps.size()), dimensionTemps);
        Collection<StructureTempData> structureTemps = event.getRegistry(ModRegistries.STRUCTURE_TEMP_DATA);
        ConfigLoadingHandler.addStructureTempConfigs(structureTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s structure temperatures", structureTemps.size()), structureTemps);
        Collection<DepthTempData> depthTemps = event.getRegistry(ModRegistries.DEPTH_TEMP_DATA);
        ConfigLoadingHandler.addDepthTempConfigs(depthTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s depth temperatures", depthTemps.size()), depthTemps);
        Collection<MountData> mounts = event.getRegistry(ModRegistries.MOUNT_DATA);
        ConfigLoadingHandler.addMountConfigs(mounts);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulated mounts", mounts.size()), mounts);
        Collection<SpawnBiomeData> spawnBiomes = event.getRegistry(ModRegistries.ENTITY_SPAWN_BIOME_DATA);
        ConfigLoadingHandler.addSpawnBiomeConfigs(spawnBiomes, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity spawn biomes", spawnBiomes.size()), spawnBiomes);
        Collection<EntityTempData> entityTemps = event.getRegistry(ModRegistries.ENTITY_TEMP_DATA);
        ConfigLoadingHandler.addEntityTempConfigs(entityTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity temperatures", entityTemps.size()), entityTemps);
        Collection<EntityClimateData> entityClimates = event.getRegistry(ModRegistries.ENTITY_CLIMATE_DATA);
        ConfigLoadingHandler.addEntityClimateConfigs(entityClimates);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity climates", entityClimates.size()), entityClimates);
        Collection<TempEffectsData> tempEffects = event.getRegistry(ModRegistries.TEMP_EFFECTS_DATA);
        ConfigLoadingHandler.addTempEffectsConfigs(tempEffects);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s temp effects", tempEffects.size()), tempEffects);
        LoadRegistriesEvent.Post postEvent = new LoadRegistriesEvent.Post(registryAccess, event.getRegistries());
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    private static void logRegistryLoaded(String message, Collection<? extends ConfigData> registry) {
        message = registry.isEmpty() ? message + "." : message + ": [";
        StringBuilder messageBuilder = new StringBuilder(message);
        Iterator<? extends ConfigData> iterator = registry.iterator();
        while (iterator.hasNext()) {
            ConfigData data = iterator.next();
            if (data.registryKey().isPresent()) {
                messageBuilder.append(data.registryKey().get().func_240901_a_());
            }
            if (iterator.hasNext()) {
                messageBuilder.append(", ");
                continue;
            }
            messageBuilder.append("]");
        }
        ColdSweat.LOGGER.info(messageBuilder.toString(), (Object)registry.size());
        messageBuilder = new StringBuilder("Loaded external entries: ");
        boolean hasNameless = false;
        for (ConfigData configData : registry) {
            if (configData.registryKey().isPresent()) continue;
            messageBuilder.append("\n- ").append(configData);
            hasNameless = true;
        }
        if (hasNameless) {
            ColdSweat.LOGGER.debug(messageBuilder.toString());
        }
    }

    private static void setDefaultRegistryPriority(Multimap<RegistryHolder<?>, ? extends ConfigData> registries) {
        for (RegistryHolder key : registries.keySet()) {
            ArrayList<ConfigData> sortedHolders = new ArrayList<ConfigData>(registries.get((Object)key));
            sortedHolders.sort(Comparator.comparing(holder -> RegistryHelper.getKey(holder).func_110623_a().startsWith("default") ? 1 : 0));
            registries.replaceValues((Object)key, sortedHolders);
        }
    }

    private static void loadRegistryModifiers() {
        REGISTRY_MODIFIERS.clear();
        Collection<RegistryModifierData<?>> removals = ModRegistries.REGISTRY_MODIFIER_DATA.data().values();
        removals.addAll(ConfigLoadingHandler.parseConfigData(ModRegistries.REGISTRY_MODIFIER_DATA));
        removals.forEach(data -> {
            RegistryHolder key = ModRegistries.getRegistry(data.registry());
            REGISTRY_MODIFIERS.put(key, data);
        });
        ConfigLoadingHandler.setDefaultRegistryPriority(REGISTRY_MODIFIERS);
    }

    private static void modifyRegistries(Multimap<RegistryHolder<?>, ? extends ConfigData> registries) {
        ColdSweat.LOGGER.info("Handling registry modifiers...");
        for (Map.Entry entry : REGISTRY_MODIFIERS.asMap().entrySet()) {
            ConfigLoadingHandler.modifyEntries((Collection)entry.getValue(), registries.get(entry.getKey()));
        }
    }

    private static <T extends ConfigData> void modifyEntries(Collection<RegistryModifierData<T>> modifiers, Collection<T> registries) {
        ArrayList<T> newRegistries = new ArrayList<T>(registries);
        for (RegistryModifierData<ConfigData> registryModifierData : modifiers) {
            for (int i = 0; i < newRegistries.size(); ++i) {
                ConfigData element = (ConfigData)newRegistries.get(i);
                if (!registryModifierData.matches(element)) continue;
                ConfigData modified = registryModifierData.applyModifications(element);
                if (modified == null) {
                    newRegistries.remove(i);
                    --i;
                    continue;
                }
                newRegistries.set(i, modified);
            }
        }
        registries.clear();
        registries.addAll(newRegistries);
    }

    public static <C, K, V extends ConfigData> void modifyEntries(C registries, RegistryHolder<V> registry, Function<C, Collection<Map.Entry<K, V>>> entryGetter, Consumer<Map.Entry<K, V>> entrySetter, Consumer<Map.Entry<K, V>> entryRemover) {
        ConfigLoadingHandler.getRegistryModifiers(registry).forEach(modifier -> {
            if (modifier.registry().equals(registry.key())) {
                for (Map.Entry entry : (Collection)entryGetter.apply(registries)) {
                    ConfigData value = (ConfigData)entry.getValue();
                    if (!modifier.matches(value)) continue;
                    ConfigData modified = modifier.applyModifications(value);
                    if (modified == null) {
                        entryRemover.accept(entry);
                        continue;
                    }
                    entrySetter.accept(new AbstractMap.SimpleEntry(entry.getKey(), modified));
                }
            }
        });
    }

    public static <T extends ConfigData> void modifyEntries(List<T> registries, RegistryHolder<T> registry) {
        ConfigLoadingHandler.modifyEntries(registries, registry, list -> {
            ArrayList entries = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                entries.add(new AbstractMap.SimpleEntry(i, list.get(i)));
            }
            return entries;
        }, entry -> {
            ConfigData cfr_ignored_0 = (ConfigData)registries.set((Integer)entry.getKey(), entry.getValue());
        }, entry -> {
            ConfigData cfr_ignored_0 = (ConfigData)registries.remove((Integer)entry.getKey());
        });
    }

    public static <K, T extends ConfigData> void modifyEntries(Map<K, T> registries, RegistryHolder<T> registry) {
        ConfigLoadingHandler.modifyEntries(registries, registry, Map::entrySet, entry -> {
            ConfigData cfr_ignored_0 = (ConfigData)registries.put(entry.getKey(), entry.getValue());
        }, entry -> {
            ConfigData cfr_ignored_0 = (ConfigData)registries.remove(entry.getKey());
        });
    }

    public static <K, T extends ConfigData> void modifyEntries(Multimap<K, T> registries, RegistryHolder<T> registry) {
        HashMap tempMap = new HashMap();
        for (Object e : registries.keySet()) {
            ArrayList modifiedList = new ArrayList(registries.get(e));
            ConfigLoadingHandler.modifyEntries(modifiedList, registry);
            tempMap.put(e, modifiedList);
        }
        registries.clear();
        for (Map.Entry entry : tempMap.entrySet()) {
            registries.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
    }

    public static <T extends ConfigData> boolean isRemoved(T entry, RegistryHolder<T> registry) {
        return ConfigLoadingHandler.getRegistryModifiers(registry).stream().anyMatch(data -> data.matches(entry));
    }

    public static <T extends ConfigData> Collection<RegistryModifierData<T>> getRegistryModifiers(RegistryHolder<T> registry) {
        return REGISTRY_MODIFIERS.get(registry);
    }

    private static void addInsulatorConfigs(Collection<InsulatorData> insulators) {
        insulators.forEach(insulator -> {
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(insulator.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                switch (insulator.slot()) {
                    case ITEM: {
                        ConfigSettings.INSULATION_ITEMS.get().put((Object)item, insulator);
                        break;
                    }
                    case ARMOR: {
                        ConfigSettings.INSULATING_ARMORS.get().put((Object)item, insulator);
                        break;
                    }
                    case CURIO: {
                        if (!CompatManager.isCuriosLoaded()) break;
                        ConfigSettings.INSULATING_CURIOS.get().put((Object)item, insulator);
                    }
                }
            }
        });
    }

    private static void addFuelConfigs(Collection<FuelData> fuels) {
        fuels.forEach(fuelData -> {
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(fuelData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                switch (fuelData.fuelType()) {
                    case BOILER: {
                        ConfigSettings.BOILER_FUEL.get().put((Object)item, fuelData);
                        break;
                    }
                    case ICEBOX: {
                        ConfigSettings.ICEBOX_FUEL.get().put((Object)item, fuelData);
                        break;
                    }
                    case HEARTH: {
                        ConfigSettings.HEARTH_FUEL.get().put((Object)item, fuelData);
                        break;
                    }
                    case SOUL_LAMP: {
                        ConfigSettings.SOULSPRING_LAMP_FUEL.get().put((Object)item, fuelData);
                    }
                }
            }
        });
    }

    private static void addFoodConfigs(Collection<FoodData> foods) {
        foods.forEach(foodData -> {
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(foodData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.FOOD_TEMPERATURES.get().put((Object)item, foodData);
            }
        });
    }

    private static void addItemTempConfigs(Collection<ItemTempData> itemTemps) {
        itemTemps.forEach(itemTempData -> {
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(itemTempData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.ITEM_TEMPERATURES.get().put((Object)item, itemTempData);
            }
        });
    }

    private static void addDryingItemConfigs(Collection<DryingItemData> dryingItems) {
        dryingItems.forEach(dryingItemData -> {
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(dryingItemData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.DRYING_ITEMS.get().put((Object)item, dryingItemData);
            }
        });
    }

    private static void addInsulationSlotConfigs(Collection<ItemInsulationSlotsData> insulationSlots) {
        insulationSlots.forEach(insulationSlotData -> {
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(insulationSlotData.item().flatten(ItemRequirement::items)));
            if (items.isEmpty()) {
                return;
            }
            for (Item item : items) {
                ConfigSettings.INSULATION_SLOT_OVERRIDES.get().put((Object)item, insulationSlotData);
            }
        });
    }

    private static void addBlockTempConfigs(Collection<BlockTempData> blockTemps) {
        blockTemps.forEach(blockTempData -> {
            ConfiguredBlockTemp blockTemp = new ConfiguredBlockTemp((BlockTempData)blockTempData);
            BlockTempRegistry.register(blockTemp);
        });
    }

    private static void addBiomeTempConfigs(Collection<BiomeTempData> biomeTemps, DynamicRegistries registryAccess) {
        biomeTemps.forEach(biomeTempData -> {
            for (Biome biome : biomeTempData.biomes().flatList()) {
                if (biomeTempData.isOffset()) {
                    ConfigSettings.BIOME_OFFSETS.get(registryAccess).put(biome, (BiomeTempData)biomeTempData);
                    continue;
                }
                ConfigSettings.BIOME_TEMPS.get(registryAccess).put(biome, (BiomeTempData)biomeTempData);
            }
        });
    }

    private static void addDimensionTempConfigs(Collection<DimensionTempData> dimensionTemps, DynamicRegistries registryAccess) {
        dimensionTemps.forEach(dimensionTempData -> {
            for (DimensionType dimension : dimensionTempData.dimensions().flatList()) {
                if (dimensionTempData.isOffset()) {
                    ConfigSettings.DIMENSION_OFFSETS.get(registryAccess).put(dimension, (DimensionTempData)dimensionTempData);
                    continue;
                }
                ConfigSettings.DIMENSION_TEMPS.get(registryAccess).put(dimension, (DimensionTempData)dimensionTempData);
            }
        });
    }

    private static void addStructureTempConfigs(Collection<StructureTempData> structureTemps, DynamicRegistries registryAccess) {
        structureTemps.forEach(structureTempData -> {
            for (StructureFeature<?, ?> structure : structureTempData.structures().flatList()) {
                if (structureTempData.isOffset()) {
                    ConfigSettings.STRUCTURE_OFFSETS.get(registryAccess).put(structure, (StructureTempData)structureTempData);
                    continue;
                }
                ConfigSettings.STRUCTURE_TEMPS.get(registryAccess).put(structure, (StructureTempData)structureTempData);
            }
        });
    }

    private static void addDepthTempConfigs(Collection<DepthTempData> depthTemps) {
        for (DepthTempData depthData : depthTemps) {
            for (DimensionType dimension : depthData.dimensions().flatList()) {
                ConfigSettings.DEPTH_REGIONS.get().put((Object)dimension, (Object)depthData);
            }
        }
    }

    private static void addMountConfigs(Collection<MountData> mounts) {
        mounts.forEach(mountData -> {
            ArrayList entities = new ArrayList(RegistryHelper.mapTaggableList(mountData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.INSULATED_MOUNTS.get().put((Object)entity, mountData);
            }
        });
    }

    private static void addSpawnBiomeConfigs(Collection<SpawnBiomeData> spawnBiomes, DynamicRegistries registryAccess) {
        spawnBiomes.forEach(spawnBiomeData -> {
            for (Biome biome : spawnBiomeData.biomes().flatList()) {
                ConfigSettings.ENTITY_SPAWN_BIOMES.get(registryAccess).put((Object)biome, spawnBiomeData);
            }
        });
    }

    private static void addEntityTempConfigs(Collection<EntityTempData> entityTemps) {
        entityTemps.forEach(entityTempData -> {
            ArrayList entities = new ArrayList(RegistryHelper.mapTaggableList(entityTempData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_TEMPERATURES.get().put((Object)entity, entityTempData);
            }
        });
    }

    private static void addEntityClimateConfigs(Collection<EntityClimateData> entityTemps) {
        entityTemps.forEach(entityTempData -> {
            ArrayList entities = new ArrayList(RegistryHelper.mapTaggableList(entityTempData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_CLIMATES.get().put((Object)entity, entityTempData);
            }
        });
    }

    private static void addTempEffectsConfigs(Collection<TempEffectsData> tempEffects) {
        tempEffects.forEach(tempEffectsData -> {
            ArrayList entities = new ArrayList(RegistryHelper.mapTaggableList(tempEffectsData.entity().flatten(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                return;
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_TEMP_EFFECTS.get().put((Object)entity, tempEffectsData);
            }
        });
    }

    private static <T extends ConfigData> List<T> parseConfigData(RegistryHolder<T> registry) {
        RegistryKey registryKey = registry.key();
        ArrayList output = new ArrayList();
        JsonOps registryOps = JsonOps.INSTANCE;
        String configFolder = registryKey.func_240901_a_().func_110624_b().replace("_", "");
        Path coldSweatDataPath = FMLPaths.CONFIGDIR.get().resolve(configFolder + "/data").resolve(registryKey.func_240901_a_().func_110623_a());
        File jsonDirectory = coldSweatDataPath.toFile();
        if (!jsonDirectory.exists()) {
            return output;
        }
        for (File file : ConfigLoadingHandler.findFilesRecursive(jsonDirectory)) {
            if (!file.getName().endsWith(".json")) continue;
            try {
                FileReader reader = new FileReader(file);
                Throwable throwable = null;
                try {
                    JsonObject json = JSONUtils.func_212743_a((Reader)reader);
                    if (!ConfigLoadingHandler.shouldLoadJSON(registryKey, file.getPath(), json)) continue;
                    registry.codec().decode((DynamicOps)registryOps, (Object)JSONUtils.func_212743_a((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)ColdSweat.LOGGER).error(arg_0)).map(Pair::getFirst).ifPresent(configData -> {
                        configData.setConfigType(ConfigData.Type.JSON);
                        configData.setRegistryKey((RegistryKey<? extends ConfigData>)RegistryKey.func_240903_a_((RegistryKey)registryKey, (ResourceLocation)new ResourceLocation("cold_sweat", file.getPath())));
                        output.add(configData);
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to parse JSON config setting in {}: {}", (Object)registryKey.func_240901_a_(), (Object)file.getName(), (Object)e);
            }
        }
        return output;
    }

    private static boolean shouldLoadJSON(RegistryKey registryKey, String elementName, JsonObject json) {
        if (json.has("required_mods")) {
            JsonArray requiredMods = new JsonArray();
            JsonArray excludedMods = new JsonArray();
            JsonElement requiredModField = json.get("required_mods");
            if (requiredModField.isJsonArray()) {
                requiredMods = requiredModField.getAsJsonArray();
            } else {
                JsonObject requiredModCompound = requiredModField.getAsJsonObject();
                if (requiredModCompound.has("require")) {
                    requiredMods = requiredModCompound.getAsJsonArray("require");
                }
                if (requiredModCompound.has("exclude")) {
                    excludedMods = requiredModCompound.getAsJsonArray("exclude");
                }
            }
            for (JsonElement requiredMod : requiredMods) {
                if (CompatManager.modLoaded(requiredMod.getAsString())) continue;
                ColdSweat.LOGGER.warn("Skipping registration of {} {}: missing mod \"{}\"", (Object)registryKey.func_240901_a_(), (Object)elementName, (Object)requiredMod.getAsString());
                return true;
            }
            for (JsonElement excludedMod : excludedMods) {
                if (!CompatManager.modLoaded(excludedMods.getAsString())) continue;
                ColdSweat.LOGGER.warn("Skipping registration of {} {}: disallowed mod \"{}\" is loaded", (Object)registryKey.func_240901_a_(), (Object)elementName, (Object)excludedMod.getAsString());
                return true;
            }
        }
        return true;
    }

    public static List<File> findFilesRecursive(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] filesInDirectory = directory.listFiles();
        if (filesInDirectory == null) {
            return files;
        }
        for (File file : filesInDirectory) {
            if (file.isDirectory()) {
                files.addAll(ConfigLoadingHandler.findFilesRecursive(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ClientConfigs {
        @SubscribeEvent
        public static void loadClientConfigs(FMLLoadCompleteEvent event) {
            ConfigSettings.CLIENT_SETTINGS.forEach((id, holder) -> holder.load(true));
        }
    }
}

